/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.lang.reflect.Field;
import java.sql.Date;
import java.text.DateFormat;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.AbstractDataTypeComponentTest;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeDate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataTypeDateTest
extends AbstractDataTypeComponentTest {
    private static int userDefinedDateFormat = 2;

    @Override
    @Before
    public void setUp() throws Exception {
        ColumnDisplayDefinition columnDisplayDefinition = this.getMockColumnDisplayDefinition();
        this.mockHelper.replayAll();
        this.classUnderTest = new DataTypeDate(null, columnDisplayDefinition);
        this.mockHelper.resetAll();
        super.setUp();
    }

    @Test
    public void testGetReadDateAsTimestamp() {
        DTProperties.put((String)DataTypeDate.class.getName(), (String)"readDateAsTimestamp", (String)"false");
        Assert.assertFalse((String)"Expected default value to be false for read date as timestamp", (boolean)DataTypeDate.getReadDateAsTimestamp());
        DTProperties.put((String)DataTypeDate.class.getName(), (String)"readDateAsTimestamp", (String)"true");
        Assert.assertTrue((String)"Expected the user specified value", (boolean)DataTypeDate.getReadDateAsTimestamp());
    }

    @Test
    public void testUseDefaultDateFormatAfterLoadingProperties() throws Exception {
        this.resetPropertiesLoadedFlag();
        DTProperties.put((String)DataTypeDate.class.getName(), (String)"useJavaDefaultFormat", (String)"true");
        this.classUnderTest = new DataTypeDate(null, this.getMockColumnDisplayDefinition());
        Date currentDate = Date.valueOf("2010-10-15");
        String renderedDate = this.classUnderTest.renderObject((Object)currentDate);
        Assert.assertEquals((String)"Must use the default format", (Object)"2010-10-15", (Object)renderedDate);
    }

    @Test
    public void testUseCustomDateFormatAfterLoadingProperties() throws Exception {
        this.resetPropertiesLoadedFlag();
        DTProperties.put((String)DataTypeDate.class.getName(), (String)"useJavaDefaultFormat", (String)"false");
        DTProperties.put((String)DataTypeDate.class.getName(), (String)"localeFormat", (String)"2");
        DTProperties.put((String)DataTypeDate.class.getName(), (String)"lenient", (String)"false");
        this.classUnderTest = new DataTypeDate(null, this.getMockColumnDisplayDefinition());
        Date currentDate = Date.valueOf("2010-10-15");
        String expectedDate = DateFormat.getDateInstance(userDefinedDateFormat).format(currentDate);
        String renderedDate = this.classUnderTest.renderObject((Object)currentDate);
        Assert.assertEquals((String)"Must use the user defined format", (Object)expectedDate, (Object)renderedDate);
    }

    @Override
    protected Object getEqualsTestObject() {
        return new Date(System.currentTimeMillis());
    }

    private void resetPropertiesLoadedFlag() throws Exception {
        Field field = DataTypeDate.class.getDeclaredField("propertiesAlreadyLoaded");
        field.setAccessible(true);
        field.set(null, false);
    }
}

