/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import junit.framework.TestCase;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class GUIUtilsTest
extends TestCase {
    static final String LENGTH_10 = "123456789 ";
    static final String LENGTH_20 = "123456789 123456789 ";
    static final String LENGTH_40 = "123456789 123456789 123456789 123456789 ";
    static final String LENGTH_80 = "123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 ";
    static final String LENGTH_160 = "123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 ";

    public void testGetWrappedLine() {
        this.assertEquality(LENGTH_80, 40, 2, this.trimLength(LENGTH_40));
        this.assertEquality(LENGTH_80, 20, 4, this.trimLength(LENGTH_20));
        this.assertEquality(LENGTH_20, 15, 2, this.trimLength(LENGTH_10));
        this.assertEquality(LENGTH_20, 40, 1, LENGTH_20.length());
        this.assertEquality(LENGTH_160, 80, 2, this.trimLength(LENGTH_80));
        this.assertEquality(LENGTH_10, 5, 1, -1);
    }

    private void assertEquality(String origLine, int maxLineSize, int expPartsArrayLength, int expPartLenth) {
        String wrappedLine = GUIUtils.getWrappedLine((String)origLine, (int)maxLineSize);
        String[] parts = wrappedLine.split("\\n");
        GUIUtilsTest.assertEquals((String)"number of newlines in word-wrapped string", (int)expPartsArrayLength, (int)parts.length);
        if (expPartLenth != -1) {
            for (int i = 0; i < parts.length; ++i) {
                GUIUtilsTest.assertEquals((String)("length of parts[" + i + "]"), (int)expPartLenth, (int)parts[0].length());
            }
        }
    }

    private int trimLength(String s) {
        return s.trim().length();
    }
}

