/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.gui.debug.DebugBorder;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DebugBorderTest
extends BaseSQuirreLJUnit4TestCase {
    private DebugBorder classUnderTest = null;
    private Border mockBorder = this.mockHelper.createMock(Border.class);
    private Component mockComponent = this.mockHelper.createMock(Component.class);
    private Insets insets = new Insets(1, 1, 1, 1);

    @Before
    public void setUp() throws Exception {
        this.classUnderTest = new DebugBorder(this.mockBorder);
    }

    @After
    public void tearDown() throws Exception {
        this.classUnderTest = null;
        this.mockHelper.resetAll();
    }

    @Test
    public void testPaintBorder() {
        Graphics g = this.mockHelper.createMock(Graphics.class);
        int x = 0;
        int y = 0;
        int width = 10;
        int height = 10;
        this.mockBorder.paintBorder(this.mockComponent, g, x, y, width, height);
        EasyMock.expect((Object)this.mockBorder.getBorderInsets(this.mockComponent)).andStubReturn((Object)this.insets);
        g.setColor((Color)EasyMock.isA(Color.class));
        g.fillRect(EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt());
        EasyMock.expectLastCall().anyTimes();
        this.mockHelper.replayAll();
        this.classUnderTest.paintBorder(this.mockComponent, g, x, y, width, height);
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetBorderInsets() {
        EasyMock.expect((Object)this.mockBorder.getBorderInsets(this.mockComponent)).andReturn((Object)this.insets);
        this.mockHelper.replayAll();
        Assert.assertEquals((Object)this.insets, (Object)this.classUnderTest.getBorderInsets(this.mockComponent));
        this.mockHelper.verifyAll();
    }

    @Test
    public void testIsBorderOpaque() {
        EasyMock.expect((Object)this.mockBorder.isBorderOpaque()).andStubReturn((Object)true);
        this.mockHelper.replayAll();
        Assert.assertTrue((boolean)this.classUnderTest.isBorderOpaque());
        this.mockHelper.verifyAll();
    }

    @Test
    public void testGetDelegate() {
        this.mockHelper.replayAll();
        Assert.assertEquals((Object)this.mockBorder, (Object)this.classUnderTest.getDelegate());
        this.mockHelper.verifyAll();
    }
}

