/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import com.gargoylesoftware.base.testing.EqualsTester;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.FwTestUtil;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatabaseObjectInfoTest
extends BaseSQuirreLJUnit4TestCase {
    DatabaseObjectInfo dboInfoUnderTest = null;
    ISQLDatabaseMetaData oracleSQLDatabaseMetaData = null;
    ISQLDatabaseMetaData h2SQLDatabaseMetaData = null;
    ISQLDatabaseMetaData sybase12SQLDatabaseMeta = null;
    ISQLDatabaseMetaData sybase15SQLDatabaseMeta = null;
    String testCatalog = "TestCatalog";
    String testSchema = "TestSchema";

    @Before
    public void setUp() throws Exception {
        this.oracleSQLDatabaseMetaData = FwTestUtil.getEasyMockSQLMetaData("oracle", "jdbc:oracle:thin@", false, true);
        this.h2SQLDatabaseMetaData = FwTestUtil.getEasyMockH2SQLMetaData();
        this.sybase12SQLDatabaseMeta = FwTestUtil.getEasyMockSybase12SQLMetaData();
        this.sybase15SQLDatabaseMeta = FwTestUtil.getEasyMockSybase15SQLMetaData();
    }

    @After
    public void tearDown() throws Exception {
        this.h2SQLDatabaseMetaData = null;
        this.oracleSQLDatabaseMetaData = null;
        this.sybase12SQLDatabaseMeta = null;
        this.sybase15SQLDatabaseMeta = null;
    }

    @Test
    public final void testGetQualifiedNameH2() throws Exception {
        String tableName = "foo\"\"bar";
        this.dboInfoUnderTest = new DatabaseObjectInfo(this.testCatalog, this.testSchema, tableName, DatabaseObjectType.TABLE, this.h2SQLDatabaseMetaData);
        String identifierQuoteString = this.h2SQLDatabaseMetaData.getIdentifierQuoteString();
        String sep = this.h2SQLDatabaseMetaData.getCatalogSeparator();
        String expectedQualifiedName = identifierQuoteString + this.testSchema + identifierQuoteString + sep + identifierQuoteString + "foo\"\"\"\"bar" + identifierQuoteString;
        String qn = this.dboInfoUnderTest.getQualifiedName();
        Assert.assertEquals((Object)expectedQualifiedName, (Object)qn);
    }

    @Test
    public final void testGetQualifiedNameSybase12() throws Exception {
        String tableName = "mytable";
        ISQLDatabaseMetaData md = this.sybase12SQLDatabaseMeta;
        Assert.assertEquals((Object)"Adaptive Server Enterprise", (Object)md.getDatabaseProductName());
        this.dboInfoUnderTest = new DatabaseObjectInfo(this.testCatalog, this.testSchema, tableName, DatabaseObjectType.TABLE, md);
        String identifierQuoteString = md.getIdentifierQuoteString();
        Assert.assertEquals((Object)"\"", (Object)identifierQuoteString);
        String sep = md.getCatalogSeparator();
        String expected = this.testCatalog + sep + this.testSchema + sep + tableName;
        String actual = this.dboInfoUnderTest.getQualifiedName();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public final void testGetQualifiedNameSybase15() throws Exception {
        String tableName = "mytable";
        ISQLDatabaseMetaData md = this.sybase15SQLDatabaseMeta;
        Assert.assertEquals((Object)"Adaptive Server Enterprise", (Object)md.getDatabaseProductName());
        this.dboInfoUnderTest = new DatabaseObjectInfo(this.testCatalog, this.testSchema, tableName, DatabaseObjectType.TABLE, md);
        String identifierQuoteString = md.getIdentifierQuoteString();
        Assert.assertEquals((Object)"\"", (Object)identifierQuoteString);
        String sep = md.getCatalogSeparator();
        String expected = identifierQuoteString + this.testCatalog + identifierQuoteString + sep + identifierQuoteString + this.testSchema + identifierQuoteString + sep + identifierQuoteString + tableName + identifierQuoteString;
        String actual = this.dboInfoUnderTest.getQualifiedName();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public final void testEqualsAndHashcode() {
        DatabaseObjectInfo a = new DatabaseObjectInfo(this.testCatalog, this.testSchema, "table1", DatabaseObjectType.TABLE, this.h2SQLDatabaseMetaData);
        DatabaseObjectInfo b = new DatabaseObjectInfo(this.testCatalog, this.testSchema, "table1", DatabaseObjectType.TABLE, this.h2SQLDatabaseMetaData);
        DatabaseObjectInfo c = new DatabaseObjectInfo(this.testCatalog, this.testSchema, "table2", DatabaseObjectType.TABLE, this.h2SQLDatabaseMetaData);
        MyDatabaseObjectInfo d = new MyDatabaseObjectInfo(this.testCatalog, this.testSchema, "table1", DatabaseObjectType.TABLE, this.h2SQLDatabaseMetaData);
        new EqualsTester((Object)a, (Object)b, (Object)c, (Object)d);
    }

    private static class MyDatabaseObjectInfo
    extends DatabaseObjectInfo {
        public MyDatabaseObjectInfo(String catalog, String schema, String simpleName, DatabaseObjectType dboType, ISQLDatabaseMetaData md) {
            super(catalog, schema, simpleName, dboType, md);
        }
    }
}

