/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.squirrel_sql.BaseSQuirreLTestCase;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;

public class JDBCTypeMapperTest
extends BaseSQuirreLTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetJdbcTypeList() {
        String[] typeListArr = JDBCTypeMapper.getJdbcTypeList();
        List<String> typeList = Arrays.asList(typeListArr);
        HashSet<String> s = new HashSet<String>();
        s.addAll(typeList);
        Field[] fields = Types.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String fieldName = field.getName();
            JDBCTypeMapperTest.assertTrue((String)("JDBCTypeMapper.getJdbcTypeList() did not return an item for type: " + fieldName), (boolean)s.contains(fieldName));
        }
    }

    public void testGetJdbcTypeName() throws Exception {
        Field[] fields = Types.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String fieldName = field.getName();
            int jdbcType = field.getInt(null);
            String typeName = JDBCTypeMapper.getJdbcTypeName((int)jdbcType);
            JDBCTypeMapperTest.assertEquals((String)fieldName, (String)typeName);
        }
    }

    public void testGetJdbcType() throws Exception {
        Field[] fields = Types.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String fieldName = field.getName();
            int expectedType = field.getInt(null);
            int actualType = JDBCTypeMapper.getJdbcType((String)fieldName);
            JDBCTypeMapperTest.assertEquals((String)("Field name=" + fieldName), (int)expectedType, (int)actualType);
        }
        JDBCTypeMapperTest.assertEquals((String)"Field name=null", (int)0, (int)JDBCTypeMapper.getJdbcType(null));
    }

    public void testIsNumberType() throws Exception {
        Integer[] numberTypes = new Integer[]{-5, 3, 8, 6, 4, 2};
        HashSet<Integer> s = new HashSet<Integer>();
        s.addAll(Arrays.asList(numberTypes));
        this.testIsType(s, new NumberTypeCheck());
    }

    public void testIsDateType() throws Exception {
        Integer[] dateTypes = new Integer[]{91, 92, 93};
        HashSet<Integer> s = new HashSet<Integer>();
        s.addAll(Arrays.asList(dateTypes));
        this.testIsType(s, new DateTypeCheck());
    }

    public void testIsLongType() throws Exception {
        Integer[] longTypes = new Integer[]{-4, -1, 2004, 2005};
        HashSet<Integer> s = new HashSet<Integer>();
        s.addAll(Arrays.asList(longTypes));
        this.testIsType(s, new LongTypeCheck());
    }

    public void testIsType(Set<Integer> s, TypeCheck checker) throws Exception {
        Field[] fields = Types.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String fieldName = field.getName();
            Integer jdbcType = field.getInt(null);
            if (s.contains(jdbcType)) {
                JDBCTypeMapperTest.assertTrue((String)("Field name=" + fieldName), (boolean)checker.isType(jdbcType));
                continue;
            }
            JDBCTypeMapperTest.assertFalse((String)("Field name=" + fieldName), (boolean)checker.isType(jdbcType));
        }
    }

    public void testIsStandardType() throws Exception {
        JDBCTypeMapperTest.assertTrue((boolean)JDBCTypeMapper.isStandardType((int)12));
    }

    private class LongTypeCheck
    implements TypeCheck {
        private LongTypeCheck() {
        }

        @Override
        public boolean isType(int type) {
            return JDBCTypeMapper.isLongType((int)type);
        }
    }

    private class DateTypeCheck
    implements TypeCheck {
        private DateTypeCheck() {
        }

        @Override
        public boolean isType(int type) {
            return JDBCTypeMapper.isDateType((int)type);
        }
    }

    private class NumberTypeCheck
    implements TypeCheck {
        private NumberTypeCheck() {
        }

        @Override
        public boolean isType(int type) {
            return JDBCTypeMapper.isNumberType((int)type);
        }
    }

    private static interface TypeCheck {
        public boolean isType(int var1);
    }
}

