/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import junit.framework.TestCase;
import net.sourceforge.squirrel_sql.fw.sql.GenericSQL;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.QueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtil;

public class QueryTokenizerTest
extends TestCase
implements GenericSQL {
    static String nullSQL = null;
    static String tmpFilename = null;
    static boolean removeMultilineComment = true;
    QueryTokenizer qt = null;

    public void testHasQueryOne() {
        this.qt = new QueryTokenizer(";", "--", removeMultilineComment);
        this.qt.setScriptToTokenize("create table student (     sno     integer,     sname   varchar(10),     age     integer ); ");
        SQLUtil.checkQueryTokenizer((IQueryTokenizer)this.qt, 1);
        this.qt = new QueryTokenizer(";", "--", removeMultilineComment);
        this.qt.setScriptToTokenize("create table courses (     cno     varchar(5),     title   varchar(10),     credits integer ); ");
        SQLUtil.checkQueryTokenizer((IQueryTokenizer)this.qt, 1);
        this.qt = new QueryTokenizer(";", "--", removeMultilineComment);
        this.qt.setScriptToTokenize("select * from student where sno not in (select sno                   from take                   where cno = 'CS112'); ");
        SQLUtil.checkQueryTokenizer((IQueryTokenizer)this.qt, 1);
    }

    public void testEmbeddedComments() {
        this.qt = new QueryTokenizer(";", "--", false);
        this.qt.setScriptToTokenize("CREATE PROCEDURE TRANSFER (:FROM CHAR(7),:TO CHAR(7),:AMOUNT DECIMAL(7,2)) BEGIN /* remove the amount from FROM account */ UPDATE ACCOUNTS SET BALANCE = BALANCE - :AMOUNT WHERE ACCOUNT_ID = :FROM ; /* add the amount to TO account */ UPDATE ACCOUNTS SET BALANCE = BALANCE + AMOUNT WHERE ACCOUNT_ID = :TO ; END; ");
        StringBuffer sql = new StringBuffer();
        while (this.qt.hasQuery()) {
            sql.append(this.qt.nextQuery());
            sql.append(";");
        }
        int firstCommentIndex = sql.indexOf("/* remove");
        QueryTokenizerTest.assertTrue((String)"first comment not found", (firstCommentIndex != -1 ? 1 : 0) != 0);
        int secondCommentIndex = sql.indexOf("/* add");
        QueryTokenizerTest.assertTrue((String)"second comment not found", (secondCommentIndex != -1 ? 1 : 0) != 0);
    }

    public void testHasQueryAll() {
        this.qt = new QueryTokenizer(";", "--", removeMultilineComment);
        this.qt.setScriptToTokenize(SQLUtil.getGenericSQLScript());
        SQLUtil.checkQueryTokenizer((IQueryTokenizer)this.qt, SQLUtil.getGenericSQLCount());
    }
}

