/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.io.IOException;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLWarning;
import net.sourceforge.squirrel_sql.BaseSQuirreLJUnit4TestCase;
import net.sourceforge.squirrel_sql.fw.sql.SQLExecutionException;
import net.sourceforge.squirrel_sql.fw.util.DefaultExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultExceptionFormatterTest
extends BaseSQuirreLJUnit4TestCase {
    DefaultExceptionFormatter formatterUnderTest;

    @Before
    public void setUp() throws Exception {
        this.formatterUnderTest = new DefaultExceptionFormatter();
    }

    @After
    public void tearDown() throws Exception {
        this.formatterUnderTest = null;
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testNullThrowableFormat() {
        this.formatterUnderTest.format(null);
    }

    @Test
    public final void testDefaultFormatForDataTruncationRead() {
        DataTruncation dt = new DataTruncation(1, true, true, 20, 3);
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException((Throwable)dt));
        String formattedException = this.formatterUnderTest.format((Throwable)dt);
        StringBuilder expectedMessage = new StringBuilder("Data Truncation error occured on");
        expectedMessage.append(" a read ");
        expectedMessage.append(" of column ");
        expectedMessage.append(1);
        expectedMessage.append("Data was ");
        expectedMessage.append(20);
        expectedMessage.append(" bytes long and ");
        expectedMessage.append(3);
        expectedMessage.append(" bytes were transferred.");
        Assert.assertEquals((Object)expectedMessage.toString(), (Object)formattedException);
    }

    @Test
    public void testDefaultFormatForDataTruncationWrite() {
        DataTruncation dt = new DataTruncation(1, true, false, 20, 3);
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException((Throwable)dt));
        StringBuilder expectedMessage = new StringBuilder("Data Truncation error occured on");
        expectedMessage.append(" a write ");
        expectedMessage.append(" of column ");
        expectedMessage.append(1);
        expectedMessage.append("Data was ");
        expectedMessage.append(20);
        expectedMessage.append(" bytes long and ");
        expectedMessage.append(3);
        expectedMessage.append(" bytes were transferred.");
        String formattedException = this.formatterUnderTest.format((Throwable)dt);
        Assert.assertEquals((Object)expectedMessage.toString(), (Object)formattedException);
    }

    @Test
    public void testDefaultFormatForException() {
        Exception ex = new Exception("table not found");
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException((Throwable)ex));
        StringBuilder expectedMessage = new StringBuilder("java.lang.Exception: table not found");
        String formattedException = this.formatterUnderTest.format((Throwable)ex);
        Assert.assertEquals((Object)expectedMessage.toString(), (Object)formattedException);
    }

    @Test
    public void testDefaultFormatForSQLWarning() {
        SQLWarning ex = new SQLWarning("low on memory", "WarningState", 1000);
        SQLExecutionException ee = new SQLExecutionException((Throwable)ex, "postError");
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException((Throwable)ex));
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException((Throwable)ee));
        StringBuilder expectedMessage = new StringBuilder("Warning:   low on memory\n");
        expectedMessage.append("SQLState:  WarningState\n");
        expectedMessage.append("ErrorCode: 1000\n");
        expectedMessage.append("postError");
        String formattedException = this.formatterUnderTest.format((Throwable)ee);
        Assert.assertEquals((Object)expectedMessage.toString(), (Object)formattedException);
    }

    @Test
    public final void testFormatsException() {
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException(new Throwable()));
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException((Throwable)new SQLException()));
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException((Throwable)new SQLExecutionException((Throwable)new SQLException(), "")));
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException((Throwable)new SQLExecutionException((Throwable)new SQLException(), "some error")));
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException((Throwable)new SQLExecutionException((Throwable)new SQLException(), null)));
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException((Throwable)new IOException()));
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException((Throwable)new DataTruncation(0, true, true, 0, 0)));
        Assert.assertTrue((boolean)this.formatterUnderTest.formatsException((Throwable)new SQLWarning()));
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testSetNullCustomExceptionFormatter() {
        this.formatterUnderTest.setCustomExceptionFormatter(null);
    }

    @Test
    public final void testSetCustomExceptionFormatter() throws Exception {
        ExceptionFormatter formatter1 = (ExceptionFormatter)EasyMock.createMock(ExceptionFormatter.class);
        SQLException ex = new SQLException("table does not exist");
        SQLExecutionException ee = new SQLExecutionException((Throwable)ex, "");
        EasyMock.expect((Object)formatter1.formatsException((Throwable)EasyMock.isA(SQLException.class))).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)formatter1.format((Throwable)ex)).andReturn((Object)"foo").anyTimes();
        EasyMock.replay((Object[])new Object[]{formatter1});
        this.formatterUnderTest.setCustomExceptionFormatter(formatter1);
        String formattedEx = this.formatterUnderTest.format((Throwable)ee);
        EasyMock.verify((Object[])new Object[]{formatter1});
        Assert.assertEquals((Object)"foo", (Object)formattedEx);
    }

    @Test
    public final void testSetMultiCustomExceptionFormatter() throws Exception {
        ExceptionFormatter formatter1 = (ExceptionFormatter)EasyMock.createMock(ExceptionFormatter.class);
        ExceptionFormatter formatter2 = (ExceptionFormatter)EasyMock.createMock(ExceptionFormatter.class);
        SQLException ex = new SQLException("table does not exist");
        SQLExecutionException ee = new SQLExecutionException((Throwable)ex, "");
        EasyMock.expect((Object)formatter1.formatsException((Throwable)EasyMock.isA(SQLException.class))).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)formatter1.format((Throwable)ex)).andReturn((Object)"formatter1").anyTimes();
        EasyMock.expect((Object)formatter2.formatsException((Throwable)EasyMock.isA(SQLException.class))).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)formatter2.format((Throwable)ex)).andReturn((Object)"formatter2").anyTimes();
        EasyMock.replay((Object[])new Object[]{formatter1});
        EasyMock.replay((Object[])new Object[]{formatter2});
        this.formatterUnderTest.setCustomExceptionFormatter(formatter1);
        this.formatterUnderTest.setCustomExceptionFormatter(formatter2);
        String formattedEx = this.formatterUnderTest.format((Throwable)ee);
        EasyMock.verify((Object[])new Object[]{formatter1});
        EasyMock.verify((Object[])new Object[]{formatter2});
        Assert.assertEquals((Object)"formatter1", (Object)formattedEx);
    }
}

