/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sourceforge.squirrel_sql.BaseSQuirreLTestCase;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.util.ClassLoaderListener;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperImpl;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;
import net.sourceforge.squirrel_sql.fw.util.MyURLClassLoader;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.cli.Option;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.util.HttpURLConnection;
import org.apache.commons.logging.impl.SimpleLog;

public class MyURLClassLoaderTest
extends BaseSQuirreLTestCase {
    private static String COMMONS_CLI_JAR = "http://www.squirrelsql.org/downloads/commons-cli.jar";
    private static FileWrapper commonsCliTempFileWrapper = null;
    private static String ORACLE_PLUGIN_JAR = "http://www.squirrelsql.org/downloads/oracle.jar";
    private static FileWrapper oracleTempFileWrapper = null;
    private static String BOGUS_ZIP_FILE = "http://www.squirrelsql.org/downloads/log4j.properties";
    private static FileWrapper bogusZipTempFileWrapper = null;
    private static String EXTERNAL_DEPENDS_JAR = "http://www.squirrelsql.org/downloads/syntax.jar";
    private static FileWrapper extDependsTempFileWrapper = null;
    private static final String COMMONS_CLI_OPTION_CLASS = "org.apache.commons.cli.Option";
    private static final String ORACLE_JAR_CLASS = "net.sourceforge.squirrel_sql.plugins.oracle.common.AutoWidthResizeTable";
    private static final IOUtilities ioutils = new IOUtilitiesImpl();
    private static final ILogger s_log = LoggerController.createLogger(MyURLClassLoaderTest.class);

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (oracleTempFileWrapper == null) {
            this.downloadTestFiles();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        oracleTempFileWrapper.deleteOnExit();
        bogusZipTempFileWrapper.deleteOnExit();
        extDependsTempFileWrapper.deleteOnExit();
        commonsCliTempFileWrapper.deleteOnExit();
    }

    public void testMyURLClassLoaderString() {
        try {
            MyURLClassLoader loader = new MyURLClassLoader(".");
            loader.getAssignableClasses(IQueryTokenizer.class, s_log);
        }
        catch (IOException e) {
            MyURLClassLoaderTest.fail((String)e.getMessage());
        }
    }

    public void testMyURLClassLoaderURL() throws Exception {
        this.getIQueryTokenizerAssignableClasses(commonsCliTempFileWrapper.toURL().toString());
    }

    private void downloadTestFiles() {
        MyURLClassLoaderTest.disableLogging(SimpleLog.class);
        MyURLClassLoaderTest.disableLogging(HttpMethodBase.class);
        MyURLClassLoaderTest.disableLogging(HttpConnection.class);
        MyURLClassLoaderTest.disableLogging(HttpClient.class);
        MyURLClassLoaderTest.disableLogging(DefaultHttpParams.class);
        MyURLClassLoaderTest.disableLogging(GetMethod.class);
        MyURLClassLoaderTest.disableLogging(HttpState.class);
        MyURLClassLoaderTest.disableLogging(HttpURLConnection.class);
        commonsCliTempFileWrapper = this.downloadTestFile(COMMONS_CLI_JAR, "commons-cli", ".jar");
        oracleTempFileWrapper = this.downloadTestFile(ORACLE_PLUGIN_JAR, "oracle", ".jar");
        bogusZipTempFileWrapper = this.downloadTestFile(BOGUS_ZIP_FILE, "log4j", ".properties");
        extDependsTempFileWrapper = this.downloadTestFile(EXTERNAL_DEPENDS_JAR, "syntax", ".jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileWrapper downloadTestFile(String urlStr, String localTempFilePrefix, String localTempFileSuffix) {
        InputStream is = null;
        FileWrapper result = null;
        try {
            URL url = new URL(urlStr);
            is = url.openStream();
            String prefix = "MyURLClassLoaderTest-" + localTempFilePrefix;
            result = FileWrapperImpl.createTempFile((String)prefix, (String)localTempFileSuffix);
            int bytesRead = ioutils.downloadHttpFile(url, result, null);
            MyURLClassLoaderTest.assertTrue((bytesRead > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                MyURLClassLoaderTest.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                ioutils.closeInputStream(is);
                throw throwable;
            }
            ioutils.closeInputStream(is);
        }
        ioutils.closeInputStream(is);
        return result;
    }

    public void testMyURLClassLoaderURLArray() {
        try {
            MyURLClassLoader loader = new MyURLClassLoader(new URL[]{oracleTempFileWrapper.toURL()});
            loader.findClass(ORACLE_JAR_CLASS);
        }
        catch (Exception e) {
            e.printStackTrace();
            MyURLClassLoaderTest.fail((String)e.getMessage());
        }
    }

    public void testAddClassLoaderListener() throws Exception {
        MyClassLoaderListener listener = new MyClassLoaderListener();
        MyURLClassLoader loader = this.getLoader(commonsCliTempFileWrapper.toURL().toString());
        loader.addClassLoaderListener((ClassLoaderListener)listener);
    }

    public void testRemoveClassLoaderListener() throws Exception {
        MyClassLoaderListener listener = new MyClassLoaderListener();
        MyURLClassLoader loader = this.getLoader(oracleTempFileWrapper.toURL().toString());
        loader.addClassLoaderListener((ClassLoaderListener)listener);
        loader.getAssignableClasses(IQueryTokenizer.class, s_log);
        MyURLClassLoaderTest.assertEquals((int)1, (int)listener.loadingZipFileCount);
        listener.loadingZipFileCount = 0;
        loader.removeClassLoaderListener((ClassLoaderListener)listener);
        loader.getAssignableClasses(IQueryTokenizer.class, s_log);
        MyURLClassLoaderTest.assertEquals((int)0, (int)listener.loadingZipFileCount);
    }

    public void testGetAssignableClasses() throws Exception {
        Class[] classes = this.getIQueryTokenizerAssignableClasses(commonsCliTempFileWrapper.toURL().toString());
        MyURLClassLoaderTest.assertEquals((int)0, (int)classes.length);
        classes = this.getIQueryTokenizerAssignableClasses(oracleTempFileWrapper.toURL().toString());
        MyURLClassLoaderTest.assertEquals((int)1, (int)classes.length);
        classes = this.getIQueryTokenizerAssignableClasses(bogusZipTempFileWrapper.toURL().toString());
        MyURLClassLoaderTest.assertEquals((int)0, (int)classes.length);
        classes = this.getIQueryTokenizerAssignableClasses(extDependsTempFileWrapper.toURL().toString());
        MyURLClassLoaderTest.assertEquals((int)0, (int)classes.length);
    }

    public void testFindClassString() throws Exception {
        MyURLClassLoader loader = this.getLoader(commonsCliTempFileWrapper.toURL().toString());
        try {
            loader.findClass(COMMONS_CLI_OPTION_CLASS);
        }
        catch (Exception e) {
            MyURLClassLoaderTest.fail((String)e.getMessage());
        }
    }

    public void testClassHasBeenLoaded() {
        try {
            MyURLClassLoader loader = this.getLoader(commonsCliTempFileWrapper.toURL().toString());
            loader.findClass(COMMONS_CLI_OPTION_CLASS);
            loader.classHasBeenLoaded(Option.class);
        }
        catch (Exception e) {
            MyURLClassLoaderTest.fail((String)e.getMessage());
        }
    }

    private Class[] getIQueryTokenizerAssignableClasses(String urlToSearch) {
        MyURLClassLoader loader = this.getLoader(urlToSearch);
        return loader.getAssignableClasses(IQueryTokenizer.class, s_log);
    }

    private MyURLClassLoader getLoader(String urlToSearch) {
        MyURLClassLoader result = null;
        try {
            URL url = new URL(urlToSearch);
            MyURLClassLoader loader = new MyURLClassLoader(url);
            return loader;
        }
        catch (Exception e) {
            MyURLClassLoaderTest.fail((String)e.getMessage());
            return result;
        }
    }

    private static class MyClassLoaderListener
    implements ClassLoaderListener {
        public int loadingZipFileCount = 0;

        private MyClassLoaderListener() {
        }

        public void finishedLoadingZipFiles() {
        }

        public void loadedZipFile(String filename) {
            ++this.loadingZipFileCount;
        }
    }
}

