/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.junit.Assert;

public class Support_Exec {
    public static String execJava(String[] args, String[] classpath, boolean displayOutput) throws IOException, InterruptedException {
        Object[] arr = Support_Exec.execJavaCommon(args, classpath, null, displayOutput, true);
        return Support_Exec.getProcessOutput(arr, displayOutput);
    }

    public static String execJava(String[] args, String[] classpath, String[] envp, boolean displayOutput) throws IOException, InterruptedException {
        Object[] arr = Support_Exec.execJavaCommon(args, classpath, envp, displayOutput, false);
        return Support_Exec.getProcessOutput(arr, displayOutput);
    }

    private static String getProcessOutput(Object[] arr, boolean displayOutput) throws IOException, InterruptedException {
        int result;
        Process proc = (Process)arr[0];
        StringBuilder output = new StringBuilder();
        InputStream in = proc.getInputStream();
        byte[] bytes = new byte[1024];
        while ((result = in.read(bytes)) != -1) {
            output.append(new String(bytes, 0, result));
            if (!displayOutput) continue;
            System.out.write(bytes, 0, result);
        }
        in.close();
        proc.waitFor();
        Support_Exec.checkStderr(arr);
        proc.destroy();
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkStderr(Object[] execArgs) {
        StringBuilder errBuf;
        StringBuilder stringBuilder = errBuf = (StringBuilder)execArgs[1];
        synchronized (stringBuilder) {
            if (errBuf.length() > 0) {
                Assert.fail((String)errBuf.toString());
            }
        }
    }

    public static Object[] execJava2(String[] args, String[] classpath, boolean displayOutput) throws IOException, InterruptedException {
        return Support_Exec.execJavaCommon(args, classpath, null, displayOutput, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] execJavaCommon(String[] args, String[] classpath, String[] envp, boolean displayOutput, boolean appendToSystemClassPath) throws IOException, InterruptedException {
        ArrayList<String> execArgs = null;
        StringBuilder classPathString = new StringBuilder();
        execArgs = new ArrayList<String>(3 + args.length);
        String executable = System.getProperty("java.home");
        if (!executable.endsWith(File.separator)) {
            executable = executable + File.separator;
        }
        executable = executable + "bin" + File.separator;
        execArgs.add(executable + "java");
        if (classpath != null) {
            for (String element : classpath) {
                classPathString.append(File.pathSeparator);
                classPathString.append(element);
            }
        }
        if (appendToSystemClassPath) {
            execArgs.add("-cp");
            execArgs.add(System.getProperty("java.class.path") + classPathString);
        } else if (classpath != null) {
            execArgs.add("-cp");
            execArgs.add(classPathString.toString());
        }
        String testVMArgs = System.getProperty("hy.test.vmargs");
        if (testVMArgs != null) {
            StringTokenizer st = new StringTokenizer(testVMArgs, " ");
            while (st.hasMoreTokens()) {
                execArgs.add(st.nextToken());
            }
        }
        for (String arg : args) {
            execArgs.add(arg);
        }
        final Process proc = Runtime.getRuntime().exec(execArgs.toArray(new String[execArgs.size()]), envp);
        final StringBuilder errBuf = new StringBuilder();
        Thread errThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StringBuilder stringBuilder = errBuf;
                synchronized (stringBuilder) {
                    byte[] bytes = new byte[1024];
                    Process process = proc;
                    synchronized (process) {
                        proc.notifyAll();
                    }
                    InputStream err = proc.getErrorStream();
                    try {
                        int result;
                        while ((result = err.read(bytes)) != -1) {
                            System.err.write(bytes, 0, result);
                            errBuf.append(new String(bytes));
                        }
                        err.close();
                    }
                    catch (IOException e) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        PrintStream printer = new PrintStream(out);
                        e.printStackTrace();
                        e.printStackTrace(printer);
                        printer.close();
                        errBuf.append(new String(out.toByteArray()));
                    }
                }
            }
        });
        Process process = proc;
        synchronized (process) {
            errThread.start();
            int count = 0;
            boolean isFinished = false;
            while (!isFinished) {
                try {
                    proc.wait();
                    isFinished = true;
                }
                catch (InterruptedException e) {
                    if (++count != 2) continue;
                    throw e;
                }
            }
            if (count > 0) {
                Thread.currentThread().interrupt();
            }
        }
        return new Object[]{proc, errBuf};
    }
}

