/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeDate;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;

public class ColumnDisplayDefinition {
    private int _displayWidth;
    private String _fullTableColumnName;
    private String _columnName;
    private String _label;
    private int _sqlType;
    private String _sqlTypeName;
    private boolean _isNullable;
    private int _columnSize;
    private int _precision;
    private int _scale;
    private boolean _isSigned;
    private boolean _isCurrency;
    private boolean _isAutoIncrement;
    private DialectType _dialectType;

    public ColumnDisplayDefinition(int displayWidth, String label) {
        this.init(displayWidth, null, label, label, 0, null, true, 0, 0, 0, true, false, false, DialectType.GENERIC);
    }

    public ColumnDisplayDefinition(int displayWidth, String fullTableColumnName, String columnName, String label, int sqlType, String sqlTypeName, boolean isNullable, int columnSize, int precision, int scale, boolean isSigned, boolean isCurrency, boolean isAutoIncrement, DialectType dialectType) {
        this.init(displayWidth, fullTableColumnName, columnName, label, sqlType, sqlTypeName, isNullable, columnSize, precision, scale, isSigned, isCurrency, isAutoIncrement, dialectType);
    }

    public ColumnDisplayDefinition(ResultSet rs, int idx, DialectType dialectType) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        String columnLabel = md.getColumnLabel(idx);
        String columnName = md.getColumnName(idx);
        int displayWidth = columnLabel.length();
        String fullTableColumnName = md.getTableName(idx) + ":" + columnName;
        int sqlType = md.getColumnType(idx);
        String sqlTypeName = md.getColumnTypeName(idx);
        boolean isNullable = md.isNullable(idx) == 1;
        int columnSize = md.getColumnDisplaySize(idx);
        int precision = md.getPrecision(idx);
        int scale = md.getScale(idx);
        boolean isSigned = md.isSigned(idx);
        boolean isCurrency = md.isCurrency(idx);
        boolean isAutoIncrement = md.isAutoIncrement(idx);
        this.init(displayWidth, fullTableColumnName, columnName, columnLabel, sqlType, sqlTypeName, isNullable, columnSize, precision, scale, isSigned, isCurrency, isAutoIncrement, dialectType);
    }

    public int getDisplayWidth() {
        return this._displayWidth;
    }

    public String getFullTableColumnName() {
        return this._fullTableColumnName;
    }

    public String getLabel() {
        return this._label;
    }

    public int getSqlType() {
        return this._sqlType;
    }

    public void setSqlType(int sqlType) {
        this._sqlType = sqlType;
    }

    public String getSqlTypeName() {
        return this._sqlTypeName;
    }

    public void setSqlTypeName(String sqlTypeName) {
        this._sqlTypeName = sqlTypeName;
    }

    public boolean isNullable() {
        return this._isNullable;
    }

    public void setIsNullable(boolean isNullable) {
        this._isNullable = isNullable;
    }

    public int getColumnSize() {
        return this._columnSize;
    }

    public int getPrecision() {
        return this._precision;
    }

    public int getScale() {
        return this._scale;
    }

    public boolean isSigned() {
        return this._isSigned;
    }

    public boolean isCurrency() {
        return this._isCurrency;
    }

    public String getClassName() {
        return CellComponentFactory.getClassName(this);
    }

    private void init(int displayWidth, String fullTableColumnName, String columnName, String label, int sqlType, String sqlTypeName, boolean isNullable, int columnSize, int precision, int scale, boolean isSigned, boolean isCurrency, boolean isAutoIncrement, DialectType dialectType) {
        if (label == null) {
            label = " ";
        }
        this._displayWidth = displayWidth;
        if (this._displayWidth < label.length()) {
            this._displayWidth = label.length();
        }
        this._fullTableColumnName = fullTableColumnName;
        this._columnName = columnName;
        this._label = label.length() > 0 ? label : " ";
        this._sqlType = sqlType;
        this._sqlTypeName = sqlTypeName;
        if (sqlType == 91 && DataTypeDate.getReadDateAsTimestamp()) {
            this._sqlType = 93;
            this._sqlTypeName = "TIMESTAMP";
        }
        this._isNullable = isNullable;
        this._columnSize = columnSize;
        this._precision = precision;
        this._scale = scale;
        this._isSigned = isSigned;
        this._isCurrency = isCurrency;
        this._isAutoIncrement = isAutoIncrement;
        this._dialectType = dialectType;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[ columnName=");
        result.append(this._columnName);
        result.append(", sqlType=");
        result.append(this._sqlType);
        result.append(", sqlTypeName=");
        result.append(this._sqlTypeName);
        result.append(", dialectType=");
        result.append(this._dialectType == null ? "null" : this._dialectType.name());
        result.append(" ]");
        return result.toString();
    }

    public void setIsAutoIncrement(boolean autoIncrement) {
        this._isAutoIncrement = autoIncrement;
    }

    public boolean isAutoIncrement() {
        return this._isAutoIncrement;
    }

    public void setColumnName(String _columnName) {
        this._columnName = _columnName;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public DialectType getDialectType() {
        return this._dialectType;
    }

    public void setDialectType(DialectType type) {
        this._dialectType = type;
    }
}

