/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BaseDataSetViewerDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeGeneral;
import net.sourceforge.squirrel_sql.fw.gui.TextPopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.gui.action.MakeEditableCommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DataSetViewerTextPanel
extends BaseDataSetViewerDestination {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataSetViewerTextPanel.class);
    private static final int COLUMN_PADDING = 2;
    private MyJTextArea _outText = null;
    private int _rowCount = 0;

    @Override
    public void init(IDataSetUpdateableModel updateableObject) {
        this._outText = new MyJTextArea(updateableObject);
    }

    @Override
    public void clear() {
        this._outText.setText("");
        this._rowCount = 0;
    }

    @Override
    public void setColumnDefinitions(ColumnDisplayDefinition[] colDefs) {
        super.setColumnDefinitions(colDefs);
        colDefs = this.getColumnDefinitions();
        if (this.getShowHeadings()) {
            int i;
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < colDefs.length; ++i) {
                String headerValue = DataTypeGeneral.isUseColumnLabelInsteadColumnName() ? colDefs[i].getLabel() : colDefs[i].getColumnName();
                buf.append(this.format(headerValue, colDefs[i].getDisplayWidth(), ' '));
            }
            this.addLine(buf.toString());
            buf = new StringBuffer();
            for (i = 0; i < colDefs.length; ++i) {
                buf.append(this.format("", colDefs[i].getDisplayWidth(), '-'));
            }
            this.addLine(buf.toString());
        }
    }

    @Override
    protected void addRow(Object[] row) {
        ++this._rowCount;
        ColumnDisplayDefinition[] colDefs = this.getColumnDefinitions();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < row.length; ++i) {
            String cellValue = CellComponentFactory.renderObject(row[i], colDefs[i]);
            buf.append(this.format(cellValue, colDefs[i].getDisplayWidth(), ' '));
        }
        this.addLine(buf.toString());
    }

    @Override
    public void moveToTop() {
        this._outText.select(0, 0);
    }

    @Override
    protected void allRowsAdded() {
    }

    @Override
    public Component getComponent() {
        return this._outText;
    }

    @Override
    public int getRowCount() {
        return this._rowCount;
    }

    protected void addLine(String line) {
        this._outText.append(line);
        this._outText.append("\n");
    }

    protected String format(String data, int displaySize, char fillChar) {
        int extraPadding;
        data = data.replace('\n', ' ');
        data = data.replace('\r', ' ');
        StringBuffer output = new StringBuffer(data);
        if (displaySize > 50) {
            displaySize = 50;
        }
        if (output.length() > displaySize) {
            output.setLength(displaySize);
        }
        if ((extraPadding = (displaySize += 2) - output.length()) > 0) {
            char[] padData = new char[extraPadding];
            Arrays.fill(padData, fillChar);
            output.append(padData);
        }
        return output.toString();
    }

    private static class MyJTextAreaPopupMenu
    extends TextPopupMenu {
        private static final long serialVersionUID = 1L;
        private MakeEditableAction _makeEditable = new MakeEditableAction();
        private IDataSetUpdateableModel _updateableModel = null;

        MyJTextAreaPopupMenu(boolean allowUpdate, IDataSetUpdateableModel updateableObject) {
            this._updateableModel = updateableObject;
            if (allowUpdate) {
                this.addSeparator();
                this.add(this._makeEditable);
                this.addSeparator();
            }
        }

        private class MakeEditableAction
        extends BaseAction {
            private static final long serialVersionUID = 1L;

            MakeEditableAction() {
                super(s_stringMgr.getString("dataSetViewerTablePanel.makeEditable"));
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (MyJTextAreaPopupMenu.this._updateableModel != null) {
                    new MakeEditableCommand(MyJTextAreaPopupMenu.this._updateableModel).execute();
                }
            }
        }
    }

    private final class MyJTextArea
    extends JTextArea {
        private static final long serialVersionUID = 1L;
        private TextPopupMenu _textPopupMenu;

        MyJTextArea(IDataSetUpdateableModel updateableObject) {
            boolean allowUpdate = false;
            if (updateableObject != null) {
                allowUpdate = true;
            }
            this.createUserInterface(allowUpdate, updateableObject);
        }

        protected void createUserInterface(boolean allowUpdate, IDataSetUpdateableModel updateableObject) {
            this.setEditable(false);
            this.setLineWrap(false);
            this.setFont(new Font("Monospaced", 0, 12));
            this._textPopupMenu = new MyJTextAreaPopupMenu(allowUpdate, updateableObject);
            this._textPopupMenu.setTextComponent(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        MyJTextArea.this.displayPopupMenu(evt);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        MyJTextArea.this.displayPopupMenu(evt);
                    }
                }
            });
        }

        void displayPopupMenu(MouseEvent evt) {
            this._textPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}

