/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetReader;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetDataSet
implements IDataSet {
    private static final ILogger s_log = LoggerController.createLogger(ResultSetDataSet.class);
    private int _iCurrent = -1;
    private Object[] _currentRow;
    private int _columnCount;
    private DataSetDefinition _dataSetDefinition;
    private List<Object[]> _alData;
    private volatile boolean _cancel = false;
    private ResultSetReader rdr = null;
    private DialectType _dialectType = null;

    public int setResultSet(ResultSet rs, DialectType dialectType) throws DataSetException {
        return this.setResultSet(rs, null, false, dialectType);
    }

    public int setContentsTabResultSet(ResultSet rs, String fullTableName, DialectType dialectType) throws DataSetException {
        return this.setResultSet(rs, fullTableName, null, false, true, dialectType);
    }

    public int setResultSet(ResultSet rs, int[] columnIndices, DialectType dialectType) throws DataSetException {
        return this.setResultSet(rs, columnIndices, false, dialectType);
    }

    public int setResultSet(ResultSet rs, int[] columnIndices, boolean computeWidths, DialectType dialectType) throws DataSetException {
        return this.setResultSet(rs, null, columnIndices, computeWidths, false, dialectType);
    }

    private int setResultSet(ResultSet rs, String fullTableName, int[] columnIndices, boolean computeWidths, boolean useColumnDefs, DialectType dialectType) throws DataSetException {
        this.reset();
        this._dialectType = dialectType;
        if (columnIndices != null && columnIndices.length == 0) {
            columnIndices = null;
        }
        this._iCurrent = -1;
        this._alData = new ArrayList<Object[]>();
        if (rs == null) {
            return 0;
        }
        try {
            ResultSetMetaData md = rs.getMetaData();
            this._columnCount = columnIndices != null ? columnIndices.length : md.getColumnCount();
            ColumnDisplayDefinition[] colDefs = this.createColumnDefinitions(md, fullTableName, columnIndices, computeWidths);
            this._dataSetDefinition = new DataSetDefinition(colDefs);
            this.rdr = new ResultSetReader(rs, dialectType);
            Object[] row = null;
            while ((row = useColumnDefs ? this.rdr.readRow(colDefs) : this.rdr.readRow()) != null) {
                if (this._cancel) {
                    return this._alData.size();
                }
                if (columnIndices != null) {
                    Object[] newRow = new Object[this._columnCount];
                    for (int i = 0; i < this._columnCount; ++i) {
                        newRow[i] = columnIndices[i] - 1 < row.length ? row[columnIndices[i] - 1] : "Unknown";
                    }
                    row = newRow;
                }
                this._alData.add(row);
            }
            return this._alData.size();
        }
        catch (SQLException ex) {
            throw new DataSetException(ex);
        }
    }

    @Override
    public final int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public DataSetDefinition getDataSetDefinition() {
        return this._dataSetDefinition;
    }

    @Override
    public synchronized boolean next(IMessageHandler msgHandler) throws DataSetException {
        if (++this._iCurrent < this._alData.size()) {
            this._currentRow = this._alData.get(this._iCurrent);
            return true;
        }
        return false;
    }

    @Override
    public Object get(int columnIndex) {
        if (this._currentRow != null) {
            return this._currentRow[columnIndex];
        }
        return null;
    }

    public void cancelProcessing() {
        this.rdr.setStopExecution(true);
        this._cancel = true;
    }

    private ColumnDisplayDefinition[] createColumnDefinitions(ResultSetMetaData md, String fullTableName, int[] columnIndices, boolean computeWidths) throws SQLException {
        int[] colWidths = null;
        if (computeWidths) {
            colWidths = new int[this._columnCount];
            for (int i = 0; i < this._alData.size(); ++i) {
                Object[] row = this._alData.get(i);
                int col = 0;
                while (i < this._columnCount) {
                    int colWidth;
                    if (row[col] != null && (colWidth = row[col].toString().length()) > colWidths[col]) {
                        colWidths[col] = colWidth + 2;
                    }
                    ++i;
                }
            }
        }
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[this._columnCount];
        for (int i = 0; i < this._columnCount; ++i) {
            int precis;
            int idx = columnIndices != null ? columnIndices[i] : i + 1;
            boolean isNullable = true;
            if (md.isNullable(idx) == 0) {
                isNullable = false;
            }
            try {
                precis = md.getPrecision(idx);
            }
            catch (NumberFormatException ignore) {
                precis = Integer.MAX_VALUE;
            }
            boolean isSigned = true;
            try {
                isSigned = md.isSigned(idx);
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            boolean isCurrency = false;
            try {
                isCurrency = md.isCurrency(idx);
            }
            catch (SQLException e) {
                s_log.error("Failed to call ResultSetMetaData.isCurrency()", e);
            }
            boolean isAutoIncrement = false;
            try {
                isAutoIncrement = md.isAutoIncrement(idx);
            }
            catch (SQLException e) {
                s_log.error("Failed to call ResultSetMetaData.isAutoIncrement()", e);
            }
            String columnName = md.getColumnName(idx);
            String columnTypeName = md.getColumnTypeName(idx);
            int columnType = this.fixColumnType(columnName, md.getColumnType(idx), columnTypeName);
            columnDefs[i] = new ColumnDisplayDefinition(computeWidths ? colWidths[i] : md.getColumnDisplaySize(idx), fullTableName + ":" + md.getColumnLabel(idx), columnName, md.getColumnLabel(idx), columnType, columnTypeName, isNullable, md.getColumnDisplaySize(idx), precis, md.getScale(idx), isSigned, isCurrency, isAutoIncrement, this._dialectType);
        }
        return columnDefs;
    }

    private int fixColumnType(String columnName, int columnType, String columnTypeName) {
        int result = columnType;
        if (columnType == 0 && (result = JDBCTypeMapper.getJdbcType(columnTypeName)) == 0) {
            result = 12;
        }
        if (result != columnType && s_log.isDebugEnabled()) {
            s_log.debug("Converting type code for column " + columnName + ". Original column type code and name were Types.NULL and " + columnTypeName + "; New type code is " + JDBCTypeMapper.getJdbcTypeName(result));
        }
        return result;
    }

    private void reset() {
        this._iCurrent = -1;
        this._currentRow = null;
        this._columnCount = 0;
        this._dataSetDefinition = null;
        this._alData = null;
    }

    public void resetCursor() {
        this._iCurrent = -1;
        this._currentRow = null;
    }

    public Object removeRow(int index) {
        if (this._alData.size() > index) {
            return this._alData.remove(index);
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this._dataSetDefinition != null) {
            for (ColumnDisplayDefinition colDef : this._dataSetDefinition.getColumnDefinitions()) {
                String columnName = "Column";
                if (colDef != null) {
                    columnName = colDef.getColumnName();
                }
                result.append(columnName);
                result.append("\t");
            }
            result.append("\n");
        }
        for (Object[] row : this._alData) {
            for (Object rowItem : row) {
                if (rowItem == null) {
                    result.append("<null>");
                } else {
                    result.append(rowItem.toString());
                }
                result.append("\t");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public List<Object[]> getAllDataForReadOnly() {
        return this._alData;
    }
}

