/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetMetaDataDataSet
implements IDataSet {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultSetMetaDataDataSet.class);
    private static ILogger s_log = LoggerController.createLogger(ResultSetMetaDataDataSet.class);
    private DataSetDefinition _dsDef;
    private Iterator<Object[]> _rowsIter;
    private Object[] _row;
    private List<Object[]> _data = new ArrayList<Object[]>();
    private static final Method[] s_methods = ResultSetMetaDataDataSet.createMetaDataMethodArray();

    private static Method[] createMetaDataMethodArray() {
        try {
            return new Method[]{ResultSetMetaData.class.getMethod("getColumnName", Integer.TYPE), ResultSetMetaData.class.getMethod("getColumnTypeName", Integer.TYPE), ResultSetMetaData.class.getMethod("getPrecision", Integer.TYPE), ResultSetMetaData.class.getMethod("getScale", Integer.TYPE), ResultSetMetaData.class.getMethod("isNullable", Integer.TYPE), ResultSetMetaData.class.getMethod("getTableName", Integer.TYPE), ResultSetMetaData.class.getMethod("getSchemaName", Integer.TYPE), ResultSetMetaData.class.getMethod("getCatalogName", Integer.TYPE), ResultSetMetaData.class.getMethod("getColumnClassName", Integer.TYPE), ResultSetMetaData.class.getMethod("getColumnDisplaySize", Integer.TYPE), ResultSetMetaData.class.getMethod("getColumnLabel", Integer.TYPE), ResultSetMetaData.class.getMethod("getColumnType", Integer.TYPE), ResultSetMetaData.class.getMethod("isAutoIncrement", Integer.TYPE), ResultSetMetaData.class.getMethod("isCaseSensitive", Integer.TYPE), ResultSetMetaData.class.getMethod("isCurrency", Integer.TYPE), ResultSetMetaData.class.getMethod("isDefinitelyWritable", Integer.TYPE), ResultSetMetaData.class.getMethod("isReadOnly", Integer.TYPE), ResultSetMetaData.class.getMethod("isSearchable", Integer.TYPE), ResultSetMetaData.class.getMethod("isSigned", Integer.TYPE), ResultSetMetaData.class.getMethod("isWritable", Integer.TYPE)};
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public ResultSetMetaDataDataSet(ResultSet rs) throws IllegalArgumentException, DataSetException {
        this(ResultSetMetaDataDataSet.getMetaDataFromResultSet(rs));
    }

    public ResultSetMetaDataDataSet(ResultSetMetaData md) throws IllegalArgumentException, DataSetException {
        this.setResultSetMetaData(md);
    }

    public synchronized void setResultSetMetaData(ResultSetMetaData md) throws DataSetException {
        this._dsDef = new DataSetDefinition(this.createColumnDefinitions());
        this.load(md);
    }

    @Override
    public final int getColumnCount() {
        return this._dsDef.getColumnDefinitions().length;
    }

    @Override
    public DataSetDefinition getDataSetDefinition() {
        return this._dsDef;
    }

    @Override
    public synchronized boolean next(IMessageHandler msgHandler) throws DataSetException {
        this._row = this._rowsIter.hasNext() ? this._rowsIter.next() : null;
        return this._row != null;
    }

    @Override
    public synchronized Object get(int columnIndex) {
        return this._row[columnIndex];
    }

    private ColumnDisplayDefinition[] createColumnDefinitions() {
        ColumnDisplayDefinition[] colDefs = new ColumnDisplayDefinition[s_methods.length + 1];
        colDefs[0] = new ColumnDisplayDefinition(25, "ColumnIndex");
        for (int i = 0; i < s_methods.length; ++i) {
            colDefs[i + 1] = new ColumnDisplayDefinition(25, s_methods[i].getName());
        }
        return colDefs;
    }

    private void load(ResultSetMetaData md) throws DataSetException {
        try {
            for (int i = 1; i < md.getColumnCount() + 1; ++i) {
                Object[] line = new Object[s_methods.length + 1];
                line[0] = i;
                Object[] methodParms = new Object[]{i};
                for (int j = 0; j < s_methods.length; ++j) {
                    line[j + 1] = this.executeGetter(md, s_methods[j], methodParms);
                }
                this._data.add(line);
            }
            this._rowsIter = this._data.iterator();
        }
        catch (SQLException ex) {
            s_log.error("Error occured processing result set", ex);
            throw new DataSetException(ex);
        }
    }

    protected Object executeGetter(Object bean, Method getter, Object[] parms) {
        try {
            return getter.invoke(bean, parms);
        }
        catch (Throwable th) {
            return "<Unsupported>";
        }
    }

    private static ResultSetMetaData getMetaDataFromResultSet(ResultSet rs) throws IllegalArgumentException, DataSetException {
        if (rs == null) {
            throw new IllegalArgumentException("Null ResultSet passed");
        }
        try {
            return rs.getMetaData();
        }
        catch (SQLException ex) {
            throw new DataSetException(ex);
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String UNSUPPORTED = "<Unsupported>";
        public static final String NAME_COLUMN = ResultSetMetaDataDataSet.access$000().getString("resultSetMentaDataSet.propName");
        public static final String VALUE_COLUMN = ResultSetMetaDataDataSet.access$000().getString("resultSetMentaDataSet.val");
    }
}

