/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerEditableTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RowDataInputFrame
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RowDataInputFrame.class);
    DataSetViewerEditableTablePanel _caller;
    RowDataJTable table;

    public RowDataInputFrame(JFrame parent, ColumnDisplayDefinition[] colDefs, Object[] initialValues, DataSetViewerEditableTablePanel caller) {
        super(parent, s_stringMgr.getString("rowDataInputFrame.propName"), false);
        Container pane = this.getContentPane();
        this._caller = caller;
        pane.setLayout(new BorderLayout());
        this.table = new RowDataJTable(colDefs, initialValues);
        Dimension tableDim = this.table.getPreferredSize();
        tableDim.setSize(tableDim.getWidth(), tableDim.getHeight() + 15.0);
        this.table.setPreferredScrollableViewportSize(tableDim);
        JScrollPane scrollPane = new JScrollPane(this.table);
        JPanel rowHeaderPanel = new JPanel();
        rowHeaderPanel.setLayout(new BorderLayout());
        JTextArea r1 = new JTextArea(s_stringMgr.getString("rowDataInputFrame.data"), 1, 10);
        r1.setBackground(Color.lightGray);
        r1.setBorder(BorderFactory.createLineBorder(Color.black));
        r1.setEditable(false);
        rowHeaderPanel.add((Component)r1, "North");
        JTextArea r2 = new JTextArea(s_stringMgr.getString("rowDataInputFrame.colDescription"), 4, 10);
        r2.setBackground(Color.lightGray);
        r2.setBorder(BorderFactory.createLineBorder(Color.black));
        r2.setEditable(false);
        rowHeaderPanel.add((Component)r2, "Center");
        scrollPane.setRowHeaderView(rowHeaderPanel);
        pane.add((Component)scrollPane, "North");
        JPanel buttonPanel = new JPanel();
        JButton insertButton = new JButton(s_stringMgr.getString("rowDataInputFrame.insert"));
        buttonPanel.add(insertButton);
        insertButton.setActionCommand("insert");
        insertButton.addActionListener(this);
        JButton cancelButton = new JButton(s_stringMgr.getString("rowDataInputFrame.cancel"));
        buttonPanel.add(cancelButton);
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        pane.add((Component)buttonPanel, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("cancel")) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        if (!e.getActionCommand().equals("insert")) {
            return;
        }
        if (this.table.isEditing()) {
            int col = this.table.getEditingColumn();
            this.table.getCellEditor(0, col).stopCellEditing();
        }
        Object[] rowData = new Object[this.table.getModel().getColumnCount()];
        for (int i = 0; i < this.table.getModel().getColumnCount(); ++i) {
            rowData[i] = this.table.getValueAt(0, i);
        }
        if (this._caller.insertRow(rowData) == null) {
            this.setVisible(false);
            this.dispose();
        }
    }

    class RowDataDescriptionRenderer
    implements TableCellRenderer {
        RowDataDescriptionRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTextArea ta = new JTextArea((String)value, 8, 20);
            ta.setBackground(Color.lightGray);
            return ta;
        }
    }

    class RowDataModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        protected RowDataModel(ColumnDisplayDefinition[] colDefs, Object[] initalValues) {
            Object[] colNames = new String[colDefs.length];
            Object[][] rowData = new Object[2][colDefs.length];
            for (int i = 0; i < colDefs.length; ++i) {
                colNames[i] = colDefs[i].getColumnName();
                rowData[0][i] = initalValues[i];
                rowData[1][i] = this.getColumnDescription(colDefs[i]);
            }
            this.setDataVector(rowData, colNames);
        }

        private String getColumnDescription(ColumnDisplayDefinition def) {
            StringBuilder result = new StringBuilder();
            result.append(def.getSqlTypeName());
            result.append("\n");
            if (def.isNullable()) {
                result.append("nullable");
            } else {
                result.append("not nullable");
            }
            result.append("\n");
            if (JDBCTypeMapper.isNumberType(def.getSqlType())) {
                result.append("prec=");
                result.append(def.getPrecision());
                result.append("\n");
                result.append("scale=");
                result.append(def.getScale());
                if (def.isAutoIncrement()) {
                    result.append("\n");
                    result.append("(auto-incr)");
                }
            } else {
                result.append("length=");
                result.append(def.getColumnSize());
            }
            return result.toString();
        }
    }

    class RowDataJTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        private ColumnDisplayDefinition[] _colDefs = null;

        protected RowDataJTable(ColumnDisplayDefinition[] colDefs, Object[] initalValues) {
            int i;
            this.setModel(new RowDataModel(colDefs, initalValues));
            String data = "THE QUICK BROWN FOX JUMPED OVER THE LAZY DOG";
            int _multiplier = this.getFontMetrics(this.getFont()).stringWidth("THE QUICK BROWN FOX JUMPED OVER THE LAZY DOG") / "THE QUICK BROWN FOX JUMPED OVER THE LAZY DOG".length();
            DefaultTableColumnModel cm = new DefaultTableColumnModel();
            for (i = 0; i < colDefs.length; ++i) {
                ColumnDisplayDefinition colDef = colDefs[i];
                int colWidth = colDef.getDisplayWidth() * _multiplier;
                if (colWidth > 50 * _multiplier) {
                    colWidth = 50 * _multiplier;
                }
                TableColumn col = new TableColumn(i, colWidth, CellComponentFactory.getTableCellRenderer(colDefs[i]), null);
                col.setHeaderValue(colDef.getColumnName());
                cm.addColumn(col);
            }
            this.setColumnModel(cm);
            this._colDefs = colDefs;
            for (i = 0; i < colDefs.length; ++i) {
                cm.getColumn(i).setCellEditor(CellComponentFactory.getInCellEditor(this, this._colDefs[i]));
            }
            this.setRowHeight(1, 80);
            this.setRowSelectionAllowed(false);
            this.setColumnSelectionAllowed(false);
            this.setCellSelectionEnabled(true);
            this.getTableHeader().setResizingAllowed(true);
            this.getTableHeader().setReorderingAllowed(true);
            this.setAutoCreateColumnsFromModel(false);
            this.setAutoResizeMode(0);
            MouseAdapter m = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (!evt.isPopupTrigger() && evt.getClickCount() == 2) {
                        Point pt = evt.getPoint();
                        int col = RowDataJTable.this.columnAtPoint(pt);
                        CellDataPopup.showDialog(RowDataJTable.this, RowDataJTable.this._colDefs[col], evt, true);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        // empty if block
                    }
                }
            };
            this.addMouseListener(m);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (row > 0) {
                return false;
            }
            return CellComponentFactory.isEditableInCell(this._colDefs[col], this.getValueAt(row, col));
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (row == 0) {
                return CellComponentFactory.getTableCellRenderer(this._colDefs[column]);
            }
            return new RowDataDescriptionRenderer();
        }

        @Override
        public void setValueAt(Object newValueString, int row, int col) {
            if (!(newValueString instanceof String)) {
                super.setValueAt(newValueString, row, col);
                return;
            }
            StringBuffer messageBuffer = new StringBuffer();
            ColumnDisplayDefinition colDef = this._colDefs[col];
            Object newValueObject = CellComponentFactory.validateAndConvert(colDef, this.getValueAt(row, col), (String)newValueString, messageBuffer);
            if (messageBuffer.length() > 0) {
                String msg = s_stringMgr.getString("rowInputDataFrame.conversionToInternErr", messageBuffer);
                JOptionPane.showMessageDialog(this, msg, s_stringMgr.getString("rowInputDataFrame.conversionErr"), 0);
            } else {
                super.setValueAt(newValueObject, row, col);
            }
        }
    }
}

