/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BinaryDisplayConverter;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class DataTypeBinary
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();

    public DataTypeBinary(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
    }

    @Override
    public String getClassName() {
        return "[Ljava.lang.Byte";
    }

    @Override
    public boolean areEqual(Object obj1, Object obj2) {
        Byte[] b1 = null;
        Byte[] b2 = null;
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null && obj2 == null || obj1 == null && obj2 != null) {
            return false;
        }
        b1 = obj1 instanceof Byte[] ? (Byte[])obj1 : StringUtilities.getByteArray(obj1.toString().getBytes());
        b2 = obj2 instanceof Byte[] ? (Byte[])obj2 : StringUtilities.getByteArray(obj2.toString().getBytes());
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String renderObject(Object value) {
        Byte[] useValue;
        if (value instanceof String) {
            byte[] bytes = ((String)value).getBytes();
            useValue = new Byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                useValue[i] = bytes[i];
            }
        } else {
            useValue = (Byte[])value;
        }
        return (String)this._renderer.renderObject(BinaryDisplayConverter.convertToString(useValue, 16, false));
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return true;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField() {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeBinary.this._textComponent, evt, DataTypeBinary.this._table);
                    CellDataPopup.showDialog(DataTypeBinary.this._table, DataTypeBinary.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value == null || value.equals("<null>") || value.equals("")) {
            return null;
        }
        try {
            Byte[] obj = BinaryDisplayConverter.convertToBytes(value, 16, false);
            return obj;
        }
        catch (Exception e) {
            messageBuffer.append(e.toString() + "\n");
            return null;
        }
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return true;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    @Override
    public JTextArea getJTextArea(Object value) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        byte[] data = rs.getBytes(index);
        if (rs.wasNull()) {
            return null;
        }
        Byte[] internal = new Byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            internal[i] = data[i];
        }
        return internal;
    }

    @Override
    public String getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return this._colDef.getColumnName() + " IS NULL";
        }
        return null;
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            Byte[] internal = (Byte[])value;
            byte[] dbValue = new byte[internal.length];
            for (int i = 0; i < internal.length; ++i) {
                dbValue[i] = internal[i];
            }
            pstmt.setBytes(position, dbValue);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return new Byte[0];
    }

    @Override
    public boolean canDoFileIO() {
        return true;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        int fileSize = inStream.available();
        byte[] buf = new byte[fileSize];
        int count = inStream.read(buf);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " bytes from a total file size of " + fileSize + ". Import failed.");
        }
        Byte[] bBytes = new Byte[count];
        for (int i = 0; i < count; ++i) {
            bBytes[i] = buf[i];
        }
        return BinaryDisplayConverter.convertToString(bBytes, 16, false);
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        Byte[] bBytes = BinaryDisplayConverter.convertToBytes(text, 16, false);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        byte[] bytes = new byte[bBytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = bBytes[i];
        }
        outStream.write(bytes);
        outStream.flush();
        outStream.close();
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeBinary.this._textComponent);
            String text = _theComponent.getText();
            if (c == '\t' || c == '\n') {
                int index = text.indexOf(c);
                if (index != -1) {
                    text = index == text.length() - 1 ? text.substring(0, text.length() - 1) : text.substring(0, index) + text.substring(index + 1);
                    ((IRestorableTextComponent)((Object)_theComponent)).updateText(text);
                    DataTypeBinary.this._beepHelper.beep(_theComponent);
                }
                e.consume();
            }
            if (DataTypeBinary.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeBinary.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeBinary.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() <= 1) {
                    DataTypeBinary.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField(text, c, e, DataTypeBinary.this._textComponent);
            }
        }
    }
}

