/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DatabaseSpecificEscape;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DataTypeString
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeString.class);
    private boolean _isNullable;
    private int _columnSize;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();
    private static final int DEFAULT_LIMIT_READ_LENGTH = 100;
    private static final String thisClassName = "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeString";
    private static boolean propertiesAlreadyLoaded = false;
    private static boolean _makeNewlinesVisibleInCell = true;
    private static boolean _useLongInWhere = true;
    private static boolean _limitRead = false;
    private static int _limitReadLength = 100;
    private static boolean _limitReadOnSpecificColumns = false;
    private static HashMap<String, String> _limitReadColumnNameMap = new HashMap();

    public DataTypeString(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        this._columnSize = colDef.getColumnSize();
        DataTypeString.loadProperties();
    }

    protected DataTypeString() {
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            _makeNewlinesVisibleInCell = true;
            String makeNewlinesVisibleString = DTProperties.get(thisClassName, "makeNewlinesVisibleInCell");
            if (makeNewlinesVisibleString != null && makeNewlinesVisibleString.equals("false")) {
                _makeNewlinesVisibleInCell = false;
            }
            _useLongInWhere = true;
            String useLongInWhereString = DTProperties.get(thisClassName, "useLongInWhere");
            if (useLongInWhereString != null && useLongInWhereString.equals("false")) {
                _useLongInWhere = false;
            }
            _limitRead = false;
            String limitReadString = DTProperties.get(thisClassName, "limitRead");
            if (limitReadString != null && limitReadString.equals("true")) {
                _limitRead = true;
            }
            _limitReadLength = 100;
            String limitReadLengthString = DTProperties.get(thisClassName, "limitReadLength");
            if (limitReadLengthString != null) {
                _limitReadLength = Integer.parseInt(limitReadLengthString);
            }
            _limitReadOnSpecificColumns = false;
            String limitReadOnSpecificColumnsString = DTProperties.get(thisClassName, "limitReadOnSpecificColumns");
            if (limitReadOnSpecificColumnsString != null && limitReadOnSpecificColumnsString.equals("true")) {
                _limitReadOnSpecificColumns = true;
            }
            _limitReadColumnNameMap.clear();
            String nameString = DTProperties.get(thisClassName, "limitReadColumnNames");
            int start = 0;
            while (nameString != null && start < nameString.length()) {
                String name;
                int end = nameString.indexOf(44, start + 1);
                if (end > -1) {
                    name = nameString.substring(start + 1, end);
                    start = end;
                } else {
                    name = nameString.substring(start + 1);
                    start = nameString.length();
                }
                _limitReadColumnNameMap.put(name, null);
            }
            propertiesAlreadyLoaded = true;
        }
    }

    @Override
    public String getClassName() {
        return "java.lang.String";
    }

    @Override
    public String renderObject(Object value) {
        String text = (String)this._renderer.renderObject(value);
        if (_makeNewlinesVisibleInCell) {
            text = text.replaceAll("\n", "/\\n");
        }
        return text;
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return originalValue == null || ((String)originalValue).indexOf(10) <= -1;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        if (!_limitRead) {
            return false;
        }
        if (originalValue == null) {
            return false;
        }
        if (((String)originalValue).length() < _limitReadLength) {
            return false;
        }
        if (((String)originalValue).length() > _limitReadLength) {
            return false;
        }
        if (!_limitReadOnSpecificColumns) {
            return true;
        }
        return _limitReadColumnNameMap.containsKey(this._colDef.getColumnName());
    }

    @Override
    public JTextField getJTextField() {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeString.this._textComponent, evt, DataTypeString.this._table);
                    CellDataPopup.showDialog(DataTypeString.this._table, DataTypeString.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value.equals("<null>")) {
            return null;
        }
        return value;
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return false;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return !this.needToReRead(originalValue);
    }

    @Override
    public JTextArea getJTextArea(Object value) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText((String)this._renderer.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        String data = rs.getString(index);
        if (rs.wasNull()) {
            return null;
        }
        if (limitDataRead && _limitRead && data.length() >= _limitReadLength && (!_limitReadOnSpecificColumns || _limitReadOnSpecificColumns && _limitReadColumnNameMap.containsKey(this._colDef.getColumnName()))) {
            data = data.substring(0, _limitReadLength);
        }
        return data;
    }

    @Override
    public String getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (this._colDef.getSqlType() == -1 && !_useLongInWhere) {
            return null;
        }
        if (value == null || value.toString() == null) {
            return this._colDef.getColumnName() + " IS NULL";
        }
        if (!this.needToReRead(value)) {
            return this._colDef.getColumnName() + "='" + DataTypeString.escapeLine(value.toString(), md) + "'";
        }
        return null;
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            pstmt.setString(position, (String)value);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return "";
    }

    public static String escapeLine(String s, ISQLDatabaseMetaData md) {
        String retvalue = s;
        if (s.indexOf("'") != -1) {
            StringBuffer hold = new StringBuffer();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\'') {
                    hold.append("''");
                    continue;
                }
                hold.append(c);
            }
            retvalue = hold.toString();
        }
        return DatabaseSpecificEscape.escapeSQL(retvalue, md);
    }

    @Override
    public boolean canDoFileIO() {
        return true;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        if (this._columnSize > 0 && fileText.length() > this._columnSize) {
            throw new IOException("File contains " + fileText.length() + " characters which exceeds this column's limit of " + this._columnSize + ".\nImport Aborted.");
        }
        return fileText;
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        outWriter.write(text);
        outWriter.flush();
        outWriter.close();
    }

    public static OkJPanel getControlPanel() {
        DataTypeString.loadProperties();
        return new ClobOkJPanel();
    }

    private static class ClobOkJPanel
    extends OkJPanel {
        private static final long serialVersionUID = -578848466466561988L;
        private JCheckBox _makeNewlinesVisibleInCellChk = new JCheckBox(DataTypeString.access$500().getString("dataTypeString.newlines"));
        private JCheckBox _useLongInWhereChk = new JCheckBox(DataTypeString.access$500().getString("dataTypeString.allowLongVarchar"));
        private JCheckBox _limitReadChk = new JCheckBox(DataTypeString.access$500().getString("dataTypeString.limitSize"));
        private IntegerField _limitReadLengthTextField = new IntegerField(5);
        private JCheckBox _limitReadOnSpecificColumnsChk = new JCheckBox(DataTypeString.access$500().getString("dataTypeString.limitReadOnly"));
        private JTextArea _limitReadColumnNameTextArea = new JTextArea(5, 12);

        public ClobOkJPanel() {
            this._makeNewlinesVisibleInCellChk.setSelected(_makeNewlinesVisibleInCell);
            this._useLongInWhereChk.setSelected(_useLongInWhere);
            this._limitReadChk.setSelected(_limitRead);
            this._limitReadChk.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ClobOkJPanel.this._limitReadLengthTextField.setEnabled(ClobOkJPanel.this._limitReadChk.isSelected());
                    ClobOkJPanel.this._limitReadOnSpecificColumnsChk.setEnabled(ClobOkJPanel.this._limitReadChk.isSelected());
                    ClobOkJPanel.this._limitReadColumnNameTextArea.setEnabled(ClobOkJPanel.this._limitReadChk.isSelected() && ClobOkJPanel.this._limitReadOnSpecificColumnsChk.isSelected());
                }
            });
            this._limitReadLengthTextField.setInt(_limitReadLength);
            this._limitReadOnSpecificColumnsChk.setSelected(_limitReadOnSpecificColumns);
            this._limitReadOnSpecificColumnsChk.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ClobOkJPanel.this._limitReadColumnNameTextArea.setEnabled(ClobOkJPanel.this._limitReadOnSpecificColumnsChk.isSelected());
                }
            });
            Iterator names = _limitReadColumnNameMap.keySet().iterator();
            StringBuffer namesText = new StringBuffer();
            while (names.hasNext()) {
                if (namesText.length() > 0) {
                    namesText.append("\n" + (String)names.next());
                    continue;
                }
                namesText.append((String)names.next());
            }
            this._limitReadColumnNameTextArea.setText(namesText.toString());
            this._limitReadLengthTextField.setEnabled(this._limitReadChk.isSelected());
            this._limitReadOnSpecificColumnsChk.setEnabled(this._limitReadChk.isSelected());
            this._limitReadColumnNameTextArea.setEnabled(this._limitReadChk.isSelected() && this._limitReadOnSpecificColumnsChk.isSelected());
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dataTypeString.typeChar")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 0;
            this.add((Component)this._makeNewlinesVisibleInCellChk, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 0;
            this.add((Component)this._useLongInWhereChk, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            this.add((Component)this._limitReadChk, gbc);
            ++gbc.gridx;
            gbc.gridwidth = 1;
            this.add((Component)this._limitReadLengthTextField, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            this.add((Component)this._limitReadOnSpecificColumnsChk, gbc);
            ++gbc.gridx;
            gbc.gridwidth = 0;
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setHorizontalScrollBarPolicy(32);
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setViewportView(this._limitReadColumnNameTextArea);
            this.add((Component)scrollPane, gbc);
        }

        @Override
        public void ok() {
            _makeNewlinesVisibleInCell = this._makeNewlinesVisibleInCellChk.isSelected();
            DTProperties.put(DataTypeString.thisClassName, "makeNewlinesVisibleInCell", Boolean.valueOf(_makeNewlinesVisibleInCell).toString());
            _useLongInWhere = this._useLongInWhereChk.isSelected();
            DTProperties.put(DataTypeString.thisClassName, "useLongInWhere", Boolean.valueOf(_useLongInWhere).toString());
            _limitRead = this._limitReadChk.isSelected();
            DTProperties.put(DataTypeString.thisClassName, "limitRead", Boolean.valueOf(_limitRead).toString());
            _limitReadLength = this._limitReadLengthTextField.getInt();
            DTProperties.put(DataTypeString.thisClassName, "limitReadLength", Integer.toString(_limitReadLength));
            _limitReadOnSpecificColumns = this._limitReadOnSpecificColumnsChk.isSelected();
            DTProperties.put(DataTypeString.thisClassName, "limitReadOnSpecificColumns", Boolean.valueOf(_limitReadOnSpecificColumns).toString());
            _limitReadColumnNameMap.clear();
            String columnNameText = this._limitReadColumnNameTextArea.getText();
            int start = 0;
            String propertyString = "";
            while (start < columnNameText.length()) {
                String name;
                int end = columnNameText.indexOf(10, start + 1);
                if (end > -1) {
                    name = columnNameText.substring(start, end);
                    start = end;
                } else {
                    name = columnNameText.substring(start);
                    start = columnNameText.length();
                }
                name = name.trim().toUpperCase();
                if (name.length() == 0) continue;
                _limitReadColumnNameMap.put(name.trim().toUpperCase(), null);
                propertyString = propertyString + "," + name.trim().toUpperCase();
            }
            DTProperties.put(DataTypeString.thisClassName, "limitReadColumnNames", propertyString);
        }
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeString.this._textComponent);
            String text = _theComponent.getText();
            if (DataTypeString.this._columnSize > 0 && text.length() >= DataTypeString.this._columnSize && c != '\b' && c != '\u007f') {
                e.consume();
                DataTypeString.this._beepHelper.beep(_theComponent);
            }
            if (DataTypeString.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeString.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeString.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() == 0) {
                    DataTypeString.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField(text, c, e, DataTypeString.this._textComponent);
            }
        }
    }
}

