/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DataTypeUnknown
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeUnknown.class);
    private DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();
    private static final String thisClassName = "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeUnknown";
    private static boolean propertiesAlreadyLoaded = false;
    private static boolean _readUnknown = false;

    public DataTypeUnknown(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        DataTypeUnknown.loadProperties();
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            _readUnknown = false;
            String readUnknownString = DTProperties.get(thisClassName, "readUnknown");
            if (readUnknownString != null && readUnknownString.equals("true")) {
                _readUnknown = true;
            }
            propertiesAlreadyLoaded = true;
        }
    }

    @Override
    public String getClassName() {
        return "java.lang.String";
    }

    @Override
    public String renderObject(Object value) {
        return (String)this._renderer.renderObject(value);
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return false;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField() {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeUnknown.this._textComponent, evt, DataTypeUnknown.this._table);
                    CellDataPopup.showDialog(DataTypeUnknown.this._table, DataTypeUnknown.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        return null;
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return false;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return false;
    }

    @Override
    public JTextArea getJTextArea(Object value) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        String data = null;
        data = _readUnknown ? rs.getString(index) : s_stringMgr.getString("DataTypeUnknown.unknown", this._colDef.getSqlType());
        if (rs.wasNull()) {
            return null;
        }
        return data;
    }

    @Override
    public String getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return this._colDef.getColumnName() + " IS NULL";
        }
        return "";
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        throw new SQLException("Can not update data of type OTHER");
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return null;
    }

    @Override
    public boolean canDoFileIO() {
        return false;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        throw new IOException("Can not import data type OTHER");
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        throw new IOException("Can not export data type OTHER");
    }

    public static OkJPanel getControlPanel() {
        DataTypeUnknown.loadProperties();
        return new UnknownOkJPanel();
    }

    private static class UnknownOkJPanel
    extends OkJPanel {
        private static final long serialVersionUID = 1L;
        private JCheckBox _showUnknownChk = new JCheckBox(DataTypeUnknown.access$300().getString("dataTypeUnknown.readContentsOnLoad"));

        public UnknownOkJPanel() {
            this._showUnknownChk.setSelected(_readUnknown);
            this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dataTypeUnknown.unknownTypes")));
            this.add(this._showUnknownChk);
        }

        @Override
        public void ok() {
            _readUnknown = this._showUnknownChk.isSelected();
            DTProperties.put(DataTypeUnknown.thisClassName, "readUnknown", Boolean.valueOf(_readUnknown).toString());
        }
    }

    private class KeyTextHandler
    extends KeyAdapter {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeUnknown.this._textComponent);
            DataTypeUnknown.this._beepHelper.beep(_theComponent);
            e.consume();
        }
    }
}

