/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JFrame;
import net.sourceforge.squirrel_sql.fw.dialects.AxionDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.DB2DialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.DaffodilDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.DerbyDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.FirebirdDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.FrontBaseDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.GenericDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.H2DialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.HADBDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.HSQLDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.InformixDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.IngresDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.InterbaseDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.IntersystemsCacheDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.MAXDBDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.McKoiDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.MySQL5DialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.MySQLDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.NetezzaDialextExt;
import net.sourceforge.squirrel_sql.fw.dialects.OracleDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.PointbaseDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.PostgreSQLDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.ProgressDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.SQLServerDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.SybaseDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.TimesTenDialectExt;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.DialogUtils;
import net.sourceforge.squirrel_sql.fw.gui.IDialogUtils;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DialectFactory {
    public static final int SOURCE_TYPE = 0;
    public static final int DEST_TYPE = 1;
    private static final ILogger s_log = LoggerController.createLogger(DialectFactory.class);
    private static final AxionDialectExt axionDialect = new AxionDialectExt();
    private static final DB2DialectExt db2Dialect = new DB2DialectExt();
    private static final DaffodilDialectExt daffodilDialect = new DaffodilDialectExt();
    private static final DerbyDialectExt derbyDialect = new DerbyDialectExt();
    private static final FirebirdDialectExt firebirdDialect = new FirebirdDialectExt();
    private static final FrontBaseDialectExt frontbaseDialect = new FrontBaseDialectExt();
    private static final GenericDialectExt genericDialect = new GenericDialectExt();
    private static final HADBDialectExt hadbDialect = new HADBDialectExt();
    private static final H2DialectExt h2Dialect = new H2DialectExt();
    private static final HSQLDialectExt hsqlDialect = new HSQLDialectExt();
    private static final InformixDialectExt informixDialect = new InformixDialectExt();
    private static final InterbaseDialectExt interbaseDialect = new InterbaseDialectExt();
    private static final IngresDialectExt ingresDialect = new IngresDialectExt();
    private static final MAXDBDialectExt maxDbDialect = new MAXDBDialectExt();
    private static final McKoiDialectExt mckoiDialect = new McKoiDialectExt();
    private static final MySQLDialectExt mysqlDialect = new MySQLDialectExt();
    private static final MySQL5DialectExt mysql5Dialect = new MySQL5DialectExt();
    private static final NetezzaDialextExt netezzaDialect = new NetezzaDialextExt();
    private static final OracleDialectExt oracle9iDialect = new OracleDialectExt();
    private static final PointbaseDialectExt pointbaseDialect = new PointbaseDialectExt();
    private static final PostgreSQLDialectExt postgreSQLDialect = new PostgreSQLDialectExt();
    private static final ProgressDialectExt progressDialect = new ProgressDialectExt();
    private static final SybaseDialectExt sybaseDialect = new SybaseDialectExt();
    private static final SQLServerDialectExt sqlserverDialect = new SQLServerDialectExt();
    private static final TimesTenDialectExt timestenDialect = new TimesTenDialectExt();
    private static final IntersystemsCacheDialectExt intersystemsCacheDialectExt = new IntersystemsCacheDialectExt();
    private static HashMap<String, HibernateDialect> dbNameDialectMap = new HashMap();
    public static boolean isPromptForDialect = false;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DialectFactory.class);
    private static IDialogUtils dialogUtils = new DialogUtils();

    public static void setDialogUtils(IDialogUtils dialogUtils) {
        DialectFactory.dialogUtils = dialogUtils;
    }

    public static boolean isAxion(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, axionDialect);
    }

    public static boolean isDaffodil(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, daffodilDialect);
    }

    public static boolean isDB2(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, db2Dialect);
    }

    public static boolean isDerby(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, derbyDialect);
    }

    public static boolean isFirebird(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, firebirdDialect);
    }

    public static boolean isFrontBase(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, frontbaseDialect);
    }

    public static boolean isHADB(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, hadbDialect);
    }

    public static boolean isH2(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, h2Dialect);
    }

    public static boolean isHSQL(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, hsqlDialect);
    }

    public static boolean isInformix(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, informixDialect);
    }

    public static boolean isIngres(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, ingresDialect);
    }

    public static boolean isInterbase(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, interbaseDialect);
    }

    public static boolean isMaxDB(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, maxDbDialect);
    }

    public static boolean isMcKoi(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, mckoiDialect);
    }

    public static boolean isMSSQLServer(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, sqlserverDialect);
    }

    public static boolean isMySQL(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, mysqlDialect);
    }

    public static boolean isMySQL5(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, mysql5Dialect);
    }

    public static boolean isNetezza(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, netezzaDialect);
    }

    public static boolean isOracle(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, oracle9iDialect);
    }

    public static boolean isPointbase(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, pointbaseDialect);
    }

    public static boolean isPostgreSQL(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, postgreSQLDialect);
    }

    public static boolean isProgress(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, progressDialect);
    }

    public static boolean isSyBase(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, sybaseDialect);
    }

    public static boolean isTimesTen(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, timestenDialect);
    }

    public static boolean isIntersystemsCacheDialectExt(ISQLDatabaseMetaData md) {
        return DialectFactory.dialectSupportsProduct(md, intersystemsCacheDialectExt);
    }

    public static DialectType getDialectType(ISQLDatabaseMetaData md) {
        HibernateDialect dialect = DialectFactory.getDialect(md);
        return dialect.getDialectType();
    }

    private static boolean dialectSupportsProduct(ISQLDatabaseMetaData data, HibernateDialect dialect) {
        boolean result;
        block3: {
            result = false;
            if (data != null && dialect != null) {
                try {
                    String productName = data.getDatabaseProductName();
                    String productVersion = data.getDatabaseProductVersion();
                    result = dialect.supportsProduct(productName, productVersion);
                }
                catch (Exception e) {
                    s_log.error("Encountered unexpected exception while attempting to determine database product name/version: " + e.getMessage());
                    if (!s_log.isDebugEnabled()) break block3;
                    StringWriter s = new StringWriter();
                    PrintWriter p = new PrintWriter(s);
                    e.printStackTrace(p);
                    s_log.debug(s.getBuffer().toString());
                }
            }
        }
        return result;
    }

    public static HibernateDialect getDialect(String dbName) {
        return dbNameDialectMap.get(dbName);
    }

    public static HibernateDialect getDialectIgnoreCase(String dbName) {
        for (String displayName : dbNameDialectMap.keySet()) {
            if (!displayName.toLowerCase().equals(dbName.toLowerCase())) continue;
            return dbNameDialectMap.get(displayName);
        }
        return null;
    }

    public static HibernateDialect getDialect(ISQLDatabaseMetaData md) {
        if (DialectFactory.isAxion(md)) {
            return axionDialect;
        }
        if (DialectFactory.isDaffodil(md)) {
            return daffodilDialect;
        }
        if (DialectFactory.isDB2(md)) {
            return db2Dialect;
        }
        if (DialectFactory.isDerby(md)) {
            return derbyDialect;
        }
        if (DialectFactory.isFirebird(md)) {
            return firebirdDialect;
        }
        if (DialectFactory.isFrontBase(md)) {
            return frontbaseDialect;
        }
        if (DialectFactory.isHADB(md)) {
            return hadbDialect;
        }
        if (DialectFactory.isH2(md)) {
            return h2Dialect;
        }
        if (DialectFactory.isHSQL(md)) {
            return hsqlDialect;
        }
        if (DialectFactory.isInformix(md)) {
            return informixDialect;
        }
        if (DialectFactory.isIngres(md)) {
            return ingresDialect;
        }
        if (DialectFactory.isInterbase(md)) {
            return ingresDialect;
        }
        if (DialectFactory.isMaxDB(md)) {
            return maxDbDialect;
        }
        if (DialectFactory.isMcKoi(md)) {
            return mckoiDialect;
        }
        if (DialectFactory.isMySQL(md)) {
            return mysqlDialect;
        }
        if (DialectFactory.isMySQL5(md)) {
            return mysql5Dialect;
        }
        if (DialectFactory.isMSSQLServer(md)) {
            return sqlserverDialect;
        }
        if (DialectFactory.isNetezza(md)) {
            return netezzaDialect;
        }
        if (DialectFactory.isOracle(md)) {
            return oracle9iDialect;
        }
        if (DialectFactory.isPointbase(md)) {
            return pointbaseDialect;
        }
        if (DialectFactory.isPostgreSQL(md)) {
            return postgreSQLDialect;
        }
        if (DialectFactory.isProgress(md)) {
            return progressDialect;
        }
        if (DialectFactory.isSyBase(md)) {
            return sybaseDialect;
        }
        if (DialectFactory.isTimesTen(md)) {
            return timestenDialect;
        }
        if (DialectFactory.isIntersystemsCacheDialectExt(md)) {
            return intersystemsCacheDialectExt;
        }
        return genericDialect;
    }

    public static HibernateDialect getDialect(int sessionType, JFrame parent, ISQLDatabaseMetaData md) throws UserCancelledOperationException {
        HibernateDialect result = null;
        result = isPromptForDialect ? DialectFactory.showDialectDialog(parent, sessionType) : DialectFactory.getDialect(md);
        return result;
    }

    private static HibernateDialect showDialectDialog(JFrame parent, int sessionType) throws UserCancelledOperationException {
        String dbName;
        Object[] dbNames = DialectFactory.getDbNames();
        String chooserTitle = s_stringMgr.getString("dialectChooseTitle");
        String typeStr = null;
        if (sessionType == 0) {
            typeStr = s_stringMgr.getString("sourceSessionTypeName");
        }
        if (sessionType == 1) {
            typeStr = s_stringMgr.getString("destSessionTypeName");
        }
        String message = s_stringMgr.getString("dialectDetectFailedMessage", typeStr);
        if (isPromptForDialect) {
            message = s_stringMgr.getString("autoDetectDisabledMessage", typeStr);
        }
        if ((dbName = dialogUtils.showInputDialog(parent, message, chooserTitle, 1, null, dbNames, dbNames[0])) == null || "".equals(dbName)) {
            throw new UserCancelledOperationException();
        }
        return dbNameDialectMap.get(dbName);
    }

    public static Object[] getDbNames() {
        Set<String> keyset = dbNameDialectMap.keySet();
        Object[] keys = keyset.toArray();
        Arrays.sort(keys);
        return keys;
    }

    public static Object[] getSupportedDialects() {
        Collection<HibernateDialect> c = dbNameDialectMap.values();
        return c.toArray();
    }

    static {
        dbNameDialectMap.put(axionDialect.getDisplayName(), axionDialect);
        dbNameDialectMap.put(db2Dialect.getDisplayName(), db2Dialect);
        dbNameDialectMap.put(daffodilDialect.getDisplayName(), daffodilDialect);
        dbNameDialectMap.put(derbyDialect.getDisplayName(), derbyDialect);
        dbNameDialectMap.put(firebirdDialect.getDisplayName(), firebirdDialect);
        dbNameDialectMap.put(frontbaseDialect.getDisplayName(), frontbaseDialect);
        dbNameDialectMap.put(hadbDialect.getDisplayName(), hadbDialect);
        dbNameDialectMap.put(hsqlDialect.getDisplayName(), hsqlDialect);
        dbNameDialectMap.put(h2Dialect.getDisplayName(), h2Dialect);
        dbNameDialectMap.put(informixDialect.getDisplayName(), informixDialect);
        dbNameDialectMap.put(ingresDialect.getDisplayName(), ingresDialect);
        dbNameDialectMap.put(interbaseDialect.getDisplayName(), interbaseDialect);
        dbNameDialectMap.put(maxDbDialect.getDisplayName(), maxDbDialect);
        dbNameDialectMap.put(mckoiDialect.getDisplayName(), mckoiDialect);
        dbNameDialectMap.put(mysqlDialect.getDisplayName(), mysqlDialect);
        dbNameDialectMap.put(netezzaDialect.getDisplayName(), netezzaDialect);
        dbNameDialectMap.put(oracle9iDialect.getDisplayName(), oracle9iDialect);
        dbNameDialectMap.put(pointbaseDialect.getDisplayName(), pointbaseDialect);
        dbNameDialectMap.put(postgreSQLDialect.getDisplayName(), postgreSQLDialect);
        dbNameDialectMap.put(progressDialect.getDisplayName(), progressDialect);
        dbNameDialectMap.put(sqlserverDialect.getDisplayName(), sqlserverDialect);
        dbNameDialectMap.put(sybaseDialect.getDisplayName(), sybaseDialect);
        dbNameDialectMap.put(timestenDialect.getDisplayName(), timestenDialect);
        dbNameDialectMap.put(intersystemsCacheDialectExt.getDisplayName(), intersystemsCacheDialectExt);
    }
}

