/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.MyTableModel;
import net.sourceforge.squirrel_sql.fw.gui.SortingListener;

public class SortableTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3534263285990454876L;
    private transient MyTableModelListener _actualModelLis = new MyTableModelListener();
    private int _sortedColumn = -1;
    private boolean _ascending;
    private TableModel _actualModel;
    private ArrayList<SortingListener> _sortingListeners = new ArrayList();
    private Integer[] _indexes = new Integer[0];

    public TableModel getActualModel() {
        return this._actualModel;
    }

    public SortableTableModel(TableModel model) {
        this.setActualModel(model);
    }

    public void setActualModel(TableModel newModel) {
        if (this._actualModel != null) {
            this._actualModel.removeTableModelListener(this._actualModelLis);
        }
        this._actualModel = newModel;
        if (this._actualModel != null) {
            this._actualModel.addTableModelListener(this._actualModelLis);
        }
        this.tableChangedIntern();
    }

    @Override
    public int getRowCount() {
        return this._actualModel != null ? this._actualModel.getRowCount() : 0;
    }

    @Override
    public int getColumnCount() {
        return this._actualModel != null ? this._actualModel.getColumnCount() : 0;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (-42 == col) {
            return row + 1;
        }
        if (row < this._indexes.length) {
            return this._actualModel.getValueAt(this._indexes[row], col);
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this._actualModel.setValueAt(value, this._indexes[row], col);
    }

    @Override
    public String getColumnName(int col) {
        return this._actualModel.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this._actualModel.getColumnClass(col);
    }

    public void deleteRows(int[] rows) {
        int[] actualRows = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] >= this._indexes.length) continue;
            actualRows[i] = this._indexes[rows[i]];
        }
        ((MyTableModel)this._actualModel).deleteRows(actualRows);
    }

    public void insertRow(Object[] values) {
        ((MyTableModel)this._actualModel).addRow(values);
        ((MyTableModel)this._actualModel).fireTableChanged(new TableModelEvent(this._actualModel));
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this._actualModel.isCellEditable(row, col);
    }

    public boolean sortByColumn(int column) {
        boolean b = true;
        if (column == this._sortedColumn) {
            b = !this._ascending;
        }
        this.sortByColumn(column, b);
        return b;
    }

    public void sortByColumn(int column, boolean ascending) {
        this._sortedColumn = column;
        this._ascending = ascending;
        TableModelComparator comparator = new TableModelComparator(column, ascending);
        Arrays.sort(this._indexes, comparator);
        this.fireTableDataChanged();
        this.fireSortingListeners(column, ascending);
    }

    private void fireSortingListeners(int column, boolean ascending) {
        SortingListener[] listeners;
        for (SortingListener listener : listeners = this._sortingListeners.toArray(new SortingListener[this._sortingListeners.size()])) {
            listener.sortingDone(column, ascending);
        }
    }

    public boolean isSortedAscending() {
        return this._ascending;
    }

    public void tableChanged() {
        this.tableChangedIntern();
        if (-1 != this._sortedColumn) {
            this.sortByColumn(this._sortedColumn, this._ascending);
        } else {
            this.fireTableDataChanged();
        }
    }

    private void tableChangedIntern() {
        this._indexes = new Integer[this.getRowCount()];
        for (int i = 0; i < this._indexes.length; ++i) {
            this._indexes[i] = i;
        }
    }

    public int transfromToModelRow(int row) {
        if (0 > row || row >= this._indexes.length) {
            return -1;
        }
        return this._indexes[row];
    }

    public void removeSortingListener(SortingListener sortingListener) {
        this._sortingListeners.remove(sortingListener);
    }

    public void addSortingListener(SortingListener sortingListener) {
        this._sortingListeners.add(sortingListener);
    }

    public int getSortedColumn() {
        return this._sortedColumn;
    }

    protected class MyTableModelListener
    implements TableModelListener {
        protected MyTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent evt) {
            SortableTableModel.this.tableChangedIntern();
        }
    }

    class TableModelComparator
    implements Comparator<Integer> {
        private int _iColumn;
        private int _iAscending;
        private final Collator _collator = Collator.getInstance();
        private boolean _allDataIsString = true;

        public TableModelComparator(int iColumn) {
            this(iColumn, true);
        }

        public TableModelComparator(int iColumn, boolean ascending) {
            this._iColumn = iColumn;
            this._iAscending = ascending ? 1 : -1;
            this._collator.setStrength(0);
            this._collator.setStrength(2);
            int limit = SortableTableModel.this._actualModel.getRowCount();
            for (int i = 0; i < limit; ++i) {
                Object data = SortableTableModel.this._actualModel.getValueAt(i, this._iColumn);
                if (data instanceof String) continue;
                this._allDataIsString = false;
                break;
            }
        }

        @Override
        public int compare(Integer i1, Integer i2) {
            Object data1 = SortableTableModel.this._actualModel.getValueAt(i1, this._iColumn);
            Object data2 = SortableTableModel.this._actualModel.getValueAt(i2, this._iColumn);
            try {
                if (data1 == null && data2 == null) {
                    return 0;
                }
                if (data1 == null) {
                    return 1 * this._iAscending;
                }
                if (data2 == null) {
                    return -1 * this._iAscending;
                }
                if (!this._allDataIsString) {
                    Comparable c1 = (Comparable)data1;
                    return c1.compareTo(data2) * this._iAscending;
                }
                return this._collator.compare((String)data1, (String)data2) * this._iAscending;
            }
            catch (ClassCastException ex) {
                return data1.toString().compareTo(data2.toString()) * this._iAscending;
            }
        }
    }
}

