/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.xml;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLParserFactory;
import net.sourceforge.squirrel_sql.fw.util.EnumerationIterator;
import net.sourceforge.squirrel_sql.fw.util.beanwrapper.StringWrapper;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;

public class XMLBeanReader
implements Iterable<Object> {
    private static final ILogger s_log = LoggerController.createLogger(XMLBeanReader.class);
    private String[][] _fixStrings = new String[][]{{"com.bigfoot.colbell.squirrel", "net.sourceforge.squirrel_sql.client"}, {"com.bigfoot.colbell.fw", "net.sourceforge.squirrel_sql.fw"}, {"net.sourceforge.squirrel_sql.client.mainframe.MainFrameWindowState", "net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrameWindowState"}};
    private ClassLoader _cl;
    private final List<Object> _beanColl = new ArrayList<Object>();

    public void load(File xmlFile) throws FileNotFoundException, XMLException {
        this.load(xmlFile, null);
    }

    public void load(File xmlFile, ClassLoader cl) throws FileNotFoundException, XMLException {
        if (!xmlFile.exists()) {
            throw new FileNotFoundException(xmlFile.getName());
        }
        this.load(xmlFile.getAbsolutePath(), cl);
    }

    public void load(String xmlFileName) throws FileNotFoundException, XMLException {
        this.load(xmlFileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(String xmlFileName, ClassLoader cl) throws FileNotFoundException, IllegalArgumentException, XMLException {
        if (xmlFileName == null) {
            throw new IllegalArgumentException("Null xmlFileName passed");
        }
        this._cl = cl;
        this._beanColl.clear();
        FileReader frdr = new FileReader(xmlFileName);
        try {
            this.load(frdr, cl);
        }
        finally {
            try {
                frdr.close();
            }
            catch (IOException ex) {
                s_log.error("Error closing FileReader", ex);
            }
        }
    }

    public void load(Reader rdr) throws XMLException {
        this.load(rdr, null);
    }

    public void load(Reader rdr, ClassLoader cl) throws XMLException {
        try {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            parser.setReader((IXMLReader)new StdXMLReader(rdr));
            IXMLElement element = (IXMLElement)parser.parse();
            if (element != null) {
                EnumerationIterator it = new EnumerationIterator(element.enumerateChildren());
                while (it.hasNext()) {
                    IXMLElement elem = (IXMLElement)it.next();
                    if (!this.isBeanElement(elem)) continue;
                    this._beanColl.add(this.loadBean(elem));
                }
            }
        }
        catch (Exception ex) {
            throw new XMLException(ex);
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return this._beanColl.iterator();
    }

    private Object loadBean(IXMLElement beanElement) throws XMLException {
        String beanClassName = null;
        try {
            beanClassName = this.getClassNameFromElement(beanElement);
            beanClassName = this.fixClassName(beanClassName);
            Class<?> beanClass = null;
            beanClass = this._cl == null ? Class.forName(beanClassName) : Class.forName(beanClassName, true, this._cl);
            Object bean = beanClass.newInstance();
            BeanInfo info = Introspector.getBeanInfo(bean.getClass(), 1);
            PropertyDescriptor[] propDesc = info.getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> props = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < propDesc.length; ++i) {
                props.put(propDesc[i].getName(), propDesc[i]);
            }
            Vector children = beanElement.getChildren();
            for (IXMLElement propElem : children) {
                PropertyDescriptor curProp = (PropertyDescriptor)props.get(propElem.getName());
                if (curProp == null) continue;
                this.loadProperty(bean, curProp, propElem);
            }
            return bean;
        }
        catch (Exception ex) {
            s_log.error("Unexpected exception while attempting to load xml bean " + ex.getMessage(), ex);
            throw new XMLException(ex);
        }
    }

    private void loadProperty(Object bean, PropertyDescriptor propDescr, IXMLElement propElem) throws XMLException {
        Method setter = propDescr.getWriteMethod();
        if (setter != null) {
            Class<?> parmType = setter.getParameterTypes()[0];
            Class<?> arrayType = parmType.getComponentType();
            String value = propElem.getContent();
            if (value == null && parmType.isPrimitive()) {
                s_log.warn("Parameter type was primitive (" + parmType + "), but the value was null.  " + "Skipping invokation of method: " + setter.getName() + " in declaring class: " + setter.getDeclaringClass());
                return;
            }
            if (this.isIndexedElement(propElem)) {
                Object[] data = this.loadIndexedProperty(propElem);
                try {
                    if (arrayType.getName().equals("java.lang.String")) {
                        Object[] stringData = new Object[data.length];
                        for (int i = 0; i < data.length; ++i) {
                            stringData[i] = ((StringWrapper)data[i]).getString();
                        }
                        data = stringData;
                    }
                    Object obj = Array.newInstance(arrayType, data.length);
                    System.arraycopy(data, 0, obj, 0, data.length);
                    setter.invoke(bean, obj);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (this.isBeanElement(propElem)) {
                Object data = this.loadBean(propElem);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Boolean.TYPE) {
                Boolean data = Boolean.valueOf(value);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Integer.TYPE) {
                Integer data = new Integer(value);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Short.TYPE) {
                Short data = new Short(value);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Long.TYPE) {
                Long data = new Long(value);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Float.TYPE) {
                Float data = new Float(value);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Double.TYPE) {
                Double data = new Double(value);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Character.TYPE) {
                Character data = value != null && value.length() > 0 ? new Character(value.charAt(0)) : new Character(' ');
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            String data = value;
            try {
                setter.invoke(bean, data);
            }
            catch (Exception ex) {
                throw new XMLException(ex);
            }
        }
    }

    private Object[] loadIndexedProperty(IXMLElement beanElement) throws XMLException {
        ArrayList<Object> beans = new ArrayList<Object>();
        Vector children = beanElement.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            beans.add(this.loadBean((IXMLElement)it.next()));
        }
        return beans.toArray(new Object[beans.size()]);
    }

    private boolean isBeanElement(IXMLElement elem) {
        return elem.getAttribute("Class", null) != null;
    }

    private boolean isIndexedElement(IXMLElement elem) {
        String att = elem.getAttribute("Indexed", "false");
        return att != null && att.equals("true");
    }

    private String getClassNameFromElement(IXMLElement elem) {
        return elem.getAttribute("Class", null);
    }

    private String fixClassName(String className) {
        for (int i = 0; i < this._fixStrings.length; ++i) {
            String from = this._fixStrings[i][0];
            if (!className.startsWith(from)) continue;
            className = this._fixStrings[i][1] + className.substring(from.length());
            break;
        }
        return className;
    }
}

