/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Application;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;
import net.sourceforge.squirrel_sql.client.SquirrelLoggerFactory;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.ILoggerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.util.log.SystemOutToLog;

public class Main {
    private static ILogger s_log;

    private Main() {
    }

    public static void main(String[] args) throws IOException {
        if (ApplicationArguments.initialize(args)) {
            ApplicationArguments appArgs;
            if (!Version.supportsUsedJDK()) {
                JOptionPane.showMessageDialog(null, Version.getUnsupportedJDKMessage());
                System.exit(-1);
            }
            if ((appArgs = ApplicationArguments.getInstance()).getShowHelp()) {
                appArgs.printHelp();
            } else {
                Main.startApp();
            }
        }
    }

    private static void startApp() throws IOException {
        LoggerController.registerLoggerFactory((ILoggerFactory)new SquirrelLoggerFactory(true));
        s_log = LoggerController.createLogger(Main.class);
        System.setErr(new PrintStream((OutputStream)new SystemOutToLog(System.err)));
        System.setOut(new PrintStream((OutputStream)new SystemOutToLog(System.out)));
        EventQueue q = Toolkit.getDefaultToolkit().getSystemEventQueue();
        q.push(new EventQueue(){

            @Override
            protected void dispatchEvent(AWTEvent event) {
                try {
                    super.dispatchEvent(event);
                }
                catch (Throwable t) {
                    if (s_log.isDebugEnabled()) {
                        t.printStackTrace();
                    }
                    s_log.error((Object)("Exception occured dispatching Event " + event), t);
                }
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                new Application().startup();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

