/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;
import net.sourceforge.squirrel_sql.client.SquirrelAppender;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.Log4jLoggerFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class SquirrelLoggerFactory
extends Log4jLoggerFactory {
    public SquirrelLoggerFactory(FileAppender fa, boolean doStartupLogging) {
        super(false);
        this.initialize(fa, doStartupLogging);
    }

    public SquirrelLoggerFactory(boolean doStartupLogging) {
        try {
            SquirrelAppender fa = new SquirrelAppender();
            this.initialize((FileAppender)fa, doStartupLogging);
        }
        catch (Exception e) {
            ILogger log = this.createLogger(((Object)((Object)this)).getClass());
            log.error((Object)"Error occured configuring logging. Now logging to standard output", (Throwable)e);
            BasicConfigurator.configure();
        }
    }

    private void initialize(FileAppender fa, boolean doStartupLogging) {
        String configFileName = ApplicationArguments.getInstance().getLoggingConfigFileName();
        if (configFileName != null) {
            PropertyConfigurator.configure((String)configFileName);
        } else {
            Logger.getRootLogger().removeAllAppenders();
            BasicConfigurator.configure((Appender)fa);
            ILogger log = this.createLogger(((Object)((Object)this)).getClass());
            if (log.isInfoEnabled()) {
                log.info((Object)("No logger configuration file passed on command line arguments. Using default log file: " + fa.getFile()));
            }
        }
        if (doStartupLogging) {
            this.doStartupLogging();
        }
    }

    private void doStartupLogging() {
        ILogger log = this.createLogger(((Object)((Object)this)).getClass());
        log.info((Object)"#############################################################################################################");
        log.info((Object)("# Starting " + Version.getVersion() + " at " + DateFormat.getInstance().format(new Date())));
        log.info((Object)"#############################################################################################################");
        log.info((Object)(Version.getVersion() + " started: " + Calendar.getInstance().getTime()));
        log.info((Object)Version.getCopyrightStatement());
        log.info((Object)("java.vendor: " + System.getProperty("java.vendor")));
        log.info((Object)("java.version: " + System.getProperty("java.version")));
        log.info((Object)("java.runtime.name: " + System.getProperty("java.runtime.name")));
        log.info((Object)("os.name: " + System.getProperty("os.name")));
        log.info((Object)("os.version: " + System.getProperty("os.version")));
        log.info((Object)("os.arch: " + System.getProperty("os.arch")));
        log.info((Object)("user.dir: " + System.getProperty("user.dir")));
        log.info((Object)("user.home: " + System.getProperty("user.home")));
        log.info((Object)("java.home: " + System.getProperty("java.home")));
        log.info((Object)("java.class.path: " + System.getProperty("java.class.path")));
    }
}

