/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.db;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.util.PropertyChangeReporter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class AliasGroup
implements Cloneable,
Serializable,
Comparable<AliasGroup> {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasGroup.class);
    private IIdentifier _id;
    private String _name = "";
    private transient PropertyChangeReporter _propChgReporter;

    public synchronized boolean isValid() {
        return this._name.length() > 0;
    }

    public boolean equals(Object rhs) {
        boolean rc = false;
        if (rhs != null && rhs.getClass().equals(this.getClass())) {
            rc = ((AliasGroup)rhs).getIdentifier().equals(this.getIdentifier());
        }
        return rc;
    }

    public Object clone() {
        try {
            AliasGroup obj = (AliasGroup)super.clone();
            obj._propChgReporter = null;
            return obj;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public synchronized int hashCode() {
        return this.getIdentifier().hashCode();
    }

    @Override
    public int compareTo(AliasGroup rhs) {
        return this._name.compareTo(rhs.getName());
    }

    public IIdentifier getIdentifier() {
        return this._id;
    }

    public void setIdentifier(IIdentifier id) {
        this._id = id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String value) throws ValidationException {
        String data = this.getString(value);
        if (data.length() == 0) {
            throw new ValidationException(s_stringMgr.getString("AliasGroup.error.blankname"));
        }
        if (!this._name.equals(data)) {
            String oldValue = this._name;
            this._name = data;
            this.getPropertyChangeReporter().firePropertyChange("name", (Object)oldValue, (Object)this._name);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().removePropertyChangeListener(listener);
    }

    private synchronized PropertyChangeReporter getPropertyChangeReporter() {
        if (this._propChgReporter == null) {
            this._propChgReporter = new PropertyChangeReporter((Object)this);
        }
        return this._propChgReporter;
    }

    private String getString(String data) {
        return data != null ? data.trim() : "";
    }

    public static interface IPropertyNames {
        public static final String ID = "identifier";
        public static final String NAME = "name";
    }
}

