/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.VersionPane;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.HashtableDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.PropertyPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class AboutBoxDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final ILogger s_log = LoggerController.createLogger(AboutBoxDialog.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AboutBoxDialog.class);
    private static AboutBoxDialog s_instance;
    private JTabbedPane _tabPnl;
    private SystemPanel _systemPnl;
    private final JButton _closeBtn = new JButton(s_stringMgr.getString("AboutBoxDialog.close"));

    private AboutBoxDialog(IApplication app) {
        super(app.getMainFrame(), s_stringMgr.getString("AboutBoxDialog.about"), true);
        this.setDefaultCloseOperation(1);
        this.createGUI(app);
    }

    public static synchronized void showAboutBox(IApplication app) throws IllegalArgumentException {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (s_instance == null) {
            s_instance = new AboutBoxDialog(app);
        }
        s_instance.setVisible(true);
    }

    private void createGUI(IApplication app) {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        contentPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        boolean isDebug = s_log.isDebugEnabled();
        long start = 0L;
        this._tabPnl = UIFactory.getInstance().createTabbedPane();
        if (isDebug) {
            start = System.currentTimeMillis();
        }
        this._tabPnl.add(s_stringMgr.getString("AboutBoxDialog.about"), new AboutPanel(app));
        if (isDebug) {
            s_log.debug((Object)(s_stringMgr.getString("AboutBoxDialog.aboutpanelcreatetime") + (System.currentTimeMillis() - start) + "ms"));
        }
        if (isDebug) {
            start = System.currentTimeMillis();
        }
        this._tabPnl.add(s_stringMgr.getString("AboutBoxDialog.credits"), new CreditsPanel(app));
        if (isDebug) {
            s_log.debug((Object)(s_stringMgr.getString("AboutBoxDialog.creditspanelcreatetime") + (System.currentTimeMillis() - start) + "ms"));
        }
        if (isDebug) {
            start = System.currentTimeMillis();
        }
        this._systemPnl = new SystemPanel();
        this._tabPnl.add(s_stringMgr.getString("AboutBoxDialog.system"), this._systemPnl);
        if (isDebug) {
            s_log.debug((Object)(s_stringMgr.getString("AboutBoxDialog.systempanelcreatetime") + (System.currentTimeMillis() - start) + "ms"));
        }
        this._tabPnl.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                String title = AboutBoxDialog.this._tabPnl.getTitleAt(AboutBoxDialog.this._tabPnl.getSelectedIndex());
                if (title.equals(s_stringMgr.getString("AboutBoxDialog.system"))) {
                    AboutBoxDialog.this._systemPnl._memoryPnl.startTimer();
                } else {
                    AboutBoxDialog.this._systemPnl._memoryPnl.stopTimer();
                }
            }
        });
        contentPane.add((Component)this._tabPnl, "Center");
        contentPane.add((Component)this.createButtonBar(), "South");
        this.getRootPane().setDefaultButton(this._closeBtn);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                String title = AboutBoxDialog.this._tabPnl.getTitleAt(AboutBoxDialog.this._tabPnl.getSelectedIndex());
                if (title.equals(s_stringMgr.getString("AboutBoxDialog.system"))) {
                    AboutBoxDialog.this._systemPnl._memoryPnl.startTimer();
                }
            }

            @Override
            public void windowDeactivated(WindowEvent evt) {
                String title = AboutBoxDialog.this._tabPnl.getTitleAt(AboutBoxDialog.this._tabPnl.getSelectedIndex());
                if (title.equals(s_stringMgr.getString("AboutBoxDialog.system"))) {
                    AboutBoxDialog.this._systemPnl._memoryPnl.stopTimer();
                }
            }
        });
        this.pack();
        GUIUtils.centerWithinParent((Window)this);
        this.setResizable(true);
    }

    private JPanel createButtonBar() {
        this._closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutBoxDialog.this.setVisible(false);
            }
        });
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        builder.addGridded((JComponent)this._closeBtn);
        return builder.getPanel();
    }

    private static class MemoryPanel
    extends PropertyPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private final JLabel _totalMemoryLbl = new JLabel();
        private final JLabel _usedMemoryLbl = new JLabel();
        private final JLabel _freeMemoryLbl = new JLabel();
        private Timer _timer;

        MemoryPanel() {
            this.add(new JLabel(s_stringMgr.getString("AboutBoxDialog.heapsize")), this._totalMemoryLbl);
            this.add(new JLabel(s_stringMgr.getString("AboutBoxDialog.usedheap")), this._usedMemoryLbl);
            this.add(new JLabel(s_stringMgr.getString("AboutBoxDialog.freeheap")), this._freeMemoryLbl);
            JButton gcBtn = new JButton(s_stringMgr.getString("AboutBoxDialog.gc"));
            gcBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Utilities.garbageCollect();
                }
            });
            this.add(gcBtn, new JLabel(""));
        }

        public void removeNotify() {
            super.removeNotify();
            this.stopTimer();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.updateMemoryStatus();
        }

        synchronized void startTimer() {
            if (this._timer == null) {
                s_log.debug((Object)s_stringMgr.getString("AboutBoxDialog.info.startmemtime"));
                this.updateMemoryStatus();
                this._timer = new Timer(2000, this);
                this._timer.start();
            }
        }

        synchronized void stopTimer() {
            if (this._timer != null) {
                s_log.debug((Object)s_stringMgr.getString("AboutBoxDialog.info.endmemtimer"));
                this._timer.stop();
                this._timer = null;
            }
        }

        private void updateMemoryStatus() {
            Runtime rt = Runtime.getRuntime();
            long totalMemory = rt.totalMemory();
            long freeMemory = rt.freeMemory();
            long usedMemory = totalMemory - freeMemory;
            this._totalMemoryLbl.setText(Utilities.formatSize((long)totalMemory, (int)1));
            this._usedMemoryLbl.setText(Utilities.formatSize((long)usedMemory, (int)1));
            this._freeMemoryLbl.setText(Utilities.formatSize((long)freeMemory, (int)1));
        }
    }

    private static final class SystemPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private MemoryPanel _memoryPnl;

        SystemPanel() {
            this.setLayout(new BorderLayout());
            DataSetViewerTablePanel propsPnl = new DataSetViewerTablePanel();
            propsPnl.init(null);
            try {
                propsPnl.show((IDataSet)new HashtableDataSet(System.getProperties()));
            }
            catch (DataSetException ex) {
                s_log.error((Object)s_stringMgr.getString("AboutBoxDialog.error.systemprops"), (Throwable)ex);
            }
            this._memoryPnl = new MemoryPanel();
            this.add((Component)new JScrollPane(propsPnl.getComponent()), "Center");
            this.add((Component)((Object)this._memoryPnl), "South");
        }
    }

    private static final class AboutPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        AboutPanel(IApplication app) {
            SquirrelResources rsrc = app.getResources();
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.setLayout(new BorderLayout());
            this.setBackground(new Color(11448517));
            ImageIcon icon = rsrc.getIcon("SplashScreen");
            this.add("Center", new JLabel(icon));
            VersionPane versionPane = new VersionPane(true);
            versionPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add("South", versionPane);
        }
    }

    private static final class CreditsPanel
    extends JScrollPane {
        private static final long serialVersionUID = 1L;

        CreditsPanel(IApplication app) {
            this.setBorder(BorderFactory.createEmptyBorder());
            JEditorPane credits = new JEditorPane();
            credits.setEditable(false);
            credits.setContentType("text/html");
            credits.setPreferredSize(new Dimension(200, 200));
            String creditsHtml = this.readCreditsHtml(app);
            StringBuffer pluginHtml = new StringBuffer();
            PluginInfo[] pi = app.getPluginManager().getPluginInformation();
            for (int i = 0; i < pi.length; ++i) {
                pluginHtml.append("<br><b>").append(pi[i].getDescriptiveName()).append(":</b>");
                String authors = pi[i].getAuthor();
                StringTokenizer strok = new StringTokenizer(authors, ",");
                while (strok.hasMoreTokens()) {
                    pluginHtml.append("<br>").append(strok.nextToken().trim());
                }
                String contribs = pi[i].getContributors();
                strok = new StringTokenizer(contribs, ",");
                while (strok.hasMoreTokens()) {
                    pluginHtml.append("<br>").append(strok.nextToken().trim());
                }
                pluginHtml.append("<br>");
            }
            creditsHtml = creditsHtml.replaceAll("@@replace", pluginHtml.toString());
            credits.setText(creditsHtml);
            this.setViewportView(credits);
            credits.setCaretPosition(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readCreditsHtml(IApplication app) {
            URL url = app.getResources().getCreditsURL();
            StringBuffer buf = new StringBuffer(2048);
            if (url != null) {
                try {
                    BufferedReader rdr = new BufferedReader(new InputStreamReader(url.openStream()));
                    try {
                        String line = null;
                        while ((line = rdr.readLine()) != null) {
                            String internationalizedLine = Utilities.replaceI18NSpanLine((String)line, (StringManager)s_stringMgr);
                            buf.append(internationalizedLine);
                        }
                    }
                    finally {
                        rdr.close();
                    }
                }
                catch (IOException ex) {
                    String errorMsg = s_stringMgr.getString("AboutBoxDialog.error.creditsfile");
                    s_log.error((Object)errorMsg, (Throwable)ex);
                    buf.append(errorMsg + ": " + ex.toString());
                }
            } else {
                String errorMsg = s_stringMgr.getString("AboutBoxDialog.error.creditsfileurl");
                s_log.error((Object)errorMsg);
                buf.append(errorMsg);
            }
            return buf.toString();
        }
    }
}

