/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JDialog;
import net.sourceforge.squirrel_sql.client.gui.IProgressCallBackFactory;
import net.sourceforge.squirrel_sql.client.gui.ProgressCallBackDialog;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBack;

public class ProgressCallBackFactory
implements IProgressCallBackFactory {
    @Override
    public ProgressCallBack create(Frame owner, String title, int totalItems) {
        ProgressCallBackCreationTask task = new ProgressCallBackCreationTask(owner, title, totalItems);
        GUIUtils.processOnSwingEventThread((Runnable)task, (boolean)true);
        return task.getResult();
    }

    @Override
    public ProgressCallBack create(JDialog owner, String title, int totalItems) {
        ProgressCallBackCreationTask task = new ProgressCallBackCreationTask(owner, title, totalItems);
        GUIUtils.processOnSwingEventThread((Runnable)task, (boolean)true);
        return task.getResult();
    }

    private class ProgressCallBackCreationTask
    implements Runnable {
        private ProgressCallBack result = null;
        private final String title;
        private final int totalItems;
        private Frame frameOwner;
        private JDialog dialogOwner;

        public ProgressCallBackCreationTask(Frame owner, String title, int totalItems) {
            this.frameOwner = owner;
            this.title = title;
            this.totalItems = totalItems;
        }

        public ProgressCallBackCreationTask(JDialog owner, String title, int totalItems) {
            this.dialogOwner = owner;
            this.title = title;
            this.totalItems = totalItems;
        }

        @Override
        public void run() {
            this.result = this.frameOwner != null ? new ProgressCallBackDialog(this.frameOwner, this.title, this.totalItems) : new ProgressCallBackDialog((Dialog)this.dialogOwner, this.title, this.totalItems);
        }

        public ProgressCallBack getResult() {
            return this.result;
        }
    }
}

