/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;
import net.sourceforge.squirrel_sql.client.gui.db.IDisposableDialog;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ColumnDetailDialog
extends JDialog
implements IDisposableDialog {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ColumnDetailDialog.class);
    private JLabel tableNameLabel = null;
    private JTextField tableNameTextField = null;
    private JLabel columnNameLabel = null;
    private JTextField columnNameTextField = null;
    private JLabel dialectLabel = null;
    private JComboBox dialectList = null;
    private JLabel typeLabel = null;
    private JComboBox typeList = null;
    private JLabel lengthLabel = null;
    private JSpinner lengthSpinner = null;
    private JLabel precisionLabel = null;
    private JSpinner precisionSpinner = null;
    private JLabel scaleLabel = null;
    private JSpinner scaleSpinner = null;
    private JLabel defaultLabel = null;
    private JTextField defaultTextField = null;
    private JLabel commentLabel = null;
    private JTextArea commentTextArea = null;
    private JLabel nullableLabel = null;
    private JCheckBox nullableCheckBox = null;
    private JButton executeButton = null;
    private JButton editSQLButton = null;
    private JButton showSQLButton = null;
    private JButton cancelButton = null;
    public static final int ADD_MODE = 0;
    public static final int MODIFY_MODE = 1;
    private int _mode = 0;

    public ColumnDetailDialog(int mode) {
        this.setMode(mode);
        this.init();
    }

    public void setMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Invalid mode - " + mode);
        }
        this._mode = mode;
    }

    public void setSelectedDialect(String dbName) {
        this.dialectList.setSelectedItem(dbName);
    }

    public String getSelectedDBName() {
        return (String)this.dialectList.getSelectedItem();
    }

    public void setTableName(String tableName) {
        this.tableNameTextField.setText(tableName);
    }

    public String getTableName() {
        return this.tableNameTextField.getText();
    }

    public void setExistingColumnInfo(TableColumnInfo info) {
        this.tableNameTextField.setText(info.getTableName());
        this.columnNameTextField.setText(info.getColumnName());
        String dataType = JDBCTypeMapper.getJdbcTypeName((int)info.getDataType());
        this.typeList.setSelectedItem(dataType);
        this.nullableCheckBox.setSelected(info.isNullable().equals("YES"));
        if (JDBCTypeMapper.isNumberType((int)info.getDataType())) {
            this.precisionSpinner.setValue(info.getColumnSize());
        } else {
            this.lengthSpinner.setValue(info.getColumnSize());
        }
        this.commentTextArea.setText(info.getRemarks());
        this.defaultTextField.setText(info.getDefaultValue());
    }

    public String getSelectedTypeName() {
        return (String)this.typeList.getSelectedItem();
    }

    public TableColumnInfo getColumnInfo() {
        String defaultValue;
        String tableName = this.tableNameTextField.getText();
        String columnName = this.columnNameTextField.getText();
        String typeName = (String)this.typeList.getSelectedItem();
        int dataType = JDBCTypeMapper.getJdbcType((String)typeName);
        SpinnerNumberModel sizeModel = null;
        sizeModel = JDBCTypeMapper.isNumberType((int)dataType) ? (SpinnerNumberModel)this.precisionSpinner.getModel() : (SpinnerNumberModel)this.lengthSpinner.getModel();
        int columnSize = sizeModel.getNumber().intValue();
        SpinnerNumberModel scaleModel = (SpinnerNumberModel)this.scaleSpinner.getModel();
        int decimalDigits = scaleModel.getNumber().intValue();
        int isNullAllowed = 1;
        String isNullable = null;
        if (this.nullableCheckBox.isSelected()) {
            isNullAllowed = 1;
            isNullable = "YES";
        } else {
            isNullAllowed = 0;
            isNullable = "NO";
        }
        String remarks = null;
        if (this.commentTextArea.isEditable()) {
            remarks = this.commentTextArea.getText();
        }
        if ("".equals(defaultValue = this.defaultTextField.getText())) {
            defaultValue = null;
        }
        String catalog = null;
        String schema = null;
        int octetLength = 1;
        int ordinalPosition = 1;
        int radix = 1;
        TableColumnInfo result = new TableColumnInfo(catalog, schema, tableName, columnName, dataType, typeName, columnSize, decimalDigits, radix, isNullAllowed, remarks, defaultValue, octetLength, ordinalPosition, isNullable);
        return result;
    }

    public void addExecuteListener(ActionListener listener) {
        this.executeButton.addActionListener(listener);
    }

    public void addEditSQLListener(ActionListener listener) {
        this.editSQLButton.addActionListener(listener);
    }

    public void addShowSQLListener(ActionListener listener) {
        this.showSQLButton.addActionListener(listener);
    }

    public void addDialectListListener(ItemListener listener) {
        this.dialectList.addItemListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.columnNameTextField.requestFocus();
        this.columnNameTextField.select(0, this.columnNameTextField.getText().length());
    }

    private GridBagConstraints getLabelConstraints(GridBagConstraints c) {
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 13;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        return c;
    }

    private GridBagConstraints getFieldConstraints(GridBagConstraints c) {
        ++c.gridx;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        return c;
    }

    private JLabel getBorderedLabel(String text, Border border) {
        JLabel result = new JLabel(text);
        result.setBorder(border);
        result.setPreferredSize(new Dimension(115, 20));
        result.setHorizontalAlignment(4);
        return result;
    }

    private JTextField getSizedTextField(Dimension mediumField) {
        JTextField result = new JTextField();
        result.setPreferredSize(mediumField);
        return result;
    }

    private void init() {
        super.setModal(true);
        if (this._mode == 0) {
            this.setTitle(i18n.ADD_COLUMN_TITLE);
        } else {
            this.setTitle(i18n.MODIFY_COLUMN_TITLE);
        }
        this.setSize(375, 400);
        EmptyBorder border = new EmptyBorder(new Insets(5, 5, 5, 5));
        Dimension mediumField = new Dimension(126, 20);
        Dimension largeField = new Dimension(126, 60);
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        pane.setBorder(new EmptyBorder(0, 0, 0, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = -1;
        this.tableNameLabel = this.getBorderedLabel(i18n.TABLE_NAME_LABEL, border);
        pane.add((Component)this.tableNameLabel, this.getLabelConstraints(c));
        this.tableNameTextField = new JTextField();
        this.tableNameTextField.setPreferredSize(mediumField);
        this.tableNameTextField.setEditable(false);
        pane.add((Component)this.tableNameTextField, this.getFieldConstraints(c));
        this.columnNameLabel = this.getBorderedLabel(i18n.COLUMN_NAME_LABEL, border);
        pane.add((Component)this.columnNameLabel, this.getLabelConstraints(c));
        this.columnNameTextField = this.getSizedTextField(mediumField);
        this.columnNameTextField.setText(i18n.NEW_COLUMN_VALUE);
        this.columnNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (ColumnDetailDialog.this.columnNameTextField.getText().length() == 0) {
                    ColumnDetailDialog.this.executeButton.setEnabled(false);
                    ColumnDetailDialog.this.showSQLButton.setEnabled(false);
                } else {
                    ColumnDetailDialog.this.executeButton.setEnabled(true);
                    ColumnDetailDialog.this.showSQLButton.setEnabled(true);
                }
            }
        });
        pane.add((Component)this.columnNameTextField, this.getFieldConstraints(c));
        this.dialectLabel = this.getBorderedLabel(i18n.DIALECT_LABEL, border);
        pane.add((Component)this.dialectLabel, this.getLabelConstraints(c));
        Object[] dbNames = DialectFactory.getDbNames();
        this.dialectList = new JComboBox<Object>(dbNames);
        this.dialectList.setPreferredSize(mediumField);
        this.dialectList.addItemListener(new DialectTypeListListener());
        pane.add((Component)this.dialectList, this.getFieldConstraints(c));
        this.typeLabel = this.getBorderedLabel(i18n.TYPE_LABEL, border);
        pane.add((Component)this.typeLabel, this.getLabelConstraints(c));
        String[] jdbcTypes = JDBCTypeMapper.getJdbcTypeList();
        this.typeList = new JComboBox<String>(jdbcTypes);
        this.typeList.addItemListener(new ColumnTypeListListener());
        this.typeList.setPreferredSize(mediumField);
        pane.add((Component)this.typeList, this.getFieldConstraints(c));
        this.lengthLabel = this.getBorderedLabel(i18n.LENGTH_LABEL, border);
        pane.add((Component)this.lengthLabel, this.getLabelConstraints(c));
        this.lengthSpinner = new JSpinner();
        this.lengthSpinner.setPreferredSize(mediumField);
        int value = 10;
        int min = 1;
        int max = Integer.MAX_VALUE;
        int step = 1;
        SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
        this.lengthSpinner.setModel(model);
        this.lengthSpinner.setPreferredSize(mediumField);
        pane.add((Component)this.lengthSpinner, this.getFieldConstraints(c));
        this.precisionLabel = new JLabel(i18n.PRECISION_LABEL);
        this.precisionLabel.setBorder(border);
        pane.add((Component)this.precisionLabel, this.getLabelConstraints(c));
        this.precisionSpinner = new JSpinner();
        this.precisionSpinner.setPreferredSize(mediumField);
        value = 8;
        min = 0;
        max = Integer.MAX_VALUE;
        step = 1;
        SpinnerNumberModel precisionModel = new SpinnerNumberModel(value, min, max, step);
        this.precisionSpinner.setModel(precisionModel);
        this.precisionSpinner.setPreferredSize(mediumField);
        pane.add((Component)this.precisionSpinner, this.getFieldConstraints(c));
        this.scaleLabel = new JLabel(i18n.SCALE_LABEL);
        this.scaleLabel.setBorder(border);
        pane.add((Component)this.scaleLabel, this.getLabelConstraints(c));
        this.scaleSpinner = new JSpinner();
        this.scaleSpinner.setPreferredSize(mediumField);
        value = 8;
        min = 0;
        max = Integer.MAX_VALUE;
        step = 1;
        SpinnerNumberModel scaleModel = new SpinnerNumberModel(value, min, max, step);
        this.scaleSpinner.setModel(scaleModel);
        this.scaleSpinner.setPreferredSize(mediumField);
        pane.add((Component)this.scaleSpinner, this.getFieldConstraints(c));
        this.defaultLabel = new JLabel(i18n.DEFAULT_VALUE_LABEL);
        this.defaultLabel.setBorder(border);
        pane.add((Component)this.defaultLabel, this.getLabelConstraints(c));
        this.defaultTextField = new JTextField();
        this.defaultTextField.setPreferredSize(mediumField);
        pane.add((Component)this.defaultTextField, this.getFieldConstraints(c));
        this.nullableLabel = new JLabel(i18n.NULLABLE_LABEL);
        this.nullableLabel.setBorder(border);
        pane.add((Component)this.nullableLabel, this.getLabelConstraints(c));
        this.nullableCheckBox = new JCheckBox("");
        this.nullableCheckBox.setSelected(true);
        pane.add((Component)this.nullableCheckBox, this.getFieldConstraints(c));
        this.commentLabel = new JLabel(i18n.COMMENT_LABEL);
        this.commentLabel.setBorder(border);
        pane.add((Component)this.commentLabel, this.getLabelConstraints(c));
        this.commentTextArea = new JTextArea();
        this.commentTextArea.setBorder(new LineBorder(Color.DARK_GRAY, 1));
        this.commentTextArea.setLineWrap(true);
        c = this.getFieldConstraints(c);
        c.weightx = 2.0;
        c.weighty = 2.0;
        c.fill = 1;
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.commentTextArea);
        scrollPane.setPreferredSize(largeField);
        pane.add((Component)scrollPane, c);
        Container contentPane = super.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)pane, "Center");
        contentPane.add((Component)this.getButtonPanel(), "South");
    }

    private JPanel getButtonPanel() {
        JPanel result = new JPanel();
        this.executeButton = new JButton(i18n.EXECUTE_BUTTON_LABEL);
        this.editSQLButton = new JButton(i18n.EDIT_BUTTON_LABEL);
        this.showSQLButton = new JButton(i18n.SHOW_BUTTON_LABEL);
        this.cancelButton = new JButton(i18n.CANCEL_BUTTON_LABEL);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnDetailDialog.this.setVisible(false);
            }
        });
        result.add(this.executeButton);
        result.add(this.editSQLButton);
        result.add(this.showSQLButton);
        result.add(this.cancelButton);
        return result;
    }

    public static void main(String[] args) {
        ApplicationArguments.initialize(new String[0]);
        final ColumnDetailDialog c = new ColumnDetailDialog(0);
        c.setTableName("FooTable");
        c.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                System.out.println("Current size = " + c.getSize());
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        c.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(1);
            }
        });
        c.setVisible(true);
    }

    private class DialectTypeListListener
    implements ItemListener {
        private DialectTypeListListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            String noColumnSupportMsg;
            String dbName = (String)ColumnDetailDialog.this.dialectList.getSelectedItem();
            HibernateDialect dialect = DialectFactory.getDialect((String)dbName);
            if (!dialect.supportsColumnComment()) {
                ColumnDetailDialog.this.commentTextArea.setEditable(false);
                noColumnSupportMsg = s_stringMgr.getString("ColumnDetailsDialog.columnCommentToolTip", new Object[]{dbName});
                ColumnDetailDialog.this.commentTextArea.setToolTipText(noColumnSupportMsg);
            } else {
                ColumnDetailDialog.this.commentTextArea.setEditable(true);
                ColumnDetailDialog.this.commentTextArea.setToolTipText(null);
            }
            if (ColumnDetailDialog.this._mode == 1) {
                if (!dialect.supportsAlterColumnNull()) {
                    ColumnDetailDialog.this.nullableCheckBox.setEnabled(false);
                    noColumnSupportMsg = s_stringMgr.getString("ColumnDetailsDialog.columnNullToolTip", new Object[]{dbName});
                    ColumnDetailDialog.this.nullableCheckBox.setToolTipText(noColumnSupportMsg);
                } else {
                    ColumnDetailDialog.this.nullableCheckBox.setEnabled(true);
                    ColumnDetailDialog.this.nullableCheckBox.setToolTipText(null);
                }
                if (!dialect.supportsRenameColumn()) {
                    String noColNameChange = s_stringMgr.getString("ColumnDetailsDialog.columnNameTootTip", new Object[]{dbName});
                    ColumnDetailDialog.this.columnNameTextField.setEditable(false);
                    ColumnDetailDialog.this.columnNameTextField.setToolTipText(noColNameChange);
                } else {
                    ColumnDetailDialog.this.columnNameTextField.setEditable(true);
                    ColumnDetailDialog.this.columnNameTextField.setToolTipText(null);
                }
                if (!dialect.supportsAlterColumnType()) {
                    String noColTypeChange = s_stringMgr.getString("ColumnDetailsDialog.columnTypeTootTip", new Object[]{dbName});
                    ColumnDetailDialog.this.typeList.setEnabled(false);
                    ColumnDetailDialog.this.typeList.setToolTipText(noColTypeChange);
                    ColumnDetailDialog.this.precisionSpinner.setEnabled(false);
                    ColumnDetailDialog.this.precisionSpinner.setToolTipText(noColTypeChange);
                    ColumnDetailDialog.this.lengthSpinner.setEnabled(false);
                    ColumnDetailDialog.this.lengthSpinner.setToolTipText(noColTypeChange);
                    ColumnDetailDialog.this.scaleSpinner.setEnabled(false);
                    ColumnDetailDialog.this.scaleSpinner.setToolTipText(noColTypeChange);
                } else {
                    ColumnDetailDialog.this.typeList.setEnabled(true);
                    ColumnDetailDialog.this.typeList.setToolTipText(null);
                    ColumnDetailDialog.this.precisionSpinner.setToolTipText(null);
                    ColumnDetailDialog.this.lengthSpinner.setToolTipText(null);
                    ColumnDetailDialog.this.scaleSpinner.setToolTipText(null);
                }
            }
        }
    }

    private class ColumnTypeListListener
    implements ItemListener {
        private ColumnTypeListListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (ColumnDetailDialog.this.precisionSpinner == null) {
                return;
            }
            String columnType = (String)ColumnDetailDialog.this.typeList.getSelectedItem();
            int jdbcType = JDBCTypeMapper.getJdbcType((String)columnType);
            if (JDBCTypeMapper.isNumberType((int)jdbcType)) {
                ColumnDetailDialog.this.precisionSpinner.setEnabled(true);
                ColumnDetailDialog.this.scaleSpinner.setEnabled(true);
                ColumnDetailDialog.this.lengthSpinner.setEnabled(false);
            } else if (JDBCTypeMapper.isDateType((int)jdbcType)) {
                ColumnDetailDialog.this.precisionSpinner.setEnabled(false);
                ColumnDetailDialog.this.scaleSpinner.setEnabled(false);
                ColumnDetailDialog.this.lengthSpinner.setEnabled(false);
            } else {
                ColumnDetailDialog.this.precisionSpinner.setEnabled(false);
                ColumnDetailDialog.this.scaleSpinner.setEnabled(false);
                ColumnDetailDialog.this.lengthSpinner.setEnabled(true);
            }
        }
    }

    private static interface i18n {
        public static final String EDIT_BUTTON_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.editButtonLabel");
        public static final String EXECUTE_BUTTON_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.executeButtonLabel");
        public static final String ADD_COLUMN_TITLE = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.addColumnTitle");
        public static final String MODIFY_COLUMN_TITLE = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.modifyColumnTitle");
        public static final String CANCEL_BUTTON_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.cancelButtonLabel");
        public static final String COLUMN_NAME_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.columnNameLabel");
        public static final String COMMENT_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.commentLabel");
        public static final String DEFAULT_VALUE_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.defaultValueLabel");
        public static final String DIALECT_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.dialectLabel");
        public static final String LENGTH_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.lengthLabel");
        public static final String NULLABLE_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.nullableLabel");
        public static final String NEW_COLUMN_VALUE = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.newColumnValue");
        public static final String PRECISION_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.precisionLabel");
        public static final String SCALE_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.scaleLabel");
        public static final String SHOW_BUTTON_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.showButtonLabel");
        public static final String TABLE_NAME_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.tableNameLabel");
        public static final String TYPE_LABEL = ColumnDetailDialog.access$000().getString("ColumnDetailsDialog.typeLabel");
    }
}

