/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Frame;
import java.sql.SQLException;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.ICompletionCallback;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.ErrorDialog;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.WrappedSQLException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ConnectToAliasCallBack
implements ICompletionCallback {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConnectToAliasCallBack.class);
    private static final ILogger s_log = LoggerController.createLogger(ConnectToAliasCallBack.class);
    private final IApplication _app;
    private final SQLAlias _sqlAlias;

    public ConnectToAliasCallBack(IApplication app, SQLAlias alias) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        if (alias == null) {
            throw new IllegalArgumentException("ISQLAlias == null");
        }
        this._app = app;
        this._sqlAlias = alias;
    }

    @Override
    public void connected(ISQLConnection conn) {
    }

    @Override
    public void sessionCreated(ISession session) {
    }

    @Override
    public void errorOccured(Throwable th) {
        if (th instanceof WrappedSQLException) {
            th = ((WrappedSQLException)th).getSQLExeption();
        }
        if (th instanceof SQLException) {
            String msg = th.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = s_stringMgr.getString("ConnectToAliasCommand.error.cantopen");
            }
            msg = this._sqlAlias.getName() + ": " + msg;
            this.showErrorDialog(msg, th);
        } else if (th instanceof ClassNotFoundException) {
            String msg = s_stringMgr.getString("ConnectToAliasCommand.error.driver", new Object[]{this._sqlAlias.getName()});
            this.showErrorDialog(msg, th);
        } else if (th instanceof NoClassDefFoundError) {
            String msg = s_stringMgr.getString("ConnectToAliasCommand.error.driver", new Object[]{this._sqlAlias.getName()});
            s_log.error((Object)msg, th);
            this.showErrorDialog(msg, th);
        } else {
            String msg = s_stringMgr.getString("ConnectToAliasCommand.error.unexpected", new Object[]{this._sqlAlias.getName()});
            s_log.debug((Object)th.getClass().getName());
            s_log.error((Object)msg, th);
            this.showErrorDialog(msg, th);
        }
    }

    protected IApplication getApplication() {
        return this._app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showErrorDialog(final String msg, final Throwable th) {
        ConnectToAliasCallBack connectToAliasCallBack = this;
        synchronized (connectToAliasCallBack) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new ErrorDialog((Frame)ConnectToAliasCallBack.this._app.getMainFrame(), msg, th).setVisible(true);
                }
            });
        }
    }

    public SQLAlias getAlias() {
        return this._sqlAlias;
    }
}

