/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.IOkClosePanelListener;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanel;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanelEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasPropertiesCommand;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.StatusBar;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ConnectionInternalFrame
extends DialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConnectionInternalFrame.class);
    private static final ILogger s_log = LoggerController.createLogger(ConnectionInternalFrame.class);
    private IApplication _app;
    private ISQLAlias _alias;
    private ISQLDriver _sqlDriver;
    private boolean _connecting;
    private IHandler _handler;
    private JLabel _aliasName = new JLabel();
    private JLabel _driverName = new JLabel();
    private JLabel _url = new JLabel();
    private JTextField _user = new JTextField();
    private JTextField _password = new JPasswordField();
    private OkClosePanel _btnsPnl = new OkClosePanel(s_stringMgr.getString("ConnectionInternalFrame.connect"));
    private boolean _driverPropertiesLoaded = false;
    private final JButton _driverPropsBtn = new JButton(s_stringMgr.getString("ConnectionInternalFrame.props"));
    private StatusBar _statusBar = new StatusBar();

    public ConnectionInternalFrame(IApplication app, ISQLAlias alias, IHandler handler) {
        super("", true, app);
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (alias == null) {
            throw new IllegalArgumentException("Null ISQLAlias passed");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Null IConnectionInternalFrameHandler passed");
        }
        this._app = app;
        this._alias = alias;
        this._handler = handler;
        this._sqlDriver = this._app.getDataCache().getDriver(this._alias.getDriverIdentifier());
        if (this._sqlDriver == null) {
            throw new IllegalStateException(s_stringMgr.getString("ConnectionInternalFrame.error.nodriver", new Object[]{this._alias.getName()}));
        }
        this.createGUI();
        this.loadData();
        this.pack();
    }

    public void executed(final boolean connected) {
        this._connecting = false;
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (connected) {
                    ConnectionInternalFrame.this.dispose();
                } else {
                    ConnectionInternalFrame.this.setStatusText(null);
                    ConnectionInternalFrame.this._user.setEnabled(true);
                    ConnectionInternalFrame.this._password.setEnabled(true);
                    ConnectionInternalFrame.this._btnsPnl.setExecuting(false);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this._alias.isAutoLogon()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConnectionInternalFrame.this.connect();
                }
            });
        }
    }

    public void setStatusText(String text) {
        this._statusBar.setText(text);
    }

    private void initKeyListeners() {
        ActionListener escapeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionInternalFrame.this.dispose();
            }
        };
        ActionListener enterListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionInternalFrame.this.connect();
            }
        };
        JRootPane pane = this.getRootPane();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        pane.registerKeyboardAction(escapeListener, ks, 2);
        ks = KeyStroke.getKeyStroke(10, 0);
        pane.registerKeyboardAction(enterListener, ks, 2);
    }

    private void loadData() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._loadData();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConnectionInternalFrame.this._loadData();
                }
            });
        }
    }

    private void _loadData() {
        String userName = this._alias.getUserName();
        String password = this._alias.getPassword();
        this._aliasName.setText(this._alias.getName());
        this._driverName.setText(this._sqlDriver.getName());
        this._url.setText(this._alias.getUrl());
        this._user.setText(userName);
        this._password.setText(password);
        this._aliasName.setToolTipText(this._aliasName.getText());
        this._driverName.setToolTipText(this._driverName.getText());
        this._url.setToolTipText(this._url.getText());
    }

    private void connect() {
        if (!this._connecting) {
            this._connecting = true;
            this._btnsPnl.setExecuting(true);
            this.setStatusText(s_stringMgr.getString("ConnectionInternalFrame.connecting"));
            this._user.setEnabled(false);
            this._password.setEnabled(false);
            SQLDriverPropertyCollection driverProperties = this._alias.getDriverPropertiesClone();
            if (!this._alias.getUseDriverProperties()) {
                driverProperties.clear();
            }
            this._handler.performOK(this, this._user.getText(), this._password.getText(), driverProperties);
        }
    }

    private void cancelConnect() {
        if (this._connecting) {
            this.setStatusText(s_stringMgr.getString("ConnectionInternalFrame.cancelling"));
            this._btnsPnl.enableCloseButton(false);
            this._handler.performCancelConnect(this);
            this._connecting = false;
            this.dispose();
        }
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        String winTitle = s_stringMgr.getString("ConnectionInternalFrame.title", new Object[]{this._alias.getName()});
        this.setTitle(winTitle);
        JPanel content = new JPanel(new BorderLayout());
        content.add(this.createMainPanel(), "Center");
        content.add((Component)this._statusBar, "South");
        this.setContentPane(content);
        this.initKeyListeners();
    }

    private Component createMainPanel() {
        this._user.setColumns(20);
        this._password.setColumns(20);
        this._driverPropsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionInternalFrame.this.showDriverPropertiesDialog();
            }
        });
        this._btnsPnl.addListener(new MyOkClosePanelListener());
        FormLayout layout = new FormLayout("right:pref, 8dlu, left:min(100dlu;pref):grow", "pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.setDefaultDialogBorder();
        int y = 1;
        builder.addSeparator(this.getTitle(), cc.xywh(1, y, 3, 1));
        builder.addLabel(s_stringMgr.getString("ConnectionInternalFrame.alias"), cc.xy(1, y += 2));
        builder.add((Component)this._aliasName, cc.xywh(3, y, 1, 1));
        builder.addLabel(s_stringMgr.getString("ConnectionInternalFrame.driver"), cc.xy(1, y += 2));
        builder.add((Component)this._driverName, cc.xywh(3, y, 1, 1));
        builder.addLabel(s_stringMgr.getString("ConnectionInternalFrame.url"), cc.xy(1, y += 2));
        builder.add((Component)this._url, cc.xywh(3, y, 1, 1));
        builder.addLabel(s_stringMgr.getString("ConnectionInternalFrame.user"), cc.xy(1, y += 2));
        builder.add((Component)this._user, cc.xywh(3, y, 1, 1));
        builder.addLabel(s_stringMgr.getString("ConnectionInternalFrame.password"), cc.xy(1, y += 2));
        builder.add((Component)this._password, cc.xywh(3, y, 1, 1));
        this._driverPropsBtn.setIcon(this._app.getResources().getIcon("aliasProperties"));
        builder.add((Component)this._driverPropsBtn, cc.xywh(3, y += 2, 1, 1));
        builder.addLabel(s_stringMgr.getString("ConnectionInternalFrame.warningcapslock"), cc.xywh(1, y += 2, 3, 1));
        builder.addSeparator("", cc.xywh(1, y += 2, 3, 1));
        builder.add((Component)this._btnsPnl, cc.xywh(1, y += 2, 3, 1));
        this.addWidgetListener(new WidgetAdapter(){
            private WidgetAdapter _this;

            @Override
            public void widgetActivated(WidgetEvent evt) {
                this._this = this;
                String userName = ConnectionInternalFrame.this._user.getText();
                if (userName != null && userName.length() > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String pw = ConnectionInternalFrame.this._password.getText();
                            if (pw != null && pw.length() > 0) {
                                ConnectionInternalFrame.this._btnsPnl.getOKButton().requestFocus();
                            } else {
                                ConnectionInternalFrame.this._password.requestFocus();
                            }
                            ConnectionInternalFrame.this.removeWidgetListener(_this);
                        }
                    });
                }
            }
        });
        return builder.getPanel();
    }

    private void showDriverPropertiesDialog() {
        new AliasPropertiesCommand(this._alias, this._app).execute();
    }

    private final class MyOkClosePanelListener
    implements IOkClosePanelListener {
        private MyOkClosePanelListener() {
        }

        @Override
        public void okPressed(OkClosePanelEvent evt) {
            ConnectionInternalFrame.this.connect();
        }

        @Override
        public void closePressed(OkClosePanelEvent evt) {
            ConnectionInternalFrame.this.dispose();
        }

        @Override
        public void cancelPressed(OkClosePanelEvent evt) {
            ConnectionInternalFrame.this.cancelConnect();
        }
    }

    public static interface IHandler {
        public void performOK(ConnectionInternalFrame var1, String var2, String var3, SQLDriverPropertyCollection var4);

        public void performClose(ConnectionInternalFrame var1);

        public void performCancelConnect(ConnectionInternalFrame var1);
    }
}

