/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfoCacheSerializer;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.NullMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;

public class DataCache {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataCache.class);
    private static final Class<SQLAlias> SQL_ALIAS_IMPL = SQLAlias.class;
    private static final Class<SQLDriver> SQL_DRIVER_IMPL = SQLDriver.class;
    private static final ILogger s_log = LoggerController.createLogger(DataCache.class);
    private final SQLDriverManager _driverMgr;
    private final XMLObjectCache _cache = new XMLObjectCache();
    private IApplication _app;

    public DataCache(SQLDriverManager driverMgr, File driversFile, File aliasesFile, URL dftDriversURL, IApplication app) {
        if (driverMgr == null) {
            throw new IllegalArgumentException("SQLDriverManager == null");
        }
        if (driversFile == null) {
            throw new IllegalArgumentException("driversFile == null");
        }
        if (aliasesFile == null) {
            throw new IllegalArgumentException("aliasesFile == null");
        }
        if (dftDriversURL == null) {
            throw new IllegalArgumentException("dftDriversURL == null");
        }
        this._driverMgr = driverMgr;
        this._app = app;
        this.loadDrivers(driversFile, dftDriversURL, (IMessageHandler)NullMessageHandler.getInstance());
        this.loadAliases(aliasesFile, (IMessageHandler)NullMessageHandler.getInstance());
    }

    public void saveDrivers(File file) throws IOException, XMLException {
        if (file == null) {
            throw new IllegalArgumentException("File == null");
        }
        this.saveSecure(file, SQL_DRIVER_IMPL);
    }

    public void saveAliases(File file) throws IOException, XMLException {
        if (file == null) {
            throw new IllegalArgumentException("File == null");
        }
        this.saveSecure(file, SQL_ALIAS_IMPL);
    }

    private void saveSecure(File file, Class<? extends IHasIdentifier> forClass) throws IOException, XMLException {
        File tempFile = new File(file.getPath() + "~");
        try {
            tempFile.delete();
        }
        catch (Exception e) {
            // empty catch block
        }
        this._cache.saveAllForClass(tempFile.getPath(), forClass);
        if (!tempFile.renameTo(file)) {
            File doubleTemp = new File(file.getPath() + "~~");
            try {
                doubleTemp.delete();
            }
            catch (Exception e) {
                // empty catch block
            }
            File buf = new File(file.getPath());
            if (!buf.renameTo(doubleTemp)) {
                throw new IllegalStateException("Cannot rename file " + buf.getPath() + " to " + doubleTemp.getPath() + ". New File will not be saved.");
            }
            try {
                tempFile.renameTo(file);
                doubleTemp.delete();
            }
            catch (Exception e) {
                doubleTemp.renameTo(file);
            }
        }
    }

    public ISQLDriver getDriver(IIdentifier id) {
        if (id == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        return (ISQLDriver)this._cache.get(SQL_DRIVER_IMPL, id);
    }

    public void addDriver(ISQLDriver sqlDriver, IMessageHandler messageHandler) throws ClassNotFoundException, IllegalAccessException, InstantiationException, DuplicateObjectException, MalformedURLException {
        if (sqlDriver == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        if (messageHandler != null) {
            this.registerDriver(sqlDriver, messageHandler, true);
        }
        this._cache.add((IHasIdentifier)sqlDriver);
    }

    public void removeDriver(ISQLDriver sqlDriver) {
        this._cache.remove(SQL_DRIVER_IMPL, sqlDriver.getIdentifier());
        this._driverMgr.unregisterSQLDriver(sqlDriver);
    }

    public Iterator<ISQLDriver> drivers() {
        return this._cache.getAllForClass(SQL_DRIVER_IMPL);
    }

    public void addDriversListener(IObjectCacheChangeListener lis) {
        this._cache.addChangesListener(lis, SQL_DRIVER_IMPL);
    }

    public void removeDriversListener(IObjectCacheChangeListener lis) {
        this._cache.removeChangesListener(lis, SQL_DRIVER_IMPL);
    }

    public ISQLAlias getAlias(IIdentifier id) {
        return (ISQLAlias)this._cache.get(SQL_ALIAS_IMPL, id);
    }

    public Iterator<ISQLAlias> aliases() {
        return this._cache.getAllForClass(SQL_ALIAS_IMPL);
    }

    public void addAlias(ISQLAlias alias) throws DuplicateObjectException {
        this._cache.add((IHasIdentifier)alias);
    }

    public void removeAlias(SQLAlias alias) {
        SchemaInfoCacheSerializer.aliasRemoved(alias);
        this._app.getPluginManager().aliasRemoved(alias);
        this._cache.remove(SQL_ALIAS_IMPL, alias.getIdentifier());
    }

    public Iterator<ISQLAlias> getAliasesForDriver(ISQLDriver driver) {
        ArrayList<ISQLAlias> data = new ArrayList<ISQLAlias>();
        Iterator<ISQLAlias> it = this.aliases();
        while (it.hasNext()) {
            ISQLAlias alias = it.next();
            if (!driver.equals(this.getDriver(alias.getDriverIdentifier()))) continue;
            data.add(alias);
        }
        return data.iterator();
    }

    public void addAliasesListener(IObjectCacheChangeListener lis) {
        this._cache.addChangesListener(lis, SQL_ALIAS_IMPL);
    }

    public void removeAliasesListener(IObjectCacheChangeListener lis) {
        this._cache.removeChangesListener(lis, SQL_ALIAS_IMPL);
    }

    private void loadDrivers(File driversFile, URL dftDriversURL, IMessageHandler msgHandler) {
        block11: {
            if (driversFile == null) {
                throw new IllegalArgumentException("driversFile == null");
            }
            if (dftDriversURL == null) {
                throw new IllegalArgumentException("dftDriversURL == null");
            }
            if (msgHandler == null) {
                throw new IllegalArgumentException("msgHandler == null");
            }
            try {
                try {
                    this._cache.load(driversFile.getPath());
                    if (!this.drivers().hasNext()) {
                        this.loadDefaultDrivers(dftDriversURL);
                        break block11;
                    }
                    this.fixupDrivers();
                    this.mergeDefaultWebsites(dftDriversURL);
                }
                catch (FileNotFoundException ex) {
                    this.loadDefaultDrivers(dftDriversURL);
                }
                catch (Exception ex) {
                    String msg = s_stringMgr.getString("DataCache.error.loadingdrivers", new Object[]{driversFile.getPath()});
                    s_log.error((Object)msg, (Throwable)ex);
                    msgHandler.showErrorMessage(msg);
                    msgHandler.showErrorMessage((Throwable)ex, null);
                    this.loadDefaultDrivers(dftDriversURL);
                }
            }
            catch (XMLException ex) {
                s_log.error((Object)"Error loading drivers", (Throwable)ex);
            }
            catch (IOException ex) {
                s_log.error((Object)"Error loading drivers", (Throwable)ex);
            }
        }
        Iterator<ISQLDriver> it = this.drivers();
        while (it.hasNext()) {
            this.registerDriver(it.next(), msgHandler, false);
        }
    }

    public SQLAlias createAlias(IIdentifier id) {
        return new SQLAlias(id);
    }

    public ISQLDriver createDriver(IIdentifier id) {
        return new SQLDriver(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISQLDriver[] findMissingDefaultDrivers(URL url) throws IOException, XMLException {
        ISQLDriver[] result = null;
        InputStreamReader isr = new InputStreamReader(url.openStream());
        ArrayList<ISQLDriver> missingDrivers = new ArrayList<ISQLDriver>();
        try {
            XMLObjectCache tmp = new XMLObjectCache();
            tmp.load((Reader)isr, null, true);
            Iterator iter = tmp.getAllForClass(SQL_DRIVER_IMPL);
            while (iter.hasNext()) {
                ISQLDriver defaultDriver = (ISQLDriver)iter.next();
                if (this.containsDriver(defaultDriver)) continue;
                missingDrivers.add(defaultDriver);
            }
        }
        catch (DuplicateObjectException ex) {
            s_log.error((Object)"Received an unexpected DuplicateObjectException", (Throwable)ex);
        }
        finally {
            isr.close();
        }
        if (missingDrivers.size() > 0) {
            result = missingDrivers.toArray(new ISQLDriver[missingDrivers.size()]);
        }
        return result;
    }

    public boolean containsDriver(ISQLDriver driver) {
        boolean result = false;
        Iterator iter = this._cache.getAllForClass(SQL_DRIVER_IMPL);
        while (iter.hasNext()) {
            ISQLDriver cachedDriver = (ISQLDriver)iter.next();
            if (!cachedDriver.equals(driver)) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDefaultDrivers(URL url) throws IOException, XMLException {
        InputStreamReader isr = new InputStreamReader(url.openStream());
        try {
            this._cache.load((Reader)isr, null, true);
        }
        catch (DuplicateObjectException ex) {
            s_log.error((Object)"Received an unexpected DuplicateObjectException", (Throwable)ex);
        }
        finally {
            isr.close();
        }
    }

    private void registerDriver(ISQLDriver sqlDriver, IMessageHandler msgHandler, boolean extendedMessaging) {
        String msg;
        boolean registrationSucessfully = false;
        try {
            this._driverMgr.registerSQLDriver(sqlDriver);
            registrationSucessfully = true;
        }
        catch (ClassNotFoundException cnfe) {
            if (extendedMessaging) {
                Object[] params = new Object[]{sqlDriver.getDriverClassName(), sqlDriver.getName(), cnfe};
                String msg2 = s_stringMgr.getString("DataCache.error.driverClassNotFound", params);
                s_log.error((Object)msg2, (Throwable)cnfe);
                msgHandler.showErrorMessage(msg2);
            }
        }
        catch (Throwable th) {
            msg = s_stringMgr.getString("DataCache.error.registerdriver", new Object[]{sqlDriver.getName()});
            s_log.error((Object)msg, th);
            msgHandler.showErrorMessage(msg);
            msgHandler.showErrorMessage(th, null);
        }
        if (extendedMessaging && registrationSucessfully) {
            Object[] params = new Object[]{sqlDriver.getDriverClassName(), sqlDriver.getName()};
            msg = s_stringMgr.getString("DataCache.msg.driverRegisteredSucessfully", params);
            msgHandler.showMessage(msg);
        }
    }

    private void loadAliases(File aliasesFile, IMessageHandler msgHandler) {
        try {
            this._cache.load(aliasesFile.getPath());
        }
        catch (FileNotFoundException ignore) {
        }
        catch (Exception ex) {
            String msg = s_stringMgr.getString("DataCache.error.loadingaliases", new Object[]{aliasesFile.getPath()});
            s_log.error((Object)msg, (Throwable)ex);
            msgHandler.showErrorMessage(msg);
            msgHandler.showErrorMessage((Throwable)ex, null);
        }
    }

    private void fixupDrivers() {
        Iterator<ISQLDriver> it = this.drivers();
        while (it.hasNext()) {
            String fileName;
            ISQLDriver driver = it.next();
            String[] fileNames = driver.getJarFileNames();
            if (fileNames != null && fileNames.length != 0 || (fileName = driver.getJarFileName()) == null || fileName.length() <= 0) continue;
            driver.setJarFileNames(new String[]{fileName});
            try {
                driver.setJarFileName(null);
            }
            catch (ValidationException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeDefaultWebsites(URL defaultDriversUrl) {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(defaultDriversUrl.openStream());
            XMLObjectCache tmp = new XMLObjectCache();
            tmp.load((Reader)isr, null, true);
            Iterator iter = tmp.getAllForClass(SQL_DRIVER_IMPL);
            while (iter.hasNext()) {
                ISQLDriver defaultDriver = (ISQLDriver)iter.next();
                ISQLDriver cachedDriver = this.getDriver(defaultDriver.getIdentifier());
                if (cachedDriver == null || cachedDriver.getWebSiteUrl() != null && !"".equals(cachedDriver.getWebSiteUrl()) || defaultDriver.getWebSiteUrl() == null) continue;
                cachedDriver.setWebSiteUrl(defaultDriver.getWebSiteUrl());
            }
        }
        catch (Exception ex) {
            s_log.error((Object)"Received an unexpected Exception", (Throwable)ex);
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void refreshDriver(ISQLDriver driver, IMessageHandler messageHandler) {
        this.registerDriver(driver, messageHandler, true);
    }
}

