/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import javax.swing.JInternalFrame;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.WindowManager;
import net.sourceforge.squirrel_sql.client.gui.db.DriverWindowFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DriverWindowManager {
    private static final ILogger s_log = LoggerController.createLogger(WindowManager.class);
    private final IApplication _app;
    private final DriverWindowFactory _driverWinFactory;

    public DriverWindowManager(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
        this._driverWinFactory = new DriverWindowFactory(this._app);
    }

    public void showModifyDriverInternalFrame(ISQLDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        this._driverWinFactory.getModifySheet(driver).moveToFront();
    }

    public void showNewDriverInternalFrame() {
        this._driverWinFactory.getCreateSheet().moveToFront();
    }

    public void showCopyDriverInternalFrame(ISQLDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        this._driverWinFactory.showCopySheet(driver).moveToFront();
    }

    public void moveToFront(final JInternalFrame fr) {
        if (fr != null) {
            GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GUIUtils.moveToFront((JInternalFrame)fr);
                }
            });
        } else {
            s_log.debug((Object)"JInternalFrame == null");
        }
    }
}

