/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.db.BaseListInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.DriversList;
import net.sourceforge.squirrel_sql.client.gui.db.IBaseList;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.mainframe.action.CopyDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CreateDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DeleteDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.InstallDefaultDriversAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyDriverCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.ShowDriverWebsiteAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ShowLoadedDriversOnlyAction;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.fw.gui.BasePopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DriversListInternalFrame
extends BaseListInternalFrame {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(BaseListInternalFrame.class);
    private IApplication _app;
    private UserInterfaceFactory _uiFactory;

    public DriversListInternalFrame(IApplication app, DriversList list) {
        super(new UserInterfaceFactory(app, list), app);
        this._app = app;
        this._uiFactory = (UserInterfaceFactory)this.getUserInterfaceFactory();
        this._uiFactory.setDriversListInternalFrame(this);
        this.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if ("closed".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                    throw new PropertyVetoException(s_stringMgr.getString("DriversListInternalFrame.error.ctrlF4key"), evt);
                }
            }
        });
        this.addWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetOpened(WidgetEvent evt) {
                DriversListInternalFrame.this.nowVisible(true);
            }

            @Override
            public void widgetClosing(WidgetEvent evt) {
                DriversListInternalFrame.this.nowVisible(false);
            }

            @Override
            public void widgetClosed(WidgetEvent evt) {
                DriversListInternalFrame.this.nowVisible(false);
            }
        });
        this._app.getSquirrelPreferences().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt != null ? evt.getPropertyName() : null;
                DriversListInternalFrame.this._uiFactory.propertiesChanged(propName);
            }
        });
    }

    public void nowVisible(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DriversListInternalFrame.this._app.getMainFrame().setEnabledDriversMenu(b);
                DriversListInternalFrame.this._uiFactory._driversList.requestFocus();
            }
        });
    }

    private static final class UserInterfaceFactory
    implements BaseListInternalFrame.IUserInterfaceFactory {
        private IApplication _app;
        private DriversList _driversList;
        private ToolBar _tb;
        private BasePopupMenu _pm = new BasePopupMenu();
        private DriversListInternalFrame _tw;

        UserInterfaceFactory(IApplication app, DriversList list) {
            if (app == null) {
                throw new IllegalArgumentException("IApplication == null");
            }
            if (list == null) {
                throw new IllegalArgumentException("DriversList == null");
            }
            this._app = app;
            this._driversList = list;
            ActionCollection actions = app.getActionCollection();
            this._pm.add(actions.get(CreateDriverAction.class));
            this._pm.addSeparator();
            this._pm.add(actions.get(ModifyDriverAction.class));
            this._pm.add(actions.get(CopyDriverAction.class));
            this._pm.add(actions.get(ShowDriverWebsiteAction.class));
            this._pm.addSeparator();
            this._pm.add(actions.get(DeleteDriverAction.class));
            this._pm.addSeparator();
        }

        @Override
        public ToolBar getToolBar() {
            return this._tb;
        }

        @Override
        public BasePopupMenu getPopupMenu() {
            return this._pm;
        }

        @Override
        public IBaseList getList() {
            return this._driversList;
        }

        @Override
        public String getWindowTitle() {
            return s_stringMgr.getString("DriversListInternalFrame.windowtitle");
        }

        @Override
        public ICommand getDoubleClickCommand(MouseEvent evt) {
            ModifyDriverCommand cmd = null;
            ISQLDriver driver = this._driversList.getSelectedDriver();
            if (driver != null) {
                cmd = new ModifyDriverCommand(this._app, driver);
            }
            return cmd;
        }

        void setDriversListInternalFrame(DriversListInternalFrame tw) {
            this._tw = tw;
            this.propertiesChanged(null);
        }

        public void propertiesChanged(String propName) {
            if (propName == null || propName.equals("showDriversToolBar")) {
                boolean show = this._app.getSquirrelPreferences().getShowDriversToolBar();
                if (show) {
                    this.createToolBar();
                } else {
                    this._tb = null;
                }
                this._tw.setToolBar(this.getToolBar());
            }
        }

        private void createToolBar() {
            this._tb = new ToolBar();
            this._tb.setUseRolloverButtons(true);
            this._tb.setFloatable(false);
            if (this._app.getDesktopStyle().isInternalFrameStyle()) {
                JLabel lbl = new JLabel(this.getWindowTitle(), 0);
                lbl.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                this._tb.add((Component)lbl, 0);
            }
            ActionCollection actions = this._app.getActionCollection();
            this._tb.add(actions.get(CreateDriverAction.class));
            this._tb.add(actions.get(ModifyDriverAction.class));
            this._tb.add(actions.get(CopyDriverAction.class));
            this._tb.add(actions.get(ShowDriverWebsiteAction.class));
            this._tb.add(actions.get(DeleteDriverAction.class));
            this._tb.addSeparator();
            this._tb.add(actions.get(InstallDefaultDriversAction.class));
            this._tb.addSeparator();
            Action act = actions.get(ShowLoadedDriversOnlyAction.class);
            JToggleButton btn = new JToggleButton(act);
            boolean show = this._app.getSquirrelPreferences().getShowLoadedDriversOnly();
            btn.setSelected(show);
            btn.setText(null);
            this._tb.add((Component)btn);
        }

        @Override
        public SquirrelPreferences getPreferences() {
            return this._app.getSquirrelPreferences();
        }
    }
}

