/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.fw.gui.SortedListModel;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.ObjectCacheChangeEvent;

class DriversListModel
extends SortedListModel {
    private static final long serialVersionUID = 1L;
    private IApplication _app;
    private boolean _showLoadedDriversOnly;

    public DriversListModel(IApplication app) throws IllegalArgumentException {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        this._app = app;
        this.load();
        this._app.getDataCache().addDriversListener(new MyDriversListener());
    }

    public void setShowLoadedDriversOnly(boolean show) {
        if (show != this._showLoadedDriversOnly) {
            this._showLoadedDriversOnly = show;
            this.load();
        }
    }

    private void load() {
        this.clear();
        Iterator<ISQLDriver> it = this._app.getDataCache().drivers();
        while (it.hasNext()) {
            this.addDriver(it.next());
        }
    }

    private void addDriver(ISQLDriver driver) {
        if (!this._showLoadedDriversOnly || driver.isJDBCDriverClassLoaded()) {
            this.addElement(driver);
        }
    }

    private void removeDriver(ISQLDriver driver) {
        this.removeElement(driver);
    }

    private class MyDriversListener
    implements IObjectCacheChangeListener {
        private MyDriversListener() {
        }

        public void objectAdded(ObjectCacheChangeEvent evt) {
            IHasIdentifier obj = evt.getObject();
            if (obj instanceof ISQLDriver) {
                DriversListModel.this.addDriver((ISQLDriver)obj);
            }
        }

        public void objectRemoved(ObjectCacheChangeEvent evt) {
            IHasIdentifier obj = evt.getObject();
            if (obj instanceof ISQLDriver) {
                DriversListModel.this.removeDriver((ISQLDriver)obj);
            }
        }
    }
}

