/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DesktopManagerWrapper;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DockWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IDesktopContainer;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.InternalFrameDelegate;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabWidget;
import net.sourceforge.squirrel_sql.client.gui.mainframe.SquirrelDesktopManager;
import net.sourceforge.squirrel_sql.fw.gui.CascadeInternalFramePositioner;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.IInternalFramePositioner;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ScrollableDesktopPane
extends JDesktopPane
implements IDesktopContainer {
    private static final long serialVersionUID = 1L;
    private final transient ILogger s_log = LoggerController.createLogger(ScrollableDesktopPane.class);
    private transient MyComponentListener _listener = new MyComponentListener();
    private final transient IInternalFramePositioner _internalFramePositioner = new CascadeInternalFramePositioner();
    private transient IApplication _app;

    public ScrollableDesktopPane(IApplication app) {
        this._app = app;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.setPreferredSize(this.getRequiredSize());
        super.paintComponent(g);
    }

    @Override
    public void remove(Component comp) {
        if (comp != null) {
            comp.removeComponentListener(this._listener);
            super.remove(comp);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp != null) {
            comp.addComponentListener(this._listener);
            this.revalidate();
        }
        super.addImpl(comp, constraints, index);
    }

    @Override
    public Dimension getRequiredSize() {
        JInternalFrame[] frames = this.getAllFrames();
        int maxX = 0;
        int maxY = 0;
        for (int i = 0; i < frames.length; ++i) {
            int y;
            if (!frames[i].isVisible()) continue;
            JInternalFrame frame = frames[i];
            int x = frame.getX() + frame.getWidth();
            if (x > maxX) {
                maxX = x;
            }
            if ((y = frame.getY() + frame.getHeight()) <= maxY) continue;
            maxY = y;
        }
        return new Dimension(maxX, maxY);
    }

    @Override
    public IWidget[] getAllWidgets() {
        JInternalFrame[] jInternalFrames = this.getAllFrames();
        IWidget[] ret = new IWidget[jInternalFrames.length];
        for (int i = 0; i < jInternalFrames.length; ++i) {
            ret[i] = ((InternalFrameDelegate)jInternalFrames[i]).getWidget();
        }
        return ret;
    }

    @Override
    public IWidget getSelectedWidget() {
        InternalFrameDelegate d = (InternalFrameDelegate)this.getSelectedFrame();
        return d.getWidget();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void addWidget(DialogWidget widget) {
        if (null != widget) {
            JInternalFrame delegate = (JInternalFrame)((Object)widget.getDelegate());
            this.addInternalFrame(delegate);
        }
    }

    @Override
    public void addWidget(DockWidget widget) {
        JInternalFrame delegate = (JInternalFrame)((Object)widget.getDelegate());
        this.addInternalFrame(delegate);
    }

    @Override
    public void addWidget(TabWidget widget) {
        JInternalFrame delegate = (JInternalFrame)((Object)widget.getDelegate());
        this.addInternalFrame(delegate);
    }

    private void addInternalFrame(JInternalFrame delegate) {
        this.beforeAdd(delegate);
        super.add(delegate);
        this.afterAdd(delegate);
    }

    private void afterAdd(JInternalFrame child) {
        if (!GUIUtils.isToolWindow((JInternalFrame)child)) {
            this._internalFramePositioner.positionInternalFrame(child);
        }
        if (!GUIUtils.isToolWindow((JInternalFrame)child) && child.isMaximizable() && this._app.getSquirrelPreferences().getMaximizeSessionSheetOnOpen()) {
            try {
                child.setMaximum(true);
            }
            catch (PropertyVetoException ex) {
                this.s_log.error((Object)"Unable to maximize window", (Throwable)ex);
            }
        }
    }

    private void beforeAdd(JInternalFrame child) {
        if (!GUIUtils.isToolWindow((JInternalFrame)child)) {
            Dimension cs = this.getSize();
            cs.setSize((int)((double)cs.width * 0.8), (int)((double)cs.height * 0.8));
            child.setSize(cs);
        }
    }

    @Override
    public void putClientProperty(String key, String value) {
        super.putClientProperty(key, value);
    }

    @Override
    public void setDesktopManager(SquirrelDesktopManager squirrelDesktopManager) {
        super.setDesktopManager(new DesktopManagerWrapper(squirrelDesktopManager));
    }

    private final class MyComponentListener
    implements ComponentListener {
        private MyComponentListener() {
        }

        @Override
        public void componentHidden(ComponentEvent evt) {
            ScrollableDesktopPane.this.revalidate();
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
            ScrollableDesktopPane.this.revalidate();
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            ScrollableDesktopPane.this.revalidate();
        }

        @Override
        public void componentShown(ComponentEvent evt) {
            ScrollableDesktopPane.this.revalidate();
        }
    }
}

