/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.awt.Component;
import java.awt.Frame;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.DataCache;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DeleteDriverCommand
implements ICommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DeleteDriverCommand.class);
    private final IApplication _app;
    private Frame _frame;
    private ISQLDriver _sqlDriver;

    public DeleteDriverCommand(IApplication app, Frame frame, ISQLDriver sqlDriver) {
        if (sqlDriver == null) {
            throw new IllegalArgumentException("Null ISQLDriver passed");
        }
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        this._app = app;
        this._frame = frame;
        this._sqlDriver = sqlDriver;
    }

    public void execute() {
        Object[] args = new Object[]{this._sqlDriver.getName()};
        DataCache cache = this._app.getDataCache();
        Iterator<ISQLAlias> it = cache.getAliasesForDriver(this._sqlDriver);
        if (it.hasNext()) {
            StringBuffer aliasList = new StringBuffer();
            while (it.hasNext()) {
                SQLAlias alias = (SQLAlias)it.next();
                aliasList.append("\n");
                aliasList.append(alias.getName());
            }
            Object[] args2 = new Object[]{this._sqlDriver.getName(), aliasList};
            String msg = s_stringMgr.getString("DeleteDriverCommand.used", args2);
            Dialogs.showOk((Component)this._frame, (String)msg);
        } else if (Dialogs.showYesNo((Component)this._frame, (String)s_stringMgr.getString("DeleteDriverCommand.comfirm", args))) {
            cache.removeDriver(this._sqlDriver);
        }
    }
}

