/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DumpApplicationCommand;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.gui.ErrorDialog;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.ListMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DumpApplicationAction
extends SquirrelAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DumpApplicationAction.class);
    private static final ILogger s_log = LoggerController.createLogger(DumpApplicationAction.class);

    public DumpApplicationAction(IApplication app) {
        super(app);
    }

    public void actionPerformed(ActionEvent evt) {
        IApplication app = this.getApplication();
        Frame parentFrame = this.getParentFrame(evt);
        FileExtensionFilter[] filters = new FileExtensionFilter[]{new FileExtensionFilter(s_stringMgr.getString("DumpApplicationAction.textfiles"), new String[]{".txt"})};
        JLabel lbl = new JLabel(s_stringMgr.getString("DumpApplicationAction.warning"));
        lbl.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        File outFile = Dialogs.selectFileForWriting((Frame)parentFrame, (FileExtensionFilter[])filters, (JComponent)lbl);
        if (outFile != null) {
            ListMessageHandler msgHandler = new ListMessageHandler();
            DumpApplicationCommand cmd = new DumpApplicationCommand(app, outFile, (IMessageHandler)msgHandler);
            try {
                cmd.execute();
                String[] msgs = msgHandler.getMessages();
                String[] warnings = msgHandler.getWarningMessages();
                Throwable[] errors = msgHandler.getExceptions();
                if (msgs.length > 0 || errors.length > 0 || warnings.length > 0) {
                    int i;
                    for (i = 0; i < msgs.length; ++i) {
                        app.showErrorDialog(msgs[i]);
                    }
                    for (i = 0; i < warnings.length; ++i) {
                        app.showErrorDialog(warnings[i]);
                    }
                    for (i = 0; i < errors.length; ++i) {
                        app.showErrorDialog(errors[i]);
                    }
                } else {
                    String msg = s_stringMgr.getString("DumpApplicationAction.success", new Object[]{outFile.getAbsolutePath()});
                    ErrorDialog dlg = new ErrorDialog((Frame)this.getApplication().getMainFrame(), msg);
                    dlg.setTitle(s_stringMgr.getString("DumpApplicationAction.titleSuccess"));
                    dlg.setVisible(true);
                }
            }
            catch (Throwable ex) {
                String msg = s_stringMgr.getString("DumpApplicationAction.failure");
                app.showErrorDialog(msg, ex);
                s_log.error((Object)msg, ex);
            }
        }
    }
}

