/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.DumpSessionCommand;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTextFileDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.HashtableDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.NullMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.beanwrapper.URLWrapper;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;

public class DumpApplicationCommand
implements ICommand {
    private final ILogger s_log = LoggerController.createLogger(DumpApplicationCommand.class);
    private static final String PREFIX = "dump";
    private static final String SUFFIX = "tmp";
    private static String SEP = "===================================================";
    private IApplication _app;
    private File _outFile;
    private IMessageHandler _msgHandler;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DumpApplicationCommand.class);

    public DumpApplicationCommand(IApplication app, File outFile, IMessageHandler msgHandler) {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (outFile == null) {
            throw new IllegalArgumentException("Null File passed");
        }
        this._app = app;
        this._outFile = outFile;
        this._msgHandler = msgHandler != null ? msgHandler : NullMessageHandler.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<String> titles = new ArrayList<String>();
        IApplication iApplication = this._app;
        synchronized (iApplication) {
            File tempFile;
            String msg;
            ApplicationStatusBean bean = new ApplicationStatusBean();
            bean.load(this._app);
            try {
                files.add(this.createJavaBeanDumpFile(bean));
                titles.add(s_stringMgr.getString("DumpApplicationCommand.title.status"));
            }
            catch (Throwable th) {
                msg = s_stringMgr.getString("DumpApplicationCommand.error.dumpingstatus");
                this._msgHandler.showMessage(msg);
                this._msgHandler.showMessage(th, null);
                this.s_log.error((Object)msg, th);
            }
            try {
                tempFile = File.createTempFile(PREFIX, SUFFIX);
                DataSetViewerTextFileDestination dest = new DataSetViewerTextFileDestination(tempFile);
                dest.show((IDataSet)new HashtableDataSet(System.getProperties()));
                files.add(tempFile);
                titles.add(s_stringMgr.getString("DumpApplicationCommand.title.systemprops"));
            }
            catch (Throwable th) {
                msg = s_stringMgr.getString("DumpApplicationCommand.error.dumpingsystemprops");
                this._msgHandler.showMessage(msg);
                this._msgHandler.showMessage(th, null);
                this.s_log.error((Object)msg, th);
            }
            try {
                tempFile = File.createTempFile(PREFIX, SUFFIX);
                this._app.getDataCache().saveDrivers(tempFile);
                files.add(tempFile);
                titles.add(s_stringMgr.getString("DumpApplicationCommand.title.drivers"));
            }
            catch (Throwable th) {
                msg = s_stringMgr.getString("DumpApplicationCommand.error.dumpingdrivers");
                this._msgHandler.showMessage(msg);
                this._msgHandler.showMessage(th, null);
                this.s_log.error((Object)msg, th);
            }
            try {
                tempFile = File.createTempFile(PREFIX, SUFFIX);
                this._app.getDataCache().saveAliases(tempFile);
                files.add(tempFile);
                titles.add(s_stringMgr.getString("DumpApplicationCommand.title.aliases"));
            }
            catch (Throwable th) {
                msg = s_stringMgr.getString("DumpApplicationCommand.error.dumpingaliases");
                this._msgHandler.showMessage(msg);
                this._msgHandler.showMessage(th, null);
                this.s_log.error((Object)msg, th);
            }
            ISession[] sessions = this._app.getSessionManager().getConnectedSessions();
            DumpSessionCommand sessionCmd = new DumpSessionCommand();
            for (int i = 0; i < sessions.length; ++i) {
                try {
                    File tempFile2 = File.createTempFile(PREFIX, SUFFIX);
                    sessionCmd.setSession(sessions[i]);
                    sessionCmd.setDumpFile(tempFile2);
                    sessionCmd.execute();
                    files.add(tempFile2);
                    String title = s_stringMgr.getString("DumpApplicationCommand.title.sessiondump", new Object[]{sessions[i].getIdentifier()});
                    titles.add(title);
                    continue;
                }
                catch (Throwable th) {
                    String msg2 = s_stringMgr.getString("DumpApplicationCommand.error.sessiondump");
                    this._msgHandler.showMessage(msg2);
                    this._msgHandler.showMessage(th, null);
                    this.s_log.error((Object)msg2, th);
                }
            }
        }
        this.combineTempFiles(titles, files);
        this.deleteTempFiles(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void combineTempFiles(List<String> titles, List<File> files) {
        try {
            PrintWriter wtr = new PrintWriter(new FileWriter(this._outFile));
            try {
                String header = s_stringMgr.getString("DumpApplicationCommand.header", new Object[]{Calendar.getInstance().getTime()});
                wtr.println(header);
                int limit = files.size();
                for (int i = 0; i < limit; ++i) {
                    wtr.println();
                    wtr.println();
                    wtr.println(SEP);
                    wtr.println(titles.get(i));
                    wtr.println(SEP);
                    BufferedReader rdr = new BufferedReader(new FileReader(files.get(i)));
                    try {
                        String line = null;
                        while ((line = rdr.readLine()) != null) {
                            wtr.println(line);
                        }
                        continue;
                    }
                    finally {
                        rdr.close();
                    }
                }
            }
            finally {
                wtr.close();
            }
        }
        catch (IOException ex) {
            String msg = s_stringMgr.getString("DumpApplicationCommand.error.combiningtempfiles");
            this._msgHandler.showMessage(msg);
            this._msgHandler.showMessage(ex.toString());
            this.s_log.error((Object)msg, (Throwable)ex);
        }
    }

    private void deleteTempFiles(List<File> files) {
        int limit = files.size();
        for (int i = 0; i < limit; ++i) {
            if (files.get(i).delete()) continue;
            this.s_log.error((Object)s_stringMgr.getString("DumpApplicationCommand.error.deletetempfile"));
        }
    }

    private File createJavaBeanDumpFile(Object obj) throws IOException, XMLException {
        File tempFile = File.createTempFile(PREFIX, SUFFIX);
        XMLBeanWriter wtr = new XMLBeanWriter(obj);
        wtr.save(tempFile);
        return tempFile;
    }

    public static final class ApplicationStatusBean {
        private SquirrelPreferences _prefs;
        private PluginInfo[] _plugins;
        private String[] _appArgs;
        private String _version;
        private String _pluginLoc;
        private URLWrapper[] _pluginURLs;

        void load(IApplication app) {
            this._prefs = app.getSquirrelPreferences();
            this._plugins = app.getPluginManager().getPluginInformation();
            this._appArgs = ApplicationArguments.getInstance().getRawArguments();
            this._version = Version.getVersion();
            this._pluginLoc = new ApplicationFiles().getPluginsDirectory().getAbsolutePath();
            URL[] urls = app.getPluginManager().getPluginURLs();
            this._pluginURLs = new URLWrapper[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                this._pluginURLs[i] = new URLWrapper(urls[i]);
            }
        }

        public String getVersion() {
            return this._version;
        }

        public SquirrelPreferences getPreferences() {
            return this._prefs;
        }

        public String getPluginLocation() {
            return this._pluginLoc;
        }

        public PluginInfo[] getPluginInfo() {
            return this._plugins;
        }

        public URLWrapper[] getPluginURLs() {
            return this._pluginURLs;
        }

        public PluginInfo getPluginInfo(int idx) throws ArrayIndexOutOfBoundsException {
            return this._plugins[idx];
        }

        public String[] getApplicationArgument() {
            return this._appArgs;
        }

        public String getApplicationArgument(int idx) throws ArrayIndexOutOfBoundsException {
            return this._appArgs[idx];
        }
    }
}

