/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PreferenceUtil;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;

public class PluginQueryTokenizerPreferencesManager {
    private static final ILogger s_log = LoggerController.createLogger(PluginQueryTokenizerPreferencesManager.class);
    private static final String USER_PREFS_FILE_NAME = "prefs.xml";
    private File _userSettingsFolder;
    private IQueryTokenizerPreferenceBean _prefs = null;
    private IPlugin plugin = null;
    private boolean _initialized = false;

    public void initialize(IPlugin thePlugin, IQueryTokenizerPreferenceBean defaultPrefsBean) throws PluginException {
        if (thePlugin == null) {
            throw new IllegalArgumentException("IPlugin arguement cannot be null");
        }
        if (defaultPrefsBean == null) {
            throw new IllegalArgumentException("IQueryTokenizerPreferenceBean arguement cannot be null");
        }
        this.plugin = thePlugin;
        try {
            this._userSettingsFolder = this.plugin.getPluginUserSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException(ex);
        }
        this._prefs = defaultPrefsBean;
        this.loadPrefs();
        this._initialized = true;
    }

    public IQueryTokenizerPreferenceBean getPreferences() {
        if (!this._initialized) {
            throw new IllegalStateException("initialize() must be called first");
        }
        return this._prefs;
    }

    public void unload() {
        this.savePrefs();
    }

    public void savePrefs() {
        if (!this._initialized) {
            throw new IllegalStateException("initialize() must be called first");
        }
        try {
            XMLBeanWriter wtr = new XMLBeanWriter((Object)this._prefs);
            wtr.save(new File(this._userSettingsFolder, USER_PREFS_FILE_NAME));
        }
        catch (Exception ex) {
            s_log.error((Object)"Error occured writing to preferences file: prefs.xml", (Throwable)ex);
        }
    }

    private void loadPrefs() {
        try {
            XMLBeanReader doc = new XMLBeanReader();
            File prefFile = PreferenceUtil.getPreferenceFileToReadFrom(this.plugin);
            doc.load(prefFile, this._prefs.getClass().getClassLoader());
            Iterator it = doc.iterator();
            if (it.hasNext()) {
                this._prefs = (IQueryTokenizerPreferenceBean)it.next();
            }
        }
        catch (FileNotFoundException ignore) {
            s_log.info((Object)"prefs.xml not found - will be created");
        }
        catch (Exception ex) {
            s_log.error((Object)"Error occured reading from preferences file: prefs.xml", (Throwable)ex);
        }
        this._prefs.setClientName(Version.getApplicationName() + "/" + this.plugin.getDescriptiveName());
        this._prefs.setClientVersion(Version.getShortVersion() + "/" + this.plugin.getVersion());
    }
}

