/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.LocaleUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

class GeneralPreferencesPanel
implements IGlobalPreferencesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GeneralPreferencesPanel.class);
    private MyPanel _myPanel;
    private JScrollPane _myScrollPane;
    private IApplication _app;

    @Override
    public void initialize(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
        this.getPanelComponent();
        this._myPanel.loadData(this._app.getSquirrelPreferences());
    }

    @Override
    public void uninitialize(IApplication app) {
    }

    @Override
    public synchronized Component getPanelComponent() {
        if (this._myPanel == null) {
            this._myPanel = new MyPanel();
            this._myScrollPane = new JScrollPane(this._myPanel);
        }
        return this._myScrollPane;
    }

    @Override
    public void applyChanges() {
        this._myPanel.applyChanges(this._app.getSquirrelPreferences());
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("GeneralPreferencesPanel.tabtitle");
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("GeneralPreferencesPanel.tabhint");
    }

    private static final class MyPanel
    extends JPanel {
        private JRadioButton _tabbedStyle = new JRadioButton(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.tabbedStyle"));
        private JRadioButton _internalFrameStyle = new JRadioButton(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.internalFrameStyle"));
        private JCheckBox _useScrollableTabbedPanesForSessionTabs = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.useScrollableTabbedPanesForSessionTabs"));
        private JCheckBox _showContents = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.showwindowcontents"));
        private JCheckBox _maximimizeSessionSheet = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.maxonopen"));
        private JCheckBox _showTabbedStyleHint = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.showTabbedStyleHint"));
        private JCheckBox _showAliasesToolBar = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.showaliasestoolbar"));
        private JCheckBox _showDriversToolBar = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.showdriverstoolbar"));
        private JCheckBox _showMainStatusBar = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.showmainwinstatusbar"));
        private JCheckBox _showMainToolBar = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.showmainwintoolbar"));
        private JCheckBox _showToolTips = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.showtooltips"));
        private JCheckBox _useScrollableTabbedPanes = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.usescrolltabs"));
        private JCheckBox _showColoriconsInToolbar = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.showcoloricons"));
        private JCheckBox _showPluginFilesInSplashScreen = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.showpluginfiles"));
        private JCheckBox _confirmSessionCloseChk = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.confirmSessionClose"));
        private JCheckBox _warnJreJdbcMismatch = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.warnJreJdbcMismatch"));
        private JCheckBox _warnForUnsavedFileEdits = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.warnForUnsavedFileEdits"));
        private JCheckBox _warnForUnsavedBufferEdits = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.warnForUnsavedBufferEdits"));
        private JCheckBox _showSessionStartupTimeHint = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.showSessionStartupTimeHint"));
        private JCheckBox _savePreferencesImmediately = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.savePreferencesImmediately"));
        private JCheckBox _selectOnRightMouseClick = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.selectOnRightMouseClick"));
        private JCheckBox _showPleaseWaitDialog = new JCheckBox(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.showPleaseWaitDialog"));
        private JLabel _localeChooserLabel = new JLabel(GeneralPreferencesPanel.access$000().getString("GeneralPreferencesPanel.localeChooserLabel"));
        ArrayList<String> localeDisplayStrings = new ArrayList();
        private JComboBox _localeChooser = new JComboBox<String>(LocaleUtils.getAvailableLocaleStrings());

        MyPanel() {
            super(new GridBagLayout());
            this.createUserInterface();
        }

        void loadData(SquirrelPreferences prefs) {
            this._tabbedStyle.setSelected(prefs.getTabbedStyle());
            this._useScrollableTabbedPanesForSessionTabs.setSelected(prefs.getUseScrollableTabbedPanesForSessionTabs());
            this._internalFrameStyle.setSelected(!prefs.getTabbedStyle());
            this.onStyleChanged();
            this._showTabbedStyleHint.setSelected(prefs.getShowTabbedStyleHint());
            this._showContents.setSelected(prefs.getShowContentsWhenDragging());
            this._maximimizeSessionSheet.setSelected(prefs.getMaximizeSessionSheetOnOpen());
            this._showToolTips.setSelected(prefs.getShowToolTips());
            this._useScrollableTabbedPanes.setSelected(prefs.getUseScrollableTabbedPanes());
            this._showMainStatusBar.setSelected(prefs.getShowMainStatusBar());
            this._showMainToolBar.setSelected(prefs.getShowMainToolBar());
            this._showAliasesToolBar.setSelected(prefs.getShowAliasesToolBar());
            this._showDriversToolBar.setSelected(prefs.getShowDriversToolBar());
            this._showColoriconsInToolbar.setSelected(prefs.getShowColoriconsInToolbar());
            this._showPluginFilesInSplashScreen.setSelected(prefs.getShowPluginFilesInSplashScreen());
            this._confirmSessionCloseChk.setSelected(prefs.getConfirmSessionClose());
            this._warnJreJdbcMismatch.setSelected(prefs.getWarnJreJdbcMismatch());
            this._warnForUnsavedFileEdits.setSelected(prefs.getWarnForUnsavedFileEdits());
            this._warnForUnsavedBufferEdits.setSelected(prefs.getWarnForUnsavedBufferEdits());
            this._showSessionStartupTimeHint.setSelected(prefs.getShowSessionStartupTimeHint());
            this._savePreferencesImmediately.setSelected(prefs.getSavePreferencesImmediately());
            this._selectOnRightMouseClick.setSelected(prefs.getSelectOnRightMouseClick());
            this._showPleaseWaitDialog.setSelected(prefs.getShowPleaseWaitDialog());
            String preferredLocalString = prefs.getPreferredLocale();
            if (StringUtilities.isEmpty((String)preferredLocalString)) {
                preferredLocalString = "en_US";
            }
            this._localeChooser.setSelectedItem(preferredLocalString);
            this._tabbedStyle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyPanel.this.onStyleChanged();
                }
            });
            this._internalFrameStyle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyPanel.this.onStyleChanged();
                }
            });
        }

        private void onStyleChanged() {
            this._useScrollableTabbedPanesForSessionTabs.setEnabled(this._tabbedStyle.isSelected());
            this._showContents.setEnabled(this._internalFrameStyle.isSelected());
            this._maximimizeSessionSheet.setEnabled(this._internalFrameStyle.isSelected());
            this._showTabbedStyleHint.setEnabled(this._internalFrameStyle.isSelected());
        }

        void applyChanges(SquirrelPreferences prefs) {
            prefs.setTabbedStyle(this._tabbedStyle.isSelected());
            prefs.setUseScrollableTabbedPanesForSessionTabs(this._useScrollableTabbedPanesForSessionTabs.isSelected());
            prefs.setShowContentsWhenDragging(this._showContents.isSelected());
            prefs.setShowTabbedStyleHint(this._showTabbedStyleHint.isSelected());
            prefs.setShowToolTips(this._showToolTips.isSelected());
            prefs.setUseScrollableTabbedPanes(this._useScrollableTabbedPanes.isSelected());
            prefs.setShowMainStatusBar(this._showMainStatusBar.isSelected());
            prefs.setShowMainToolBar(this._showMainToolBar.isSelected());
            prefs.setShowAliasesToolBar(this._showAliasesToolBar.isSelected());
            prefs.setShowDriversToolBar(this._showDriversToolBar.isSelected());
            prefs.setMaximizeSessionSheetOnOpen(this._maximimizeSessionSheet.isSelected());
            prefs.setShowColoriconsInToolbar(this._showColoriconsInToolbar.isSelected());
            prefs.setShowPluginFilesInSplashScreen(this._showPluginFilesInSplashScreen.isSelected());
            prefs.setConfirmSessionClose(this._confirmSessionCloseChk.isSelected());
            prefs.setWarnJreJdbcMismatch(this._warnJreJdbcMismatch.isSelected());
            prefs.setWarnForUnsavedFileEdits(this._warnForUnsavedFileEdits.isSelected());
            prefs.setWarnForUnsavedBufferEdits(this._warnForUnsavedBufferEdits.isSelected());
            prefs.setShowSessionStartupTimeHint(this._showSessionStartupTimeHint.isSelected());
            prefs.setSavePreferencesImmediately(this._savePreferencesImmediately.isSelected());
            prefs.setSelectOnRightMouseClick(this._selectOnRightMouseClick.isSelected());
            prefs.setShowPleaseWaitDialog(this._showPleaseWaitDialog.isSelected());
            prefs.setPreferredLocale(this._localeChooser.getSelectedItem().toString());
        }

        private void createUserInterface() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.anchor = 18;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            this.add((Component)this.createAppearancePanel(), gbc);
            ++gbc.gridx;
            this.add((Component)this.createGeneralPanel(), gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 2;
            this.add((Component)this.createLoggingPanel(), gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 2;
            this.add((Component)this.createPathsPanel(), gbc);
        }

        private JPanel createAppearancePanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("GeneralPreferencesPanel.appearance")));
            pnl.setLayout(new GridBagLayout());
            ButtonGroup g = new ButtonGroup();
            g.add(this._tabbedStyle);
            g.add(this._internalFrameStyle);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(2, 4, 2, 4);
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.insets.top = 0;
            gbc.gridy = 0;
            this._tabbedStyle.setName("tabbedStyleRadioButton");
            pnl.add((Component)this._tabbedStyle, gbc);
            ++gbc.gridy;
            this._internalFrameStyle.setName("internalFrameStyleRadioButton");
            pnl.add((Component)this._internalFrameStyle, gbc);
            ++gbc.gridy;
            this._useScrollableTabbedPanesForSessionTabs.setName("useScrollableTabbedPanes");
            pnl.add((Component)this._useScrollableTabbedPanesForSessionTabs, gbc);
            ++gbc.gridy;
            this._showContents.setName("showContentsCheckBox");
            pnl.add((Component)this._showContents, gbc);
            ++gbc.gridy;
            this._maximimizeSessionSheet.setName("maximizeSessionSheetCheckBox");
            pnl.add((Component)this._maximimizeSessionSheet, gbc);
            ++gbc.gridy;
            this._showTabbedStyleHint.setName("showTabbedStyleHintCheckBox");
            pnl.add((Component)this._showTabbedStyleHint, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._showToolTips, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._useScrollableTabbedPanes, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._showMainToolBar, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._showMainStatusBar, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._showDriversToolBar, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._showAliasesToolBar, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._showColoriconsInToolbar, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._showPluginFilesInSplashScreen, gbc);
            return pnl;
        }

        private JPanel createGeneralPanel() {
            JPanel pnl = new JPanel();
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("GeneralPreferencesPanel.general")));
            pnl.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(2, 4, 2, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            pnl.add((Component)this._confirmSessionCloseChk, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            pnl.add((Component)this._warnJreJdbcMismatch, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            pnl.add((Component)this._warnForUnsavedFileEdits, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            pnl.add((Component)this._warnForUnsavedBufferEdits, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            pnl.add((Component)this._showSessionStartupTimeHint, gbc);
            gbc.gridx = 0;
            gbc.gridy = 5;
            pnl.add((Component)this._savePreferencesImmediately, gbc);
            gbc.gridx = 0;
            gbc.gridy = 6;
            pnl.add((Component)this._selectOnRightMouseClick, gbc);
            gbc.gridx = 0;
            gbc.gridy = 7;
            pnl.add((Component)this._showPleaseWaitDialog, gbc);
            this._localeChooser.setBorder(new EmptyBorder(5, 20, 5, 30));
            JPanel localePanel = new JPanel();
            BoxLayout layout = new BoxLayout(localePanel, 0);
            localePanel.setLayout(layout);
            localePanel.add(this._localeChooserLabel);
            localePanel.add(this._localeChooser);
            gbc.gridx = 0;
            gbc.gridy = 8;
            pnl.add((Component)localePanel, gbc);
            return pnl;
        }

        private JPanel createLoggingPanel() {
            JPanel pnl = new JPanel();
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("GeneralPreferencesPanel.logging")));
            pnl.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 4, 2, 4);
            gbc.anchor = 18;
            ApplicationFiles appFiles = new ApplicationFiles();
            String execLogFile = appFiles.getExecutionLogFile().getPath();
            String configFile = ApplicationArguments.getInstance().getLoggingConfigFileName();
            configFile = null == configFile ? s_stringMgr.getString("GeneralPreferencesPanel.unspecified") : configFile;
            gbc.gridx = 0;
            gbc.gridy = 0;
            JTextField execLogFileField = new JTextField(s_stringMgr.getString("GeneralPreferencesPanel.execlogfileNew", new Object[]{execLogFile}));
            execLogFileField.setEditable(false);
            execLogFileField.setBackground(pnl.getBackground());
            execLogFileField.setBorder(null);
            pnl.add((Component)execLogFileField, gbc);
            ++gbc.gridy;
            JTextField configFileField = new JTextField(s_stringMgr.getString("GeneralPreferencesPanel.configfileNew", new Object[]{configFile}));
            configFileField.setEditable(false);
            configFileField.setBackground(pnl.getBackground());
            configFileField.setBorder(null);
            pnl.add((Component)configFileField, gbc);
            gbc.weightx = 1.0;
            gbc.gridy = 0;
            ++gbc.gridx;
            pnl.add((Component)new JPanel(), gbc);
            ++gbc.gridy;
            pnl.add((Component)new JPanel(), gbc);
            return pnl;
        }

        private JPanel createPathsPanel() {
            JPanel pnl = new JPanel();
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("GeneralPreferencesPanel.paths")));
            pnl.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 0;
            gbc.insets = new Insets(2, 4, 2, 4);
            gbc.anchor = 18;
            ApplicationFiles appFiles = new ApplicationFiles();
            String userDir = appFiles.getUserSettingsDirectory().getPath();
            String homeDir = appFiles.getSquirrelHomeDir().getPath();
            gbc.gridx = 0;
            gbc.gridy = 0;
            JTextField homePathField = new JTextField(s_stringMgr.getString("GeneralPreferencesPanel.squirrelHomePath", new Object[]{homeDir}));
            homePathField.setEditable(false);
            homePathField.setBackground(pnl.getBackground());
            homePathField.setBorder(null);
            pnl.add((Component)homePathField, gbc);
            ++gbc.gridy;
            JTextField userPathField = new JTextField(s_stringMgr.getString("GeneralPreferencesPanel.squirrelUserPath", new Object[]{userDir}));
            userPathField.setEditable(false);
            userPathField.setBackground(pnl.getBackground());
            userPathField.setBorder(null);
            pnl.add((Component)userPathField, gbc);
            gbc.weightx = 1.0;
            gbc.gridy = 0;
            ++gbc.gridx;
            pnl.add((Component)new JPanel(), gbc);
            ++gbc.gridy;
            pnl.add((Component)new JPanel(), gbc);
            return pnl;
        }
    }
}

