/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.IUpdateSettings;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.preferences.UpdateChannelComboBoxEntry;
import net.sourceforge.squirrel_sql.client.preferences.UpdateCheckFrequencyComboBoxEntry;
import net.sourceforge.squirrel_sql.client.preferences.UpdateSettings;
import net.sourceforge.squirrel_sql.client.update.UpdateCheckFrequency;
import net.sourceforge.squirrel_sql.client.update.UpdateUtil;
import net.sourceforge.squirrel_sql.client.update.UpdateUtilImpl;
import net.sourceforge.squirrel_sql.fw.util.IProxySettings;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class UpdatePreferencesPanel
extends JPanel {
    private static final Color CONNECTION_FAILURE_COLOR = Color.RED;
    private static final Color CONNECTION_SUCCESS_COLOR = new Color(67, 181, 118);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(UpdatePreferencesPanel.class);
    private static final UpdateUtil _updateUtil = new UpdateUtilImpl();
    private static final long serialVersionUID = 6411907298042579120L;
    private JLabel _serverLabel = null;
    private JLabel _portLabel = null;
    private JLabel _pathLabel = null;
    private JLabel _localPathLabel = null;
    private JLabel _channelLabel = null;
    private JLabel _urlLabel = null;
    private JTextField _updateServerName = new JTextField();
    private JTextField _updateServerPort = new JTextField();
    private JTextField _updateServerPath = new JTextField();
    private JTextField _localPath = new JTextField();
    private JTextField _updateUrl = new JTextField();
    private JLabel siteTypeLabel = null;
    private JRadioButton _remoteTypeButton = new JRadioButton(i18n.REMOTE_SITE_BUTTON_LABEL);
    private JRadioButton _localTypeButton = new JRadioButton(i18n.LOCAL_SITE_BUTTON_LABEL);
    private ButtonGroup _updateSiteTypeGroup = new ButtonGroup();
    private UpdateChannelComboBoxEntry stableChannel = new UpdateChannelComboBoxEntry(UpdateChannelComboBoxEntry.ChannelType.STABLE, "stable");
    private UpdateChannelComboBoxEntry snapshotChannel = new UpdateChannelComboBoxEntry(UpdateChannelComboBoxEntry.ChannelType.SNAPSHOT, "snapshot");
    private JComboBox _updateServerChannel = new JComboBox<Object>(new Object[]{this.stableChannel, this.snapshotChannel});
    private JCheckBox _enableAutoUpdateChk = new JCheckBox(i18n.ENABLE_AUTO_UPDATE);
    private UpdateCheckFrequencyComboBoxEntry checkAtStartup = new UpdateCheckFrequencyComboBoxEntry(UpdateCheckFrequency.STARTUP, i18n.AT_STARTUP_LABEL);
    private UpdateCheckFrequencyComboBoxEntry checkDaily = new UpdateCheckFrequencyComboBoxEntry(UpdateCheckFrequency.DAILY, i18n.DAILY_LABEL);
    private UpdateCheckFrequencyComboBoxEntry checkWeekly = new UpdateCheckFrequencyComboBoxEntry(UpdateCheckFrequency.WEEKLY, i18n.WEEKLY_LABEL);
    private JComboBox _updateCheckFrequency = new JComboBox<Object>(new Object[]{this.checkAtStartup, this.checkDaily, this.checkWeekly});
    private JButton _testConnectionButton = new JButton(i18n.TEST_LABEL);
    private JLabel _testConnectionStatusLabel = new JLabel();
    private final Insets SEP_INSETS = new Insets(10, 14, 0, 14);
    private final Insets LABEL_INSETS = new Insets(2, 28, 6, 0);
    private final Insets FIELD_INSETS = new Insets(2, 8, 6, 28);
    private IApplication _app;

    public UpdatePreferencesPanel() {
        super(new GridBagLayout());
        this.createUserInterface();
    }

    void loadData(SquirrelPreferences prefs) {
        IUpdateSettings updateSettings = prefs.getUpdateSettings();
        this._updateServerName.setText(updateSettings.getUpdateServer());
        this._updateServerPort.setText(updateSettings.getUpdateServerPort());
        this._updateServerPath.setText(updateSettings.getUpdateServerPath());
        String channelStr = updateSettings.getUpdateServerChannel();
        this._updateServerChannel.setSelectedItem(this.stableChannel);
        if (channelStr != null && channelStr.equals(UpdateChannelComboBoxEntry.ChannelType.SNAPSHOT.name())) {
            this._updateServerChannel.setSelectedItem(this.snapshotChannel);
        }
        this._enableAutoUpdateChk.setSelected(updateSettings.isEnableAutomaticUpdates());
        UpdateCheckFrequency updateCheckFrequency = UpdateCheckFrequency.getEnumForString(updateSettings.getUpdateCheckFrequency());
        if (updateCheckFrequency == UpdateCheckFrequency.DAILY) {
            this._updateCheckFrequency.setSelectedItem(this.checkDaily);
        }
        if (updateCheckFrequency == UpdateCheckFrequency.STARTUP) {
            this._updateCheckFrequency.setSelectedItem(this.checkAtStartup);
        }
        if (updateCheckFrequency == UpdateCheckFrequency.WEEKLY) {
            this._updateCheckFrequency.setSelectedItem(this.checkWeekly);
        }
        if (updateSettings.isRemoteUpdateSite()) {
            this._remoteTypeButton.setSelected(true);
            this.enableRemoteSite();
        } else {
            this._localTypeButton.setSelected(true);
            this.enableLocalPath();
        }
        this._localPath.setText(updateSettings.getFileSystemUpdatePath());
        this.updateControlStatus();
        this.updateUrl();
    }

    void applyChanges(SquirrelPreferences prefs) {
        UpdateSettings updateSettings = new UpdateSettings();
        updateSettings.setUpdateServer(this._updateServerName.getText());
        updateSettings.setUpdateServerPort(this._updateServerPort.getText());
        updateSettings.setUpdateServerPath(this._updateServerPath.getText());
        UpdateChannelComboBoxEntry channelEntry = (UpdateChannelComboBoxEntry)this._updateServerChannel.getSelectedItem();
        String channelStr = UpdateChannelComboBoxEntry.ChannelType.STABLE.name();
        if (channelEntry.isSnapshot()) {
            channelStr = UpdateChannelComboBoxEntry.ChannelType.SNAPSHOT.name();
        }
        updateSettings.setUpdateServerChannel(channelStr);
        updateSettings.setEnableAutomaticUpdates(this._enableAutoUpdateChk.isSelected());
        UpdateCheckFrequencyComboBoxEntry freqEntry = (UpdateCheckFrequencyComboBoxEntry)this._updateCheckFrequency.getSelectedItem();
        updateSettings.setUpdateCheckFrequency(freqEntry.getUpdateCheckFrequencyEnum().name());
        updateSettings.setRemoteUpdateSite(this._remoteTypeButton.isSelected());
        updateSettings.setFileSystemUpdatePath(this._localPath.getText());
        prefs.setUpdateSettings(updateSettings);
    }

    private void updateControlStatus() {
        boolean enableAutoCheck = this._enableAutoUpdateChk.isSelected();
        this._updateCheckFrequency.setEnabled(enableAutoCheck);
    }

    private void createUserInterface() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.createUpdateSitePanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.createAutoUpdatePanel(), gbc);
        MyActionHandler lis = new MyActionHandler();
        this._enableAutoUpdateChk.addActionListener(lis);
    }

    private JPanel createUpdateSitePanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(i18n.UPDATE_SITE_BORDER_LABEL));
        UrlItemListener urlUpdateItemListener = new UrlItemListener();
        UrlDocumentListener urlDocumentListener = new UrlDocumentListener();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setSeparatorConstraints(gbc, 0);
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        this.siteTypeLabel = new JLabel(i18n.SITE_TYPE_LABEL, 4);
        pnl.add((Component)this.siteTypeLabel, gbc);
        this.setSeparatorConstraints(gbc, 0);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        pnl.add((Component)this.getSiteTypePanel(), gbc);
        this.setSeparatorConstraints(gbc, 1);
        pnl.add((Component)this.getSep(), gbc);
        this.setLabelConstraints(gbc, 2);
        this._serverLabel = new JLabel(i18n.SERVER, 4);
        pnl.add((Component)this._serverLabel, gbc);
        this.setFieldConstraints(gbc, 2);
        this._updateServerName.getDocument().addDocumentListener(urlDocumentListener);
        pnl.add((Component)this._updateServerName, gbc);
        this.setLabelConstraints(gbc, 3);
        this._portLabel = new JLabel(i18n.PORT, 4);
        pnl.add((Component)this._portLabel, gbc);
        this.setFieldConstraints(gbc, 3);
        this._updateServerPort.getDocument().addDocumentListener(urlDocumentListener);
        pnl.add((Component)this._updateServerPort, gbc);
        this.setLabelConstraints(gbc, 4);
        this._pathLabel = new JLabel(i18n.PATH, 4);
        pnl.add((Component)this._pathLabel, gbc);
        this.setFieldConstraints(gbc, 4);
        this._updateServerPath.getDocument().addDocumentListener(urlDocumentListener);
        pnl.add((Component)this._updateServerPath, gbc);
        this.setLabelConstraints(gbc, 5);
        this._channelLabel = new JLabel(i18n.CHANNEL, 4);
        pnl.add((Component)this._channelLabel, gbc);
        this.setFieldConstraints(gbc, 5);
        gbc.fill = 0;
        this._updateServerChannel.addItemListener(urlUpdateItemListener);
        pnl.add((Component)this._updateServerChannel, gbc);
        this.setLabelConstraints(gbc, 6);
        this._urlLabel = new JLabel(i18n.URL, 4);
        pnl.add((Component)this._urlLabel, gbc);
        this.setFieldConstraints(gbc, 6);
        this.updateUrl();
        pnl.add((Component)this._updateUrl, gbc);
        this.setFieldConstraints(gbc, 7);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(this._testConnectionButton);
        buttonBox.add(Box.createHorizontalStrut(20));
        buttonBox.add(this._testConnectionStatusLabel);
        this._testConnectionButton.addActionListener(new TestConnectionButtonListener());
        pnl.add((Component)buttonBox, gbc);
        this.setSeparatorConstraints(gbc, 8);
        pnl.add((Component)this.getSep(), gbc);
        this.setLabelConstraints(gbc, 9);
        this._localPathLabel = new JLabel(i18n.LOCAL_PATH, 4);
        pnl.add((Component)this._localPathLabel, gbc);
        this.setFieldConstraints(gbc, 9);
        pnl.add((Component)this._localPath, gbc);
        return pnl;
    }

    private void setLabelConstraints(GridBagConstraints gbc, int gridy) {
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = this.LABEL_INSETS;
        gbc.fill = 0;
        gbc.anchor = 13;
    }

    private void setFieldConstraints(GridBagConstraints gbc, int gridy) {
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = this.FIELD_INSETS;
        gbc.fill = 2;
        gbc.anchor = 17;
    }

    private void setSeparatorConstraints(GridBagConstraints gbc, int gridy) {
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.insets = this.SEP_INSETS;
        gbc.fill = 2;
        gbc.anchor = 17;
    }

    private void enableRemoteSite() {
        this._localPath.setEnabled(false);
        this._localPathLabel.setEnabled(false);
        this._updateServerChannel.setEnabled(true);
        this._updateServerName.setEnabled(true);
        this._updateServerPath.setEnabled(true);
        this._updateServerPort.setEnabled(true);
        this._serverLabel.setEnabled(true);
        this._portLabel.setEnabled(true);
        this._pathLabel.setEnabled(true);
        this._channelLabel.setEnabled(true);
        this._testConnectionButton.setEnabled(true);
        this._testConnectionStatusLabel.setEnabled(true);
        this._updateUrl.setEnabled(true);
        this._urlLabel.setEnabled(true);
    }

    private void enableLocalPath() {
        this._localPath.setEnabled(true);
        this._localPathLabel.setEnabled(true);
        this._updateServerChannel.setEnabled(false);
        this._updateServerName.setEnabled(false);
        this._updateServerPath.setEnabled(false);
        this._updateServerPort.setEnabled(false);
        this._serverLabel.setEnabled(false);
        this._portLabel.setEnabled(false);
        this._pathLabel.setEnabled(false);
        this._channelLabel.setEnabled(false);
        this._testConnectionButton.setEnabled(false);
        this._testConnectionStatusLabel.setEnabled(false);
        this._updateUrl.setEnabled(false);
        this._urlLabel.setEnabled(false);
    }

    private void updateUrl() {
        String portStr = this._updateServerPort.getText();
        StringBuilder tmp = new StringBuilder("http://");
        tmp.append(this._updateServerName.getText());
        if (!StringUtilities.isEmpty((String)portStr)) {
            tmp.append(":");
            tmp.append(this._updateServerPort.getText());
        }
        tmp.append("/");
        tmp.append(this._updateServerPath.getText());
        tmp.append("/");
        tmp.append(this._updateServerChannel.getSelectedItem().toString());
        tmp.append("/release.xml");
        this._updateUrl.setText(tmp.toString());
        this._updateUrl.setEditable(false);
        this._updateUrl.revalidate();
    }

    private JPanel getSiteTypePanel() {
        this._remoteTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdatePreferencesPanel.this.enableRemoteSite();
            }
        });
        this._localTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdatePreferencesPanel.this.enableLocalPath();
            }
        });
        this._updateSiteTypeGroup.add(this._remoteTypeButton);
        this._updateSiteTypeGroup.add(this._localTypeButton);
        JPanel siteTypePanel = new JPanel();
        siteTypePanel.add(this._remoteTypeButton);
        siteTypePanel.add(this._localTypeButton);
        return siteTypePanel;
    }

    private JSeparator getSep() {
        JSeparator sep = new JSeparator(0);
        sep.setPreferredSize(new Dimension(100, 20));
        sep.setMinimumSize(new Dimension(100, 20));
        return sep;
    }

    private JPanel createAutoUpdatePanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(i18n.AUTO_BORDER_LABEL));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        pnl.add((Component)this._enableAutoUpdateChk, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(4, 20, 4, 10);
        pnl.add((Component)new JLabel(i18n.AUTO_CHECK_FREQUENCY, 2), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(4, 0, 4, 0);
        gbc.fill = 0;
        pnl.add((Component)this._updateCheckFrequency, gbc);
        return pnl;
    }

    public void setApplication(IApplication app) {
        this._app = app;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class UrlItemListener
    implements ItemListener {
        private UrlItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            UpdatePreferencesPanel.this.updateUrl();
        }
    }

    private class UrlDocumentListener
    implements DocumentListener {
        private UrlDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            UpdatePreferencesPanel.this.updateUrl();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            UpdatePreferencesPanel.this.updateUrl();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            UpdatePreferencesPanel.this.updateUrl();
        }
    }

    private class TestConnectionButtonListener
    implements ActionListener {
        private TestConnectionButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String serverName = UpdatePreferencesPanel.this._updateServerName.getText();
            StringBuilder path = new StringBuilder(UpdatePreferencesPanel.this._updateServerPath.getText());
            path.append("/");
            path.append(UpdatePreferencesPanel.this._updateServerChannel.getSelectedItem().toString());
            String portString = UpdatePreferencesPanel.this._updateServerPort.getText();
            try {
                int port = 80;
                if (!StringUtilities.isEmpty((String)portString)) {
                    port = Integer.parseInt(UpdatePreferencesPanel.this._updateServerPort.getText());
                }
                _updateUtil.downloadCurrentRelease(serverName, port, path.toString(), "release.xml", (IProxySettings)UpdatePreferencesPanel.this._app.getSquirrelPreferences().getProxySettings());
                UpdatePreferencesPanel.this._testConnectionStatusLabel.setText(i18n.STATUS_LABEL_SUCCESS_MSG);
                UpdatePreferencesPanel.this._testConnectionStatusLabel.setForeground(CONNECTION_SUCCESS_COLOR);
            }
            catch (Exception e1) {
                UpdatePreferencesPanel.this._testConnectionStatusLabel.setText(i18n.STATUS_LABEL_FAILURE_MSG);
                UpdatePreferencesPanel.this._testConnectionStatusLabel.setForeground(CONNECTION_FAILURE_COLOR);
                UpdatePreferencesPanel.this._app.showErrorDialog(i18n.CONNECTION_FAILURE_DIALOG_MSG, e1);
            }
        }
    }

    private final class MyActionHandler
    implements ActionListener {
        private MyActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            UpdatePreferencesPanel.this.updateControlStatus();
        }
    }

    static interface i18n {
        public static final String AT_STARTUP_LABEL = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.atStartupLabel");
        public static final String AUTO_BORDER_LABEL = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.autoBorderLabel");
        public static final String AUTO_CHECK_FREQUENCY = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.autoCheckFrequency");
        public static final String CHANNEL = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.channel");
        public static final String UPDATE_SITE_BORDER_LABEL = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.updateSiteBorderLabel");
        public static final String ENABLE_AUTO_UPDATE = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.enableAutoUpdate");
        public static final String LOCAL_PATH = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.localPathLabel");
        public static final String LOCAL_SITE_BUTTON_LABEL = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.localSiteButtonLabel");
        public static final String PATH = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.path");
        public static final String PORT = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.port");
        public static final String SERVER = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.server");
        public static final String DAILY_LABEL = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.dailyLabel");
        public static final String WEEKLY_LABEL = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.weeklyLabel");
        public static final String REMOTE_SITE_BUTTON_LABEL = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.remoteSiteButtonLabel");
        public static final String SITE_TYPE_LABEL = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.siteTypeLabel");
        public static final String TEST_LABEL = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.testLabel");
        public static final String URL = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.urlLabel");
        public static final String STATUS_LABEL_SUCCESS_MSG = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.statusLableSuccessMsg");
        public static final String STATUS_LABEL_FAILURE_MSG = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.statusLableFailureMsg");
        public static final String CONNECTION_FAILURE_DIALOG_MSG = UpdatePreferencesPanel.access$000().getString("UpdatePreferencesPanel.connectionFailureDialogMsg");
    }
}

