/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.EditWhereCols;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetUpdateableTableModelListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataModelImplementationDetails;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataSetUpdateableTableModelImpl
implements IDataSetUpdateableTableModel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataSetUpdateableTableModelImpl.class);
    private final String TI_ERROR_MESSAGE = s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.tablenotfound");
    private static final ILogger s_log = LoggerController.createLogger(DataSetUpdateableTableModelImpl.class);
    private String fullTableName = null;
    private ITableInfo ti;
    private ISession _session;
    private boolean editModeForced = false;
    String sqlOutputClassNameAtTimeOfForcedEdit = "";
    private Vector<DataSetUpdateableTableModelListener> _dataSetUpdateableTableModelListener = new Vector();
    int _rowIDcol = -1;

    public void setTableInfo(ITableInfo ti) {
        this.ti = ti;
        this.fullTableName = null;
    }

    public void setSession(ISession session) {
        this._session = session;
    }

    public static String getUnambiguousTableName(ISession session, String name) {
        return session.getAlias().getUrl() + ":" + name;
    }

    public String getFullTableName() {
        if (this.fullTableName == null) {
            try {
                String name = this.ti.getQualifiedName();
                this.fullTableName = DataSetUpdateableTableModelImpl.getUnambiguousTableName(this._session, name);
            }
            catch (Exception e) {
                s_log.error((Object)("getFullTableName: Unexpected exception - " + e.getMessage()), (Throwable)e);
            }
        }
        return this.fullTableName;
    }

    public void forceEditMode(boolean mode) {
        this.editModeForced = mode;
        this.sqlOutputClassNameAtTimeOfForcedEdit = this._session.getProperties().getTableContentsOutputClassName();
        DataSetUpdateableTableModelListener[] listeners = this._dataSetUpdateableTableModelListener.toArray(new DataSetUpdateableTableModelListener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].forceEditMode(mode);
        }
    }

    public boolean editModeIsForced() {
        return this.editModeForced;
    }

    public IDataModelImplementationDetails getDataModelImplementationDetails() {
        return new IDataModelImplementationDetails(){

            public String getStatementSeparator() {
                return DataSetUpdateableTableModelImpl.this._session.getQueryTokenizer().getSQLStatementSeparator();
            }
        };
    }

    public String getDestinationClassName() {
        if (this.editModeForced) {
            if (this._session.getProperties().getTableContentsOutputClassName().equals(this.sqlOutputClassNameAtTimeOfForcedEdit)) {
                return this._session.getProperties().getEditableTableOutputClassName();
            }
            this.editModeForced = false;
        }
        return this._session.getProperties().getTableContentsOutputClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWarningOnCurrentData(Object[] values, ColumnDisplayDefinition[] colDefs, int col, Object oldValue) {
        if (this.ti == null) {
            return this.TI_ERROR_MESSAGE;
        }
        String whereClause = this.getWhereClause(values, colDefs, col, oldValue);
        if (whereClause.length() == 0) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.confirmupdateallrows");
        }
        ISession session = this._session;
        ISQLConnection conn = session.getSQLConnection();
        int count = -1;
        try {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.createStatement();
                String countSql = "select count(*) from " + this.ti.getQualifiedName() + whereClause;
                rs = stmt.executeQuery(countSql);
                rs.next();
                count = rs.getInt(1);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement((Statement)stmt);
                throw throwable;
            }
            SQLUtilities.closeResultSet((ResultSet)rs);
            SQLUtilities.closeStatement((Statement)stmt);
        }
        catch (SQLException ex) {
            String msg = s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.exceptionduringcheck", new Object[]{ex.getMessage()});
            s_log.error((Object)msg, (Throwable)ex);
            return msg;
        }
        if (count == -1) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.unknownerror");
        }
        if (count == 0) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.staleupdaterow");
        }
        if (count > 1) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.info.updateidenticalrows", new Object[]{(long)count});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWarningOnProjectedUpdate(Object[] values, ColumnDisplayDefinition[] colDefs, int col, Object newValue) {
        try {
            if (this.ti == null) {
                return this.TI_ERROR_MESSAGE;
            }
            String whereClause = this.getWhereClause(values, colDefs, col, newValue);
            ISession session = this._session;
            ISQLConnection conn = session.getSQLConnection();
            int count = -1;
            try {
                Statement stmt = conn.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery("select count(*) from " + this.ti.getQualifiedName() + whereClause);
                    rs.next();
                    count = rs.getInt(1);
                }
                finally {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.exceptionduringcheck", new Object[]{ex.getMessage()});
            }
            if (count == -1) {
                return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.unknownerror");
            }
            if (count > 1) {
                return s_stringMgr.getString("DataSetUpdateableTableModelImpl.info.identicalrows", new Object[]{(long)count});
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object reReadDatum(Object[] values, ColumnDisplayDefinition[] colDefs, int col, StringBuffer message) {
        if (this.ti == null) {
            return this.TI_ERROR_MESSAGE;
        }
        String whereClause = this.getWhereClause(values, colDefs, -1, null);
        ISession session = this._session;
        ISQLConnection conn = session.getSQLConnection();
        Object wholeDatum = null;
        try {
            Statement stmt = conn.createStatement();
            String queryString = "SELECT " + colDefs[col].getColumnName() + " FROM " + this.ti.getQualifiedName() + whereClause;
            try {
                ResultSet rs = stmt.executeQuery(queryString);
                if (!rs.next()) {
                    throw new SQLException(s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.nomatchingrow"));
                }
                wholeDatum = CellComponentFactory.readResultSet((ColumnDisplayDefinition)colDefs[col], (ResultSet)rs, (int)1, (boolean)false);
                if (rs.next()) {
                    wholeDatum = null;
                    throw new SQLException(s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.multimatchingrows"));
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (Exception ex) {
            message.append(s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.rereadingdb", new Object[]{ex.getMessage()}));
        }
        return wholeDatum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateTableComponent(Object[] values, ColumnDisplayDefinition[] colDefs, int col, Object oldValue, Object newValue) {
        if (this.ti == null) {
            return this.TI_ERROR_MESSAGE;
        }
        String whereClause = this.getWhereClause(values, colDefs, col, oldValue);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("updateTableComponent: whereClause = " + whereClause));
        }
        ISession session = this._session;
        ISQLConnection conn = session.getSQLConnection();
        int count = -1;
        String sql = this.constructUpdateSql(this.ti.getQualifiedName(), colDefs[col].getColumnName(), whereClause);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("updateTableComponent: executing SQL - " + sql));
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            CellComponentFactory.setPreparedStatementValue((ColumnDisplayDefinition)colDefs[col], (PreparedStatement)pstmt, (Object)newValue, (int)1);
            count = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            String errMsg = s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.updateproblem", new Object[]{ex.getMessage()});
            s_log.error((Object)("updateTableComponent: unexpected exception - " + ex.getMessage() + " while executing SQL: " + sql));
            String string = errMsg;
            return string;
        }
        finally {
            SQLUtilities.closeStatement((Statement)pstmt);
        }
        if (count == -1) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.unknownupdateerror");
        }
        if (count == 0) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.info.norowsupdated");
        }
        return null;
    }

    private String constructUpdateSql(String table, String column, String whereClause) {
        StringBuilder result = new StringBuilder();
        result.append("UPDATE ");
        result.append(table);
        result.append(" SET ");
        result.append(column);
        result.append(" = ? ");
        result.append(whereClause);
        return result.toString();
    }

    public int getRowidCol() {
        return this._rowIDcol;
    }

    private String getWhereClause(Object[] values, ColumnDisplayDefinition[] colDefs, int col, Object colValue) {
        try {
            StringBuffer whereClause = new StringBuffer("");
            HashMap<String, String> colNames = EditWhereCols.get(this.getFullTableName());
            ColumnDisplayDefinition editedCol = null;
            if (-1 != col) {
                editedCol = colDefs[col];
            }
            for (int i = 0; i < colDefs.length; ++i) {
                ISQLDatabaseMetaData md;
                String clause;
                if (i != col && null != editedCol && colDefs[i].getFullTableColumnName().equalsIgnoreCase(editedCol.getFullTableColumnName()) || colNames != null && colNames.get(colDefs[i].getColumnName()) == null) continue;
                Object value = values[i];
                if (i == col) {
                    value = colValue;
                }
                if (value != null && value.toString().equals("<null>")) {
                    value = null;
                }
                if ((clause = CellComponentFactory.getWhereClauseValue((ColumnDisplayDefinition)colDefs[i], (Object)value, (ISQLDatabaseMetaData)(md = this._session.getMetaData()))) == null || clause.length() <= 0) continue;
                if (whereClause.length() == 0) {
                    whereClause.append(clause);
                    continue;
                }
                whereClause.append(" AND ");
                whereClause.append(clause);
            }
            if (whereClause.length() == 0) {
                return "";
            }
            whereClause.insert(0, " WHERE ");
            return whereClause.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteRows(Object[][] rowData, ColumnDisplayDefinition[] colDefs) {
        String msg;
        int option;
        Statement stmt;
        int i;
        if (this.ti == null) {
            return this.TI_ERROR_MESSAGE;
        }
        ISession session = this._session;
        ISQLConnection conn = session.getSQLConnection();
        String rowCountErrorMessage = "";
        for (i = 0; i < rowData.length; ++i) {
            String whereClause = this.getWhereClause(rowData[i], colDefs, -1, null);
            try {
                stmt = conn.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery("SELECT count(*) FROM " + this.ti.getQualifiedName() + whereClause);
                    rs.next();
                    if (rs.getInt(1) == 1) continue;
                    if (rs.getInt(1) == 0) {
                        rowCountErrorMessage = rowCountErrorMessage + s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.rownotmatch", new Object[]{i + 1});
                        continue;
                    }
                    rowCountErrorMessage = rowCountErrorMessage + s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.rowmatched", new Object[]{i + 1, rs.getInt(1)});
                    continue;
                }
                finally {
                    stmt.close();
                }
            }
            catch (Exception e) {
                return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.preparingdelete", new Object[]{e});
            }
        }
        if (rowCountErrorMessage.length() > 0 && (option = JOptionPane.showConfirmDialog(null, msg = s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.tabledbmismatch", new Object[]{rowCountErrorMessage}), "Warning", 0, 2)) != 0) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.info.deletecancelled");
        }
        for (i = 0; i < rowData.length; ++i) {
            String whereClause = this.getWhereClause(rowData[i], colDefs, -1, null);
            try {
                stmt = conn.createStatement();
                try {
                    stmt.executeUpdate("DELETE FROM " + this.ti.getQualifiedName() + whereClause);
                    continue;
                }
                finally {
                    stmt.close();
                }
            }
            catch (Exception e) {
                return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.deleteFailed", new Object[]{e});
            }
        }
        return null;
    }

    public String[] getDefaultValues(ColumnDisplayDefinition[] colDefs) {
        String[] defaultValues = new String[colDefs.length];
        if (this.ti == null) {
            return defaultValues;
        }
        ISession session = this._session;
        ISQLConnection conn = session.getSQLConnection();
        try {
            SQLDatabaseMetaData md = conn.getSQLMetaData();
            TableColumnInfo[] infos = md.getColumnInfo(this.ti);
            int expectedColDefIndex = 0;
            for (int idx = 0; idx < infos.length; ++idx) {
                String colName = infos[idx].getColumnName();
                String defValue = infos[idx].getDefaultValue();
                if (defValue != null && defValue.length() > 0) {
                    if (colDefs[expectedColDefIndex].getColumnName().equals(colName)) {
                        defaultValues[expectedColDefIndex] = defValue;
                    } else {
                        for (int i = 0; i < colDefs.length; ++i) {
                            if (!colDefs[i].getColumnName().equals(colName)) continue;
                            defaultValues[i] = defValue;
                            break;
                        }
                    }
                }
                ++expectedColDefIndex;
            }
        }
        catch (Exception ex) {
            s_log.error((Object)s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.retrievingdefaultvalues"), (Throwable)ex);
        }
        return defaultValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insertRow(Object[] values, ColumnDisplayDefinition[] colDefs) {
        if (this.ti == null) {
            return this.TI_ERROR_MESSAGE;
        }
        ISession session = this._session;
        ISQLConnection conn = session.getSQLConnection();
        int count = -1;
        try {
            int i;
            StringBuilder buf = new StringBuilder("INSERT INTO ");
            buf.append(this.ti.getQualifiedName());
            buf.append(" ( ");
            for (i = 0; i < colDefs.length; ++i) {
                if (i == this._rowIDcol) continue;
                if (colDefs[i].isAutoIncrement()) {
                    if (!s_log.isInfoEnabled()) continue;
                    s_log.info((Object)("insertRow: skipping auto-increment column " + colDefs[i].getColumnName()));
                    continue;
                }
                buf.append(colDefs[i].getColumnName());
                buf.append(",");
            }
            buf.setCharAt(buf.length() - 1, ')');
            buf.append(" VALUES (");
            for (i = 0; i < colDefs.length; ++i) {
                if (i == this._rowIDcol || colDefs[i].isAutoIncrement()) continue;
                buf.append(" ?,");
            }
            buf.setCharAt(buf.length() - 1, ')');
            String pstmtSQL = buf.toString();
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("insertRow: pstmt sql = " + pstmtSQL));
            }
            PreparedStatement pstmt = conn.prepareStatement(pstmtSQL);
            try {
                int bindVarIdx = 1;
                for (int i2 = 0; i2 < colDefs.length; ++i2) {
                    if (i2 == this._rowIDcol || colDefs[i2].isAutoIncrement()) continue;
                    CellComponentFactory.setPreparedStatementValue((ColumnDisplayDefinition)colDefs[i2], (PreparedStatement)pstmt, (Object)values[i2], (int)bindVarIdx);
                    ++bindVarIdx;
                }
                count = pstmt.executeUpdate();
            }
            finally {
                pstmt.close();
            }
        }
        catch (SQLException ex) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.duringInsert", new Object[]{ex.getMessage()});
        }
        if (count != 1) {
            return s_stringMgr.getString("DataSetUpdateableTableModelImpl.error.unknownerrorupdate");
        }
        try {
            IObjectTreeAPI api = this._session.getObjectTreeAPIOfActiveSessionWindow();
            api.refreshSelectedTab();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void addListener(DataSetUpdateableTableModelListener l) {
        this._dataSetUpdateableTableModelListener.add(l);
    }

    public void removeListener(DataSetUpdateableTableModelListener l) {
        this._dataSetUpdateableTableModelListener.remove(l);
    }

    public void setEditModeForced(boolean b) {
        this.editModeForced = b;
    }

    public void setRowIDCol(int rowIDCol) {
        this._rowIDcol = rowIDCol;
    }
}

