/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseListener;
import javax.swing.JTextArea;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import net.sourceforge.squirrel_sql.client.gui.dnd.FileEditorDropTargetListener;
import net.sourceforge.squirrel_sql.client.session.BaseSQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DefaultSQLEntryPanel
extends BaseSQLEntryPanel {
    private static ILogger s_log = LoggerController.createLogger(DefaultSQLEntryPanel.class);
    private ISession _session;
    private MyTextArea _comp;
    private DropTarget dt;

    public DefaultSQLEntryPanel(ISession session) {
        super(session.getApplication());
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        this._session = session;
        this._comp = new MyTextArea(session);
        this.dt = new DropTarget(this._comp, new FileEditorDropTargetListener(session));
    }

    @Override
    public JTextComponent getTextComponent() {
        return this._comp;
    }

    @Override
    public boolean getDoesTextComponentHaveScroller() {
        return false;
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener lis) {
        this._comp.getDocument().addUndoableEditListener(lis);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener lis) {
        this._comp.getDocument().removeUndoableEditListener(lis);
    }

    @Override
    public boolean hasOwnUndoableManager() {
        return false;
    }

    @Override
    public String getText() {
        return this._comp.getText();
    }

    @Override
    public String getSelectedText() {
        return this._comp.getSelectedText();
    }

    @Override
    public void setText(String sqlScript) {
        this.setText(sqlScript, true);
    }

    @Override
    public void setText(String sqlScript, boolean select) {
        this._comp.setText(sqlScript);
        if (select) {
            this.setSelectionEnd(this.getText().length());
            this.setSelectionStart(0);
        }
        this._comp.setCaretPosition(0);
    }

    @Override
    public void appendText(String sqlScript) {
        this.appendText(sqlScript, false);
    }

    @Override
    public void appendText(String sqlScript, boolean select) {
        int start = select ? this.getText().length() : 0;
        this._comp.append(sqlScript);
        if (select) {
            this.setSelectionEnd(this.getText().length());
            this.setSelectionStart(start);
        }
    }

    @Override
    public void replaceSelection(String sqlScript) {
        this._comp.replaceSelection(sqlScript);
    }

    @Override
    public int getCaretPosition() {
        return this._comp.getCaretPosition();
    }

    @Override
    public void setTabSize(int tabSize) {
        this._comp.setTabSize(tabSize);
    }

    @Override
    public void setFont(Font font) {
        this._comp.setFont(font);
    }

    @Override
    public void addMouseListener(MouseListener lis) {
        this._comp.addMouseListener(lis);
    }

    @Override
    public void removeMouseListener(MouseListener lis) {
        this._comp.removeMouseListener(lis);
    }

    @Override
    public void setCaretPosition(int pos) {
        this._comp.setCaretPosition(pos);
    }

    @Override
    public int getCaretLineNumber() {
        try {
            return this._comp.getLineOfOffset(this._comp.getCaretPosition());
        }
        catch (BadLocationException ex) {
            return 0;
        }
    }

    @Override
    public int getCaretLinePosition() {
        int caretPos;
        int caretLineOffset = caretPos = this._comp.getCaretPosition();
        try {
            caretLineOffset = this._comp.getLineStartOffset(this.getCaretLineNumber());
        }
        catch (BadLocationException ex) {
            s_log.error((Object)"BadLocationException in getCaretLinePosition", (Throwable)ex);
        }
        return caretPos - caretLineOffset;
    }

    @Override
    public int getSelectionStart() {
        return this._comp.getSelectionStart();
    }

    @Override
    public void setSelectionStart(int pos) {
        this._comp.setSelectionStart(pos);
    }

    @Override
    public int getSelectionEnd() {
        return this._comp.getSelectionEnd();
    }

    @Override
    public void setSelectionEnd(int pos) {
        this._comp.setSelectionEnd(pos);
    }

    @Override
    public boolean hasFocus() {
        return this._comp.hasFocus();
    }

    @Override
    public void requestFocus() {
        this._comp.requestFocus();
    }

    @Override
    public void addCaretListener(CaretListener lis) {
        this._comp.addCaretListener(lis);
    }

    @Override
    public void removeCaretListener(CaretListener lis) {
        this._comp.removeCaretListener(lis);
    }

    @Override
    public void addSQLTokenListener(SQLTokenListener tl) {
    }

    @Override
    public void removeSQLTokenListener(SQLTokenListener tl) {
    }

    @Override
    public ISession getSession() {
        return this._session;
    }

    @Override
    public void setUndoManager(UndoManager manager) {
    }

    private static class MyTextArea
    extends JTextArea {
        private MyTextArea(ISession session) {
            SessionProperties props = session.getProperties();
            FontInfo fi = props.getFontInfo();
            if (fi != null) {
                this.setFont(props.getFontInfo().createFont());
            }
        }
    }
}

