/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.sql.Statement;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SessionConnectionKeepAlive
implements Runnable {
    private static final ILogger s_log = LoggerController.createLogger(SessionConnectionKeepAlive.class);
    private final long sleepMillis;
    private final ISQLConnection sqlConn;
    private final String sql;
    private volatile boolean isStopped = false;
    private final String aliasName;

    public SessionConnectionKeepAlive(ISQLConnection con, long sleepMillis, String sql, String aliasName) {
        if (sleepMillis < 1000L) {
            throw new IllegalArgumentException("Sleep time must be at least 1000ms(1 second)");
        }
        this.sleepMillis = sleepMillis;
        Utilities.checkNull((String)"SessionConnectionKeepAlive", (Object[])new Object[]{"con", con, "sql", sql});
        this.sqlConn = con;
        this.sql = sql;
        this.aliasName = aliasName;
    }

    public void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isStopped) {
            Statement stmt = null;
            try {
                stmt = this.sqlConn.createStatement();
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("SessionConnectionKeepAlive (" + this.aliasName + ") running SQL: " + this.sql));
                }
                stmt.executeQuery(this.sql);
            }
            catch (Throwable t) {
                s_log.error((Object)("run: unexpected exception while executing sql (" + this.sql + "): " + t.getMessage()), t);
            }
            finally {
                SQLUtilities.closeStatement((Statement)stmt);
            }
            Utilities.sleep((long)this.sleepMillis);
        }
    }
}

