/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.ISQLAliasExt;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.session.IAllowedSchemaChecker;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.Session;
import net.sourceforge.squirrel_sql.client.session.event.ISessionListener;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IntegerIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SessionManager {
    private static final ILogger s_log = LoggerController.createLogger(SessionManager.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionManager.class);
    private final IApplication _app;
    private ISession _activeSession;
    private final LinkedList<ISession> _sessionsList = new LinkedList();
    private final Map<IIdentifier, ISession> _sessionsById = new HashMap<IIdentifier, ISession>();
    private EventListenerList listenerList = new EventListenerList();
    private final IntegerIdentifierFactory _idFactory = new IntegerIdentifierFactory(1);
    private ArrayList<IAllowedSchemaChecker> _allowedSchemaCheckers = new ArrayList();
    private Hashtable<IIdentifier, String[]> _allowedSchemasBySessionID = new Hashtable();
    private HashSet<IIdentifier> _inCloseSession = new HashSet();

    public SessionManager(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
    }

    public synchronized ISession createSession(IApplication app, ISQLDriver driver, SQLAlias alias, SQLConnection conn, String user, String password) {
        if (app == null) {
            throw new IllegalArgumentException("null IApplication passed");
        }
        if (driver == null) {
            throw new IllegalArgumentException("null ISQLDriver passed");
        }
        if (alias == null) {
            throw new IllegalArgumentException("null ISQLAlias passed");
        }
        if (conn == null) {
            throw new IllegalArgumentException("null SQLConnection passed");
        }
        Session sess = new Session(app, driver, alias, conn, user, password, this._idFactory.createIdentifier());
        this._sessionsList.addLast(sess);
        this._sessionsById.put(sess.getIdentifier(), sess);
        this.fireSessionAdded(sess);
        this.setActiveSession(sess);
        return sess;
    }

    public void setActiveSession(ISession session) {
        if (session != this._activeSession) {
            this._activeSession = session;
            this.fireSessionActivated(session);
        }
    }

    public synchronized ISession[] getConnectedSessions() {
        return this._sessionsList.toArray(new ISession[this._sessionsList.size()]);
    }

    public synchronized ISession getActiveSession() {
        return this._activeSession;
    }

    public synchronized ISession getNextSession(ISession session) {
        int sessionCount = this._sessionsList.size();
        int idx = this._sessionsList.indexOf(session);
        if (idx != -1) {
            if (++idx >= sessionCount) {
                idx = 0;
            }
            return this._sessionsList.get(idx);
        }
        s_log.error((Object)("SessionManager.getNextSession()-> Session " + session.getIdentifier() + " not found in _sessionsList"));
        if (sessionCount > 0) {
            s_log.error((Object)"SessionManager.getNextSession()-> Returning first session");
            return this._sessionsList.getFirst();
        }
        s_log.error((Object)"SessionManager.getNextSession()-> List empty so returning passed session");
        return session;
    }

    public synchronized ISession getPreviousSession(ISession session) {
        int sessionCount = this._sessionsList.size();
        int idx = this._sessionsList.indexOf(session);
        if (idx != -1) {
            if (--idx < 0) {
                idx = sessionCount - 1;
            }
            return this._sessionsList.get(idx);
        }
        s_log.error((Object)("SessionManager.getPreviousSession()-> Session " + session.getIdentifier() + " not found in _sessionsList"));
        if (sessionCount > 0) {
            s_log.error((Object)"SessionManager.getPreviousSession()-> Returning last session");
            return this._sessionsList.getLast();
        }
        s_log.error((Object)"SessionManager.getPreviousSession()-> List empty so returning passed session");
        return session;
    }

    public ISession getSession(IIdentifier sessionID) {
        return this._sessionsById.get(sessionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean closeSession(ISession session) {
        block16: {
            if (session == null) {
                throw new IllegalArgumentException("ISession == null");
            }
            try {
                if (this._inCloseSession.contains(session.getIdentifier())) {
                    boolean bl = false;
                    return bl;
                }
                this._inCloseSession.add(session.getIdentifier());
                if (!this.confirmClose(session)) break block16;
                session.getApplication().getPluginManager().sessionEnding(session);
                this.fireSessionClosing(session);
                try {
                    session.close();
                }
                catch (SQLException sqle) {
                    s_log.error((Object)"Error closing Session", (Throwable)sqle);
                    session.showErrorMessage(s_stringMgr.getString("SessionManager.ErrorClosingSession", new Object[]{sqle}));
                }
                this.fireSessionClosed(session);
                IIdentifier sessionId = session.getIdentifier();
                if (!this._sessionsList.remove(session)) {
                    s_log.error((Object)("SessionManager.closeSession()-> Session " + sessionId + " not found in _sessionsList when trying to remove it."));
                }
                if (this._sessionsById.remove(sessionId) == null) {
                    s_log.error((Object)("SessionManager.closeSession()-> Session " + sessionId + " not found in _sessionsById when trying to remove it."));
                }
                if (this._sessionsList.isEmpty()) {
                    this.fireAllSessionsClosed();
                }
                if (session == this._activeSession) {
                    if (!this._sessionsList.isEmpty()) {
                        this.setActiveSession(this._sessionsList.getLast());
                    } else {
                        this._activeSession = null;
                    }
                }
                this._allowedSchemasBySessionID.remove(session.getIdentifier());
                boolean bl = true;
                return bl;
            }
            catch (Throwable ex) {
                s_log.error((Object)"Error closing Session", ex);
                session.showErrorMessage(s_stringMgr.getString("SessionManager.ErrorClosingSession", new Object[]{ex}));
            }
            finally {
                this._inCloseSession.remove(session.getIdentifier());
            }
        }
        return false;
    }

    public synchronized boolean closeAllSessions() {
        ISession[] sessions = this.getConnectedSessions();
        for (int i = sessions.length - 1; i >= 0; --i) {
            if (this.closeSession(sessions[i])) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean closeAllButCurrentSessions() {
        ISession activeSession = this.getActiveSession();
        ISession[] sessions = this.getConnectedSessions();
        for (int i = sessions.length - 1; i >= 0; --i) {
            if (sessions[i] == activeSession || this.closeSession(sessions[i])) continue;
            return false;
        }
        return true;
    }

    public void addSessionListener(ISessionListener lis) {
        if (lis != null) {
            this.listenerList.add(ISessionListener.class, lis);
        } else {
            s_log.error((Object)"Attempted to add null listener: SessionManager.addSessionListener");
        }
    }

    public void removeSessionListener(ISessionListener lis) {
        if (lis != null) {
            this.listenerList.remove(ISessionListener.class, lis);
        } else {
            s_log.error((Object)"Attempted to remove null listener: SessionManager.addSessionListener");
        }
    }

    protected void fireSessionAdded(ISession session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).sessionConnected(evt);
        }
    }

    protected void fireSessionClosed(ISession session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).sessionClosed(evt);
        }
    }

    protected void fireSessionClosing(ISession session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).sessionClosing(evt);
        }
    }

    protected void fireAllSessionsClosed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            ((ISessionListener)listeners[i + 1]).allSessionsClosed();
        }
    }

    protected void fireSessionActivated(ISession session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).sessionActivated(evt);
        }
    }

    private boolean confirmClose(ISession session) {
        if (!this._app.getSquirrelPreferences().getConfirmSessionClose()) {
            return session.confirmClose();
        }
        String msg = s_stringMgr.getString("SessionManager.confirmClose", new Object[]{session.getTitle()});
        if (!Dialogs.showYesNo((Component)this._app.getMainFrame(), (String)msg)) {
            return false;
        }
        return session.confirmClose();
    }

    protected void fireConnectionClosedForReconnect(Session session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).connectionClosedForReconnect(evt);
        }
    }

    protected void fireReconnected(Session session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).reconnected(evt);
        }
    }

    protected void fireReconnectFailed(Session session) {
        Object[] listeners = this.listenerList.getListenerList();
        SessionEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISessionListener.class) continue;
            if (evt == null) {
                evt = new SessionEvent(session);
            }
            ((ISessionListener)listeners[i + 1]).reconnectFailed(evt);
        }
    }

    protected void fireSessionFinalized(final IIdentifier sessionIdentifier) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] listeners = SessionManager.this.listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ISessionListener.class) continue;
                    ((ISessionListener)listeners[i + 1]).sessionFinalized(sessionIdentifier);
                }
            }
        });
    }

    public void addAllowedSchemaChecker(IAllowedSchemaChecker allowedSchemaChecker) {
        this._allowedSchemaCheckers.add(allowedSchemaChecker);
    }

    public boolean areAllSchemasAllowed(ISession session) {
        try {
            String[] allowedSchemas = this.getAllowedSchemas(session);
            String[] schemas = session.getSQLConnection().getSQLMetaData().getSchemas();
            return allowedSchemas.length == schemas.length;
        }
        catch (SQLException e) {
            s_log.error((Object)"Failed to check allowed Schemas", (Throwable)e);
            return true;
        }
    }

    public String[] getAllowedSchemas(ISession session) {
        String[] allowedSchemas = this._allowedSchemasBySessionID.get(session.getIdentifier());
        if (null == allowedSchemas) {
            allowedSchemas = this.getAllowedSchemas(session.getSQLConnection(), session.getAlias());
            this._allowedSchemasBySessionID.put(session.getIdentifier(), allowedSchemas);
        }
        return allowedSchemas;
    }

    public String[] getAllowedSchemas(ISQLConnection con, ISQLAliasExt alias) {
        try {
            HashMap<String, Object> uniqueAllowedSchemas = null;
            for (int i = 0; i < this._allowedSchemaCheckers.size(); ++i) {
                String[] allowedSchemas = null;
                try {
                    allowedSchemas = this._allowedSchemaCheckers.get(i).getAllowedSchemas(con, alias);
                }
                catch (Exception e) {
                    s_log.error((Object)"Failed to get allowed Schemas from Plugin", (Throwable)e);
                }
                if (null == allowedSchemas) continue;
                if (null == uniqueAllowedSchemas) {
                    uniqueAllowedSchemas = new HashMap<String, Object>();
                }
                for (int j = 0; j < allowedSchemas.length; ++j) {
                    uniqueAllowedSchemas.put(allowedSchemas[j], null);
                }
            }
            if (null == uniqueAllowedSchemas) {
                return con.getSQLMetaData().getSchemas();
            }
            ArrayList list = new ArrayList(uniqueAllowedSchemas.keySet());
            Collections.sort(list);
            return list.toArray(new String[list.size()]);
        }
        catch (Exception e) {
            s_log.error((Object)"Failed to get allowed Schemas", (Throwable)e);
            return new String[0];
        }
    }

    public void clearAllowedSchemaCache(ISession session) {
        this._allowedSchemasBySessionID.remove(session.getIdentifier());
    }
}

