/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.action.IObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.action.SQLFilterCommand;
import net.sourceforge.squirrel_sql.fw.gui.CursorChanger;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLFilterAction
extends SquirrelAction
implements IObjectTreeAction {
    private static final long serialVersionUID = 1L;
    private transient IObjectTreeAPI _tree;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLFilterAction.class);

    public SQLFilterAction(IApplication app) {
        super(app);
    }

    @Override
    public void setObjectTree(IObjectTreeAPI tree) {
        this._tree = tree;
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SQLFilterAction.this.setEnabled(null != SQLFilterAction.this._tree);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent evt) {
        if (this._tree != null) {
            IDatabaseObjectInfo[] selObjs = this._tree.getSelectedDatabaseObjects();
            int objectTotal = selObjs.length;
            if (objectTotal == 1 && (selObjs[0].getDatabaseObjectType() == DatabaseObjectType.TABLE || selObjs[0].getDatabaseObjectType() == DatabaseObjectType.VIEW)) {
                IApplication app = this.getApplication();
                CursorChanger cursorChg = new CursorChanger((Component)app.getMainFrame());
                cursorChg.show();
                try {
                    new SQLFilterCommand(this._tree, selObjs[0]).execute();
                }
                finally {
                    cursorChg.restore();
                }
            } else {
                String msg = s_stringMgr.getString("SQLFilterAction.singleObjectMessage");
                this._tree.getSession().showMessage(msg);
            }
        }
    }
}

