/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.action.IObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.action.SetDefaultCatalogCommand;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SetDefaultCatalogAction
extends SquirrelAction
implements IObjectTreeAction {
    private static final ILogger s_log = LoggerController.createLogger(SetDefaultCatalogAction.class);
    private IObjectTreeAPI _tree;

    public SetDefaultCatalogAction(IApplication app) {
        super(app);
    }

    @Override
    public void setObjectTree(IObjectTreeAPI tree) {
        this._tree = tree;
        this.setEnabled(null != this._tree);
    }

    public void actionPerformed(ActionEvent evt) {
        IDatabaseObjectInfo[] catalogs = this._tree.getSelectedDatabaseObjects();
        if (catalogs.length == 1) {
            String catalog = catalogs[0].getSimpleName();
            try {
                new SetDefaultCatalogCommand(this._tree.getSession(), catalog).execute();
            }
            catch (Throwable th) {
                this._tree.getSession().showErrorMessage(th);
                s_log.error((Object)("Error occured setting session catalog to " + catalog), th);
            }
        } else {
            this._tree.getSession().getApplication().showErrorDialog("Must select a single catalog");
        }
    }
}

