/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.IToggleAction;
import net.sourceforge.squirrel_sql.fw.gui.ToggleComponentHolder;

public class ToggleAutoCommitAction
extends SquirrelAction
implements ISessionAction,
IToggleAction {
    static final long serialVersionUID = 4894924988552643833L;
    private ISession _session;
    private PropertyChangeListener _propertyListener;
    private boolean _inActionPerformed;
    private ToggleComponentHolder _toogleComponentHolder = new ToggleComponentHolder();

    public ToggleAutoCommitAction(IApplication app) {
        super(app);
        this._propertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("autoCommit".equals(evt.getPropertyName())) {
                    Boolean autoCom = (Boolean)evt.getNewValue();
                    ToggleAutoCommitAction.this._toogleComponentHolder.setSelected(autoCom.booleanValue());
                }
            }
        };
        this.setEnabled(false);
    }

    @Override
    public void setSession(final ISession session) {
        if (null != this._session) {
            this._session.getProperties().removePropertyChangeListener(this._propertyListener);
        }
        this._session = session;
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (session == null || session.getProperties() == null) {
                    ToggleAutoCommitAction.this.setEnabled(false);
                    ToggleAutoCommitAction.this._toogleComponentHolder.setSelected(false);
                } else {
                    SessionProperties props = session.getProperties();
                    ToggleAutoCommitAction.this.setEnabled(true);
                    props.addPropertyChangeListener(ToggleAutoCommitAction.this._propertyListener);
                    ToggleAutoCommitAction.this._toogleComponentHolder.setSelected(props.getAutoCommit());
                }
            }
        });
    }

    public ToggleComponentHolder getToggleComponentHolder() {
        return this._toogleComponentHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent evt) {
        try {
            if (this._inActionPerformed) {
                return;
            }
            this._inActionPerformed = true;
            this._session.getProperties().setAutoCommit(this._toogleComponentHolder.isSelected());
        }
        finally {
            this._inActionPerformed = false;
        }
    }
}

