/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.session.CancelStatementThread;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class PleaseWaitDialog
extends DialogWidget
implements ActionListener {
    private static final long serialVersionUID = 8870277695490954084L;
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(PleaseWaitDialog.class);
    private JButton cancelButton;
    private IMessageHandler messageHandler;
    private Statement stmt;

    public PleaseWaitDialog(Statement stmt, IApplication app) {
        super(stringMgr.getString("PleaseWaitDialog.queryExecuting"), true, app);
        this.messageHandler = app.getMessageHandler();
        this.stmt = stmt;
        this.makeToolWindow(true);
        JPanel content = new JPanel(new BorderLayout());
        content.add(this.createMainPanel(), "Center");
        this.setContentPane(content);
        this.pack();
    }

    private Component createMainPanel() {
        FormLayout layout = new FormLayout("center:pref", "pref, 6dlu, pref, 6dlu, pref, 6dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.setDefaultDialogBorder();
        int y = 1;
        builder.addSeparator(this.getTitle(), cc.xywh(1, y, 1, 1));
        builder.addLabel(stringMgr.getString("PleaseWaitDialog.pleaseWait"), cc.xy(1, y += 2));
        builder.addSeparator("", cc.xywh(1, y += 2, 1, 1));
        this.cancelButton = new JButton(stringMgr.getString("PleaseWaitDialog.cancel"));
        this.cancelButton.addActionListener(this);
        builder.add((Component)this.cancelButton, cc.xywh(1, y += 2, 1, 1));
        return builder.getPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.stmt != null) {
            CancelStatementThread cst = new CancelStatementThread(this.stmt, this.messageHandler);
            cst.tryCancel();
        }
    }

    public void showDialog(IApplication app) {
        app.getMainFrame().addWidget(this);
        this.moveToFront();
        this.setLayer(JLayeredPane.MODAL_LAYER);
        DialogWidget.centerWithinDesktop(this);
        this.setVisible(true);
    }
}

