/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionDialogWidget;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ReturnResultTabAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultFrame
extends SessionDialogWidget {
    private static ILogger s_log = LoggerController.createLogger(ResultFrame.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultFrame.class);
    private IResultTab _tab;
    private JCheckBox _chkOnTop;

    public ResultFrame(ISession session, IResultTab tab) {
        super(ResultFrame.getFrameTitle(session, tab), true, true, true, true, session);
        this._tab = tab;
        this.setDefaultCloseOperation(2);
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        IApplication app = session.getApplication();
        JPanel pnlButtons = new JPanel(new GridBagLayout());
        JButton rtnBtn = new JButton((Action)((Object)new ReturnResultTabAction(app, this)));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0);
        pnlButtons.add((Component)rtnBtn, gbc);
        this._chkOnTop = new JCheckBox(s_stringMgr.getString("resultFrame.stayOnTop"));
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
        pnlButtons.add((Component)this._chkOnTop, gbc);
        this._chkOnTop.setSelected(true);
        this._chkOnTop.setVisible(session.getApplication().getDesktopStyle().supportsLayers());
        this._chkOnTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultFrame.this.onStayOnTopChanged();
            }
        });
        gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
        pnlButtons.add((Component)new JPanel(), gbc);
        cont.add((Component)pnlButtons, "North");
        cont.add(tab.getOutputComponent(), "Center");
    }

    private void onStayOnTopChanged() {
        if (this._chkOnTop.isSelected()) {
            this.setLayer((int)JLayeredPane.PALETTE_LAYER);
        } else {
            this.setLayer((int)JLayeredPane.DEFAULT_LAYER);
        }
        this.toFront();
    }

    @Override
    public void dispose() {
        if (this._tab != null) {
            this._tab.closeTab();
            this._tab = null;
        }
        super.dispose();
    }

    public void returnToTabbedPane() {
        s_log.debug((Object)"ResultFrame.returnToTabbedPane()");
        this.getContentPane().remove(this._tab.getOutputComponent());
        this._tab.returnToTabbedPane();
        this._tab = null;
        this.dispose();
    }

    private static String getFrameTitle(ISession session, IResultTab tab) throws IllegalArgumentException {
        if (tab == null) {
            throw new IllegalArgumentException("Null ResultTab passed");
        }
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        return session.getTitle() + " - " + tab.getViewableSqlString();
    }
}

