/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.gui.SortableTable;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLHistoryDlg
extends JDialog {
    private static final String PREF_KEY_SQL_HISTORY_DLG_WIDTH = "Squirrel.sqlHistoryDlgWidth";
    private static final String PREF_KEY_SQL_HISTORY_DLG_HEIGHT = "Squirrel.sqlHistoryDlgHeight";
    private static final String PREF_KEY_SQL_HISTORY_DLG_DIV_LOC = "Squirrel.sqlHistoryDlgDivLoc";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLHistoryDlg.class);
    SortableTable tblHistoryItems;
    JButton btnClose;
    JTextField txtFilter;
    JButton btnApplyFilter;
    JComboBox cboFilterItems;
    JCheckBox chkFiltered;
    JSplitPane splSpilt;
    JTextArea txtSQL;

    public SQLHistoryDlg(JFrame mainFrame, String sqlPanelParentFrameName) {
        super(mainFrame, s_stringMgr.getString("SQLHistoryDlg.title", new Object[]{sqlPanelParentFrameName}), false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createFilterPanel(), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0);
        this.splSpilt = new JSplitPane(0);
        this.getContentPane().add((Component)this.splSpilt, gbc);
        this.tblHistoryItems = new SortableTable(new SortableTableModel(null));
        this.tblHistoryItems.setSelectionMode(2);
        this.tblHistoryItems.getTableHeader().setResizingAllowed(true);
        this.tblHistoryItems.getTableHeader().setReorderingAllowed(true);
        this.tblHistoryItems.setAutoCreateColumnsFromModel(false);
        this.tblHistoryItems.setAutoResizeMode(0);
        this.splSpilt.setTopComponent(new JScrollPane((Component)this.tblHistoryItems));
        this.txtSQL = new JTextArea();
        this.txtSQL.setEditable(false);
        this.splSpilt.setBottomComponent(new JScrollPane(this.txtSQL));
        Dimension size = this.getDimension(mainFrame);
        this.setSize(size);
        this.splSpilt.setDividerLocation(Preferences.userRoot().getInt(PREF_KEY_SQL_HISTORY_DLG_DIV_LOC, size.height / 3));
        this.addWindowListener(new WindowAdapter(){
            boolean onWindowClosedCalled = false;

            @Override
            public void windowClosed(WindowEvent e) {
                if (!this.onWindowClosedCalled) {
                    SQLHistoryDlg.this.onWindowClosed();
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                SQLHistoryDlg.this.onWindowClosed();
                this.onWindowClosedCalled = true;
            }
        });
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel createFilterPanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("SQLHistoryDlg.SQLPref")), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        this.cboFilterItems = new JComboBox();
        ret.add((Component)this.cboFilterItems, gbc);
        for (FilterCboItems filterCboItem : FilterCboItems.values()) {
            this.cboFilterItems.addItem(filterCboItem);
        }
        gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        this.txtFilter = new JTextField();
        ret.add((Component)this.txtFilter, gbc);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQLHistoryDlg.this.txtFilter.requestFocus();
            }
        });
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
        this.btnApplyFilter = new JButton(s_stringMgr.getString("SQLHistoryDlg.applyFilter"));
        ret.add((Component)this.btnApplyFilter, gbc);
        this.getRootPane().setDefaultButton(this.btnApplyFilter);
        gbc = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
        this.chkFiltered = new JCheckBox(s_stringMgr.getString("SQLHistoryDlg.filtered"));
        ret.add((Component)this.chkFiltered, gbc);
        this.btnClose = new JButton(s_stringMgr.getString("SQLHistoryDlg.close"));
        gbc = new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0);
        ret.add((Component)this.btnClose, gbc);
        return ret;
    }

    private Dimension getDimension(JFrame mainFrame) {
        int prefWidth = Preferences.userRoot().getInt(PREF_KEY_SQL_HISTORY_DLG_WIDTH, 600);
        int perfHeight = Preferences.userRoot().getInt(PREF_KEY_SQL_HISTORY_DLG_HEIGHT, 600);
        return new Dimension(Math.min(prefWidth, mainFrame.getSize().width), Math.min(perfHeight, mainFrame.getSize().height));
    }

    private void onWindowClosed() {
        Dimension size = this.getSize();
        Preferences.userRoot().putInt(PREF_KEY_SQL_HISTORY_DLG_WIDTH, size.width);
        Preferences.userRoot().putInt(PREF_KEY_SQL_HISTORY_DLG_HEIGHT, size.height);
        Preferences.userRoot().putInt(PREF_KEY_SQL_HISTORY_DLG_DIV_LOC, this.splSpilt.getDividerLocation());
    }

    static /* synthetic */ StringManager access$100() {
        return s_stringMgr;
    }

    static enum FilterCboItems {
        CONTAINS(SQLHistoryDlg.access$100().getString("SQLHistoryDlg.filterCboContains")),
        STARTS_WITH(SQLHistoryDlg.access$100().getString("SQLHistoryDlg.filterCboStartsWith")),
        ENDS_WITH(SQLHistoryDlg.access$100().getString("SQLHistoryDlg.filterCboEndsWith")),
        REG_EX(SQLHistoryDlg.access$100().getString("SQLHistoryDlg.filterCboRegEx"));

        private String _name;

        private FilterCboItems(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

