/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.io.Serializable;
import java.util.Date;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class SQLHistoryItem
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String _sql;
    private Date _lastUsageTime;
    private String _shortSql;
    private String _aliasName;

    public SQLHistoryItem() {
        this("", "");
    }

    public SQLHistoryItem(String sql, String aliasName) {
        if (sql == null) {
            throw new IllegalArgumentException("sql == null");
        }
        this._aliasName = aliasName;
        if (0 < sql.length()) {
            this._lastUsageTime = new Date();
        }
        this.setSQL(sql);
    }

    public boolean equals(Object rhs) {
        boolean rc = false;
        if (this == rhs) {
            rc = true;
        } else if (rhs != null && rhs.getClass().equals(this.getClass())) {
            rc = ((SQLHistoryItem)rhs).getSQL().equals(this.getSQL());
        }
        return rc;
    }

    public int hashCode() {
        return this.getSQL().hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public String toString() {
        return this._shortSql;
    }

    public String getSQL() {
        return this._sql;
    }

    public void setSQL(String sql) {
        if (sql == null) {
            throw new IllegalArgumentException("sql == null");
        }
        this._sql = sql.trim();
        this._shortSql = StringUtilities.cleanString((String)sql);
    }

    public Date getLastUsageTime() {
        return this._lastUsageTime;
    }

    public void setLastUsageTime(Date _creationTime) {
        this._lastUsageTime = _creationTime;
    }

    public String getAliasName() {
        return this._aliasName;
    }

    public void setAliasName(String _aliasName) {
        this._aliasName = _aliasName;
    }
}

